/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class WatcherCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"watcher").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> WatcherCommand.info((class_2168)context.getSource()))).then(class_2170.method_9247((String)"info").executes(context -> WatcherCommand.info((class_2168)context.getSource())))).then(class_2170.method_9247((String)"list").executes(context -> WatcherCommand.listWatchers((class_2168)context.getSource())))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> WatcherCommand.addWatchers((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> WatcherCommand.removeWatchers((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"))))));
    }

    private static int info(class_2168 source) {
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77Watchers are players that are online, but are not affected by most season mechanics. They can only observe."));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77This is very useful for spectators and for admins."));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a78\u00a7oNOTE: This is an experimental feature, report any bugs you find!"));
        return 1;
    }

    private static int listWatchers(class_2168 source) {
        if (WatcherManager.getWatchers().isEmpty()) {
            source.method_9213(class_2561.method_30163((String)"There are no Watchers right now"));
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.formatLoosely("Current Watchers: \u00a77{}", WatcherManager.getWatchers()));
        return 1;
    }

    private static int addWatchers(class_2168 source, Collection<class_3222> targets) {
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        targets.forEach(WatcherManager::addWatcher);
        WatcherManager.reloadWatchers();
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} is now a Watcher", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} targets are now Watchers", targets.size()));
        }
        return 1;
    }

    private static int removeWatchers(class_2168 source, Collection<class_3222> targets) {
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        targets.forEach(WatcherManager::removeWatcher);
        WatcherManager.reloadWatchers();
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} is no longer a Watcher", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} targets are no longer Watchers", targets.size()));
        }
        return 1;
    }
}

