/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries.main;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.TextFieldConfigEntry;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.minecraft.class_332;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class StringConfigEntry
extends TextFieldConfigEntry {
    private static final int FIELD_WIDTH = 150;
    private static final float ANIMATION_SPEED = 0.15f;
    private static final int PADDING = 4;
    protected final String defaultValue;
    protected String value;
    protected String startingValue;
    private float currentWidth;
    private float targetWidth;
    private int x = -1;

    public StringConfigEntry(String fieldName, String displayName, String description, String value, String defaultValue) {
        super(fieldName, displayName, description, 150);
        this.defaultValue = defaultValue;
        this.value = value;
        this.startingValue = value;
        this.currentWidth = 150.0f;
        this.targetWidth = 150.0f;
        this.initializeTextField();
    }

    @Override
    protected void initializeTextField() {
        this.setText(this.value);
        if (this.textField.method_25368() - 6 < this.textRenderer.method_1727(this.value)) {
            this.textField.method_1870(false);
        }
    }

    @Override
    protected void onTextChanged(String text) {
        super.onTextChanged(text);
        this.value = text;
        if (!this.hasCustomErrors()) {
            this.clearError();
        }
        this.markChanged();
        this.updateFieldDimensions();
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.updateFieldDimensions();
    }

    private void updateFieldDimensions() {
        if (this.textField == null) {
            return;
        }
        if (this.x < 0) {
            return;
        }
        String text = this.textField.method_1882();
        if (text == null) {
            return;
        }
        if (text.isEmpty()) {
            this.targetWidth = 150.0f;
            return;
        }
        int textWidth = this.textRenderer.method_1727(text) + 20;
        int labelEndX = this.x + 25 + this.textRenderer.method_27525((class_5348)this.getDisplayName());
        int fieldEndX = this.textField.method_46426() + this.textField.method_25368();
        int maxFieldWidth = fieldEndX - labelEndX - 15;
        if (maxFieldWidth <= 150) {
            maxFieldWidth = 150;
        }
        int requiredWidth = Math.clamp((long)(textWidth + 8), 150, maxFieldWidth);
        this.targetWidth = this.isFocused() ? (float)requiredWidth : (float)Math.min(150, requiredWidth);
    }

    @Override
    protected void renderEntry(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.x = x;
        this.updateAnimations(tickDelta);
        this.textField.method_25358((int)this.currentWidth);
        super.renderEntry(context, x, y, width, height, mouseX, mouseY, hovered, tickDelta);
    }

    private void updateAnimations(float tickDelta) {
        this.currentWidth = Math.abs(this.currentWidth - this.targetWidth) > 2.0f ? (this.currentWidth += (this.targetWidth - this.currentWidth) * 0.15f * tickDelta) : this.targetWidth;
    }

    @Override
    protected int getTextFieldPosX(int x, int entryWidth) {
        return x + entryWidth - (int)this.currentWidth - 5;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            String stringValue;
            this.value = stringValue = (String)value;
            this.setText(stringValue);
            this.updateFieldDimensions();
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    @Override
    public String getDefaultValueAsString() {
        return this.getDefaultValue();
    }

    @Override
    public String getStartingValue() {
        return this.startingValue;
    }

    @Override
    public String getStartingValueAsString() {
        return this.startingValue;
    }

    @Override
    public ConfigTypes getValueType() {
        return ConfigTypes.STRING;
    }
}

