/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.voicechat.soundeffects;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class RoboticVoice {
    private static double SAMPLE_RATE = 16000.0;
    private static int HISTORY_SIZE = 5;
    private static long MAX_HISTORY_AGE_MS = 300L;
    private static final Map<UUID, Deque<VoiceStats>> speakerHistory = new HashMap<UUID, Deque<VoiceStats>>();
    private static final Map<UUID, Double> speakerPhase = new HashMap<UUID, Double>();

    public static short[] applyEffect(UUID uuid, short[] input) {
        long now = System.currentTimeMillis();
        double amplitude = RoboticVoice.estimateAmplitude(input);
        double freq = RoboticVoice.estimateDominantFrequency(input);
        if (amplitude < 0.001) {
            return new short[input.length];
        }
        Deque history = speakerHistory.computeIfAbsent(uuid, k -> new ArrayDeque());
        if (history.size() >= HISTORY_SIZE) {
            history.pollFirst();
        }
        history.addLast(new VoiceStats(freq, amplitude, now));
        history.removeIf(stat -> now - stat.timestamp > MAX_HISTORY_AGE_MS);
        if (history.isEmpty()) {
            return new short[input.length];
        }
        double weightedFreq = 0.0;
        double weightedAmp = 0.0;
        int totalWeight = 0;
        boolean weight = true;
        ArrayList recentStats = new ArrayList(history);
        for (int i = 0; i < recentStats.size(); ++i) {
            VoiceStats stat2 = (VoiceStats)recentStats.get(i);
            int w = i + 1;
            weightedFreq += stat2.frequency * (double)w;
            weightedAmp += stat2.amplitude * (double)w;
            totalWeight += w;
        }
        double avgFreq = weightedFreq / (double)totalWeight;
        double avgAmp = weightedAmp / (double)totalWeight;
        return RoboticVoice.synthHarmonicTone(uuid, input.length, avgFreq, avgAmp * 2.0);
    }

    private static double estimateAmplitude(short[] input) {
        double sum = 0.0;
        for (short s : input) {
            sum += (double)Math.abs(s);
        }
        return sum / (double)input.length / 32768.0;
    }

    private static double estimateDominantFrequency(short[] input) {
        int zeroCrossings = 0;
        for (int i = 1; i < input.length; ++i) {
            if ((input[i - 1] >= 0 || input[i] < 0) && (input[i - 1] <= 0 || input[i] > 0)) continue;
            ++zeroCrossings;
        }
        double durationSec = (double)input.length / SAMPLE_RATE;
        double estFreq = (double)zeroCrossings / 2.0 / durationSec;
        return Math.max(20.0, Math.min(estFreq, 400.0));
    }

    private static short[] synthHarmonicTone(UUID uuid, int length, double baseFreq, double amplitude) {
        short[] output = new short[length];
        double phase = speakerPhase.getOrDefault(uuid, 0.0);
        double modulationDepth = 0.05;
        double lfoFrequency = 5.0;
        for (int i = 0; i < length; ++i) {
            double t = (double)i / SAMPLE_RATE;
            double lfo = Math.sin(Math.PI * 2 * lfoFrequency * t) * modulationDepth;
            double modulatedFreq = baseFreq * (1.0 + lfo);
            double phaseIncrement = Math.PI * 2 * modulatedFreq / SAMPLE_RATE;
            double sample = Math.sin(phase += phaseIncrement) * 0.6 + Math.sin(2.0 * phase) * 0.3 + Math.sin(3.0 * phase) * 0.1;
            sample *= amplitude;
            sample = Math.max(-1.0, Math.min(1.0, sample));
            output[i] = (short)(sample * 32767.0);
        }
        speakerPhase.put(uuid, phase % (Math.PI * 2));
        return output;
    }

    private static class VoiceStats {
        double frequency;
        double amplitude;
        long timestamp;

        VoiceStats(double frequency, double amplitude, long timestamp) {
            this.frequency = frequency;
            this.amplitude = amplitude;
            this.timestamp = timestamp;
        }
    }
}

