/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ClientConfig;
import net.mat0u5.lifeseries.network.NetworkHandlerClient;
import net.mat0u5.lifeseries.registries.ClientRegistries;
import net.mat0u5.lifeseries.render.ClientRenderer;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.morph.MorphManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.session.SessionStatus;
import net.mat0u5.lifeseries.utils.interfaces.IClientHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class MainClient
implements ClientModInitializer,
IClientHelper {
    public static Seasons clientCurrentSeason = Main.DEFAULT_SEASON;
    public static SessionStatus clientSessionStatus = SessionStatus.NOT_STARTED;
    public static List<Wildcards> clientActiveWildcards = new ArrayList<Wildcards>();
    public static long TIME_DILATION_TIMESTAMP = 0L;
    public static long SUPERPOWER_COOLDOWN_TIMESTAMP = 0L;
    public static long MIMICRY_COOLDOWN_TIMESTAMP = 0L;
    public static long CURSE_SLIDING = 0L;
    public static Map<String, String> playerDisguiseNames = new HashMap<String, String>();
    public static Map<UUID, UUID> playerDisguiseUUIDs = new HashMap<UUID, UUID>();
    public static Map<UUID, Long> invisiblePlayers = new HashMap<UUID, Long>();
    public static List<UUID> triviaBotPartUUIDs = new ArrayList<UUID>();
    public static List<UUID> snailPartUUIDs = new ArrayList<UUID>();
    public static class_2338 snailPos = null;
    public static long snailPosTime = 0L;
    public static List<UUID> triviaSnailPartUUIDs = new ArrayList<UUID>();
    public static class_2338 triviaSnailPos = null;
    public static long triviaSnailPosTime = 0L;
    public static int snailAir = 300;
    public static long snailAirTimestamp = 0L;
    public static boolean preventGliding = false;
    public static long sessionTime = 0L;
    public static long sessionTimeLastUpdated = 0L;
    public static String limitedLifeTimerColor = "";
    public static long limitedLifeTimeLastUpdated = 0L;
    public static long limitedLifeLives = 0L;
    public static List<String> hiddenTabPlayers = new ArrayList<String>();
    public static ClientConfig clientConfig;
    public static boolean COLORBLIND_SUPPORT;
    public static boolean SESSION_TIMER;
    public static boolean TAB_LIST_SHOW_EXACT_LIVES;
    public static String RUN_COMMAND;
    public static boolean COLORED_HEARTS;
    public static boolean COLORED_HEARTS_HARDCORE_LAST_LIFE;
    public static boolean COLORED_HEARTS_HARDCORE_ALL_LIVES;

    public void onInitializeClient() {
        FabricLoader.getInstance().getModContainer("lifeseries").ifPresent(container -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"lifeseries", (String)"lifeseries"), (ModContainer)container, (class_2561)class_2561.method_30163((String)"Main Life Series Resourcepack"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"lifeseries", (String)"minimal_armor"), (ModContainer)container, (class_2561)class_2561.method_30163((String)"Minimal Armor Resourcepack"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        });
        NetworkHandlerClient.registerClientReceiver();
        ClientRenderer.onInitialize();
        ClientRegistries.registerModStuff();
        Main.setClientHelper(this);
        clientConfig = new ClientConfig();
        MainClient.reloadConfig();
    }

    public static boolean isClientPlayer(UUID uuid) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return false;
        }
        if (client.field_1724 == null) {
            return false;
        }
        return client.field_1724.method_5667().equals(uuid);
    }

    @Override
    public boolean isRunningIntegratedServer() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return false;
        }
        return client.method_1496();
    }

    @Override
    public boolean isMainClientPlayer(UUID uuid) {
        return MainClient.isClientPlayer(uuid);
    }

    @Override
    public Seasons getCurrentSeason() {
        return clientCurrentSeason;
    }

    @Override
    public List<Wildcards> getActiveWildcards() {
        return clientActiveWildcards;
    }

    public static void reloadConfig() {
        COLORBLIND_SUPPORT = ClientConfig.COLORBLIND_SUPPORT.get(clientConfig);
        SESSION_TIMER = clientCurrentSeason == Seasons.LIMITED_LIFE ? ClientConfig.SESSION_TIMER_LIMITEDLIFE.get(clientConfig).booleanValue() : ClientConfig.SESSION_TIMER.get(clientConfig).booleanValue();
        RUN_COMMAND = ClientConfig.RUN_COMMAND.get(clientConfig);
        if (RUN_COMMAND.startsWith("/")) {
            RUN_COMMAND = RUN_COMMAND.substring(1);
        }
        COLORED_HEARTS = ClientConfig.COLORED_HEARTS.get(clientConfig);
        COLORED_HEARTS_HARDCORE_LAST_LIFE = ClientConfig.COLORED_HEARTS_HARDCORE_LAST_LIFE.get(clientConfig);
        COLORED_HEARTS_HARDCORE_ALL_LIVES = ClientConfig.COLORED_HEARTS_HARDCORE_ALL_LIVES.get(clientConfig);
    }

    public static void resetClientData() {
        clientCurrentSeason = Seasons.UNASSIGNED;
        clientSessionStatus = SessionStatus.NOT_STARTED;
        clientActiveWildcards = new ArrayList<Wildcards>();
        TIME_DILATION_TIMESTAMP = 0L;
        SUPERPOWER_COOLDOWN_TIMESTAMP = 0L;
        MIMICRY_COOLDOWN_TIMESTAMP = 0L;
        CURSE_SLIDING = 0L;
        playerDisguiseNames = new HashMap<String, String>();
        playerDisguiseUUIDs = new HashMap<UUID, UUID>();
        invisiblePlayers = new HashMap<UUID, Long>();
        triviaBotPartUUIDs = new ArrayList<UUID>();
        snailPartUUIDs = new ArrayList<UUID>();
        snailPos = null;
        snailPosTime = 0L;
        triviaSnailPartUUIDs = new ArrayList<UUID>();
        triviaSnailPos = null;
        triviaSnailPosTime = 0L;
        snailAir = 300;
        snailAirTimestamp = 0L;
        preventGliding = false;
        sessionTime = 0L;
        sessionTimeLastUpdated = 0L;
        limitedLifeTimerColor = "";
        limitedLifeTimeLastUpdated = 0L;
        limitedLifeLives = 0L;
        hiddenTabPlayers = new ArrayList<String>();
        MorphManager.resetMorphs();
    }

    static {
        COLORBLIND_SUPPORT = false;
        SESSION_TIMER = false;
        TAB_LIST_SHOW_EXACT_LIVES = false;
        RUN_COMMAND = "lifeseries config";
        COLORED_HEARTS = false;
        COLORED_HEARTS_HARDCORE_LAST_LIFE = true;
        COLORED_HEARTS_HARDCORE_ALL_LIVES = false;
    }
}

