/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.other;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Necromancy;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.mat0u5.lifeseries.utils.player.TeamUtils;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.mat0u5.lifeseries.utils.world.WorldUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9011;
import net.minecraft.class_9015;
import org.jetbrains.annotations.Nullable;

public class LivesManager {
    public static final String SCOREBOARD_NAME = "Lives";
    public boolean FINAL_DEATH_LIGHTNING = true;
    public class_3414 FINAL_DEATH_SOUND = class_3417.field_14865;
    public boolean SHOW_DEATH_TITLE = false;
    public boolean ONLY_TAKE_LIVES_IN_SESSION = false;
    public boolean SEE_FRIENDLY_INVISIBLE_PLAYERS = false;

    public void reload() {
        this.SHOW_DEATH_TITLE = (Boolean)Main.seasonConfig.FINAL_DEATH_TITLE_SHOW.get(Main.seasonConfig);
        this.FINAL_DEATH_LIGHTNING = (Boolean)Main.seasonConfig.FINAL_DEATH_LIGHTNING.get(Main.seasonConfig);
        this.FINAL_DEATH_SOUND = class_3414.method_47908((class_2960)class_2960.method_60654((String)((String)Main.seasonConfig.FINAL_DEATH_SOUND.get(Main.seasonConfig))));
        this.ONLY_TAKE_LIVES_IN_SESSION = (Boolean)Main.seasonConfig.ONLY_TAKE_LIVES_IN_SESSION.get(Main.seasonConfig);
        this.SEE_FRIENDLY_INVISIBLE_PLAYERS = (Boolean)Main.seasonConfig.SEE_FRIENDLY_INVISIBLE_PLAYERS.get(Main.seasonConfig);
        this.updateTeams();
    }

    public void updateTeams() {
        Collection<class_268> allTeams = TeamUtils.getAllTeams();
        if (allTeams == null) {
            return;
        }
        for (class_268 team : allTeams) {
            String name = team.method_1197();
            if (!name.startsWith("lives_")) continue;
            team.method_1143(this.SEE_FRIENDLY_INVISIBLE_PLAYERS);
        }
    }

    public void createTeams() {
        TeamUtils.createTeam("lives_null", "Unassigned", class_124.field_1080);
        TeamUtils.createTeam("lives_0", "Dead", class_124.field_1063);
        TeamUtils.createTeam("lives_1", "Red", class_124.field_1061);
        TeamUtils.createTeam("lives_2", "Yellow", class_124.field_1054);
        TeamUtils.createTeam("lives_3", "Green", class_124.field_1060);
        TeamUtils.createTeam("lives_4", "Dark Green", class_124.field_1077);
    }

    public void createScoreboards() {
        ScoreboardUtils.createObjective(SCOREBOARD_NAME);
    }

    public class_124 getColorForLives(class_3222 player) {
        return this.getColorForLives(this.getPlayerLives(player));
    }

    public class_124 getColorForLives(Integer lives) {
        class_124 color;
        class_268 team = TeamUtils.getTeam(this.getTeamForLives(lives));
        if (team != null && (color = team.method_1202()) != null) {
            return color;
        }
        return class_124.field_1063;
    }

    public class_2561 getFormattedLives(class_3222 player) {
        return this.getFormattedLives(this.getPlayerLives(player));
    }

    public class_2561 getFormattedLives(@Nullable Integer lives) {
        if (lives == null) {
            lives = 0;
        }
        class_124 color = this.getColorForLives(lives);
        return class_2561.method_43470((String)String.valueOf(lives)).method_27692(color);
    }

    public String getTeamForPlayer(class_3222 player) {
        Integer lives = this.getPlayerLives(player);
        return this.getTeamForLives(lives);
    }

    public String getTeamForLives(Integer lives) {
        String prefix = "lives_";
        String nullTeam = prefix + "null";
        if (lives == null) {
            return nullTeam;
        }
        ArrayList<Integer> livesTeams = new ArrayList<Integer>();
        Collection<class_268> allTeams = TeamUtils.getAllTeams();
        if (allTeams != null) {
            for (class_268 team : allTeams) {
                String name = team.method_1197();
                if (!name.startsWith(prefix)) continue;
                try {
                    int index = Integer.parseInt(name.replaceAll(prefix, ""));
                    if (index == lives) {
                        return name;
                    }
                    livesTeams.add(index);
                }
                catch (Exception exception) {}
            }
        }
        if (!livesTeams.isEmpty()) {
            Collections.sort(livesTeams);
            if (lives <= (Integer)livesTeams.getFirst()) {
                return prefix + String.valueOf(livesTeams.getFirst());
            }
            Collections.reverse(livesTeams);
            Iterator<Object> iterator = livesTeams.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (lives < i) continue;
                return prefix + i;
            }
        }
        return nullTeam;
    }

    @Nullable
    public Integer getPlayerLives(class_3222 player) {
        if (WatcherManager.isWatcher((class_1657)player)) {
            return null;
        }
        return ScoreboardUtils.getScore((class_9015)player, SCOREBOARD_NAME);
    }

    public boolean hasAssignedLives(class_3222 player) {
        Integer lives = this.getPlayerLives(player);
        return lives != null;
    }

    public boolean isAlive(class_3222 player) {
        Integer lives = this.getPlayerLives(player);
        if (lives == null) {
            return false;
        }
        if (!this.hasAssignedLives(player)) {
            return false;
        }
        return lives > 0;
    }

    public void removePlayerLife(class_3222 player) {
        this.addToPlayerLives(player, -1);
    }

    public void resetPlayerLife(class_3222 player) {
        ScoreboardUtils.resetScore((class_9015)player, SCOREBOARD_NAME);
        Main.currentSeason.reloadPlayerTeam(player);
        Main.currentSeason.assignDefaultLives(player);
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife) {
            DoubleLife doubleLife = (DoubleLife)season;
            doubleLife.syncSoulboundLives(player);
        }
    }

    public void resetAllPlayerLivesInner() {
        this.createScoreboards();
        for (class_9011 entry : ScoreboardUtils.getScores(SCOREBOARD_NAME)) {
            ScoreboardUtils.resetScore(class_9015.method_55422((String)entry.comp_2127()), SCOREBOARD_NAME);
        }
        Main.currentSeason.reloadAllPlayerTeams();
    }

    public void resetAllPlayerLives() {
        this.resetAllPlayerLivesInner();
        PlayerUtils.getAllPlayers().forEach(Main.currentSeason::assignDefaultLives);
    }

    public void addPlayerLife(class_3222 player) {
        this.addToPlayerLives(player, 1);
    }

    public void addToPlayerLives(class_3222 player, int amount) {
        int lives;
        Integer currentLives = this.getPlayerLives(player);
        if (currentLives == null) {
            currentLives = 0;
        }
        if ((lives = currentLives + amount) < 0 && !Necromancy.isRessurectedPlayer(player)) {
            lives = 0;
        }
        this.setPlayerLives(player, lives);
    }

    public void addToLifeNoUpdate(class_3222 player) {
        int lives;
        if (WatcherManager.isWatcher((class_1657)player)) {
            return;
        }
        Integer currentLives = this.getPlayerLives(player);
        if (currentLives == null) {
            currentLives = 0;
        }
        if ((lives = currentLives + 1) < 0) {
            lives = 0;
        }
        ScoreboardUtils.setScore(player, SCOREBOARD_NAME, lives);
    }

    public void receiveLifeFromOtherPlayer(class_2561 playerName, class_3222 target, boolean isRevive) {
        target.method_17356(class_3417.field_26980, class_3419.field_15250, 10.0f, 1.0f);
        if (((Boolean)Main.seasonConfig.GIVELIFE_BROADCAST.get(Main.seasonConfig)).booleanValue()) {
            PlayerUtils.broadcastMessageExcept((class_2561)TextUtils.format("{} received a life from {}", target, playerName), target);
        }
        target.method_64398((class_2561)TextUtils.format("You received a life from {}", playerName));
        PlayerUtils.sendTitleWithSubtitle(target, class_2561.method_30163((String)"You received a life"), (class_2561)TextUtils.format("from {}", playerName), 10, 60, 10);
        AnimationUtils.createSpiral(target, 175);
        Main.currentSeason.reloadPlayerTeam(target);
        SessionTranscript.givelife(playerName, target);
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife) {
            DoubleLife doubleLife = (DoubleLife)season;
            doubleLife.syncSoulboundLives(target);
        }
        if (isRevive && this.isAlive(target)) {
            PlayerUtils.safelyPutIntoSurvival(target);
        }
    }

    public void setPlayerLives(class_3222 player, int lives) {
        if (WatcherManager.isWatcher((class_1657)player)) {
            return;
        }
        Integer livesBefore = this.getPlayerLives(player);
        ScoreboardUtils.setScore(player, SCOREBOARD_NAME, lives);
        if (lives <= 0) {
            this.playerLostAllLives(player, livesBefore);
        } else if (player.method_7325()) {
            PlayerUtils.safelyPutIntoSurvival(player);
        }
        Main.currentSeason.reloadPlayerTeam(player);
    }

    public void setScore(String playerName, int lives) {
        ScoreboardUtils.setScore(class_9015.method_55422((String)playerName), SCOREBOARD_NAME, lives);
    }

    @Nullable
    public Boolean isOnLastLife(class_3222 player) {
        return this.isOnSpecificLives(player, 1);
    }

    public boolean isOnLastLife(class_3222 player, boolean fallback) {
        Boolean isOnLastLife = this.isOnLastLife(player);
        if (isOnLastLife == null) {
            return fallback;
        }
        return isOnLastLife;
    }

    @Nullable
    public Boolean isOnSpecificLives(class_3222 player, int check) {
        if (!this.isAlive(player)) {
            return null;
        }
        Integer lives = this.getPlayerLives(player);
        if (lives == null) {
            return null;
        }
        return lives == check;
    }

    public boolean isOnSpecificLives(class_3222 player, int check, boolean fallback) {
        Boolean isOnLife = this.isOnSpecificLives(player, check);
        if (isOnLife == null) {
            return fallback;
        }
        return isOnLife;
    }

    @Nullable
    public Boolean isOnAtLeastLives(class_3222 player, int check) {
        if (!this.isAlive(player)) {
            return null;
        }
        Integer lives = this.getPlayerLives(player);
        if (lives == null) {
            return null;
        }
        return lives >= check;
    }

    public boolean isOnAtLeastLives(class_3222 player, int check, boolean fallback) {
        Boolean isOnAtLeast = this.isOnAtLeastLives(player, check);
        if (isOnAtLeast == null) {
            return fallback;
        }
        return isOnAtLeast;
    }

    public void playerLostAllLives(class_3222 player, Integer livesBefore) {
        player.method_7336(class_1934.field_9219);
        class_243 pos = player.method_19538();
        HashMap<class_243, List<Float>> info = new HashMap<class_243, List<Float>>();
        info.put(pos, List.of(Float.valueOf(player.method_36454()), Float.valueOf(player.method_36455())));
        Main.currentSeason.respawnPositions.put(player.method_5667(), info);
        Main.currentSeason.dropItemsOnLastDeath(player);
        if (livesBefore != null) {
            if (this.FINAL_DEATH_LIGHTNING) {
                WorldUtils.summonHarmlessLightning(player);
            }
            if (livesBefore > 0) {
                if (this.FINAL_DEATH_SOUND != null) {
                    PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), this.FINAL_DEATH_SOUND);
                }
                this.showDeathTitle(player);
            }
        }
        SessionTranscript.onPlayerLostAllLives(player);
        Main.currentSeason.boogeymanManager.playerLostAllLives(player);
    }

    public void showDeathTitle(class_3222 player) {
        class_2561 deathMessage;
        if (this.SHOW_DEATH_TITLE) {
            String subtitle = (String)Main.seasonConfig.FINAL_DEATH_TITLE_SUBTITLE.get(Main.seasonConfig);
            PlayerUtils.sendTitleWithSubtitleToPlayers(PlayerUtils.getAllPlayers(), player.method_55423(), (class_2561)class_2561.method_43470((String)subtitle), 20, 80, 20);
        }
        if (!(deathMessage = this.getDeathMessage(player)).getString().isEmpty()) {
            PlayerUtils.broadcastMessage(deathMessage);
        }
    }

    public class_2561 getDeathMessage(class_3222 player) {
        String message = (String)Main.seasonConfig.FINAL_DEATH_MESSAGE.get(Main.seasonConfig);
        if (message.contains("${player}")) {
            return TextUtils.format(message.replace("${player}", "{}"), player);
        }
        return class_2561.method_43470((String)message);
    }

    public List<class_3222> getNonRedPlayers() {
        List<class_3222> players = PlayerUtils.getAllFunctioningPlayers();
        players.removeIf(player -> this.isOnLastLife((class_3222)player, true));
        return players;
    }

    public List<class_3222> getRedPlayers() {
        List<class_3222> players = PlayerUtils.getAllFunctioningPlayers();
        players.removeIf(player -> !this.isOnLastLife((class_3222)player, false));
        return players;
    }

    public List<class_3222> getAlivePlayers() {
        List<class_3222> players = PlayerUtils.getAllFunctioningPlayers();
        players.removeIf(player -> !this.isAlive((class_3222)player));
        return players;
    }

    public List<class_3222> getDeadPlayers() {
        List<class_3222> players = PlayerUtils.getAllFunctioningPlayers();
        players.removeIf(this::isAlive);
        return players;
    }

    public boolean anyGreenPlayers(class_3222 exception) {
        for (class_3222 player : this.getAlivePlayers()) {
            if (player == exception || !this.isOnSpecificLives(player, 3, false)) continue;
            return true;
        }
        return false;
    }

    public boolean anyYellowPlayers(class_3222 exception) {
        for (class_3222 player : this.getAlivePlayers()) {
            if (player == exception || !this.isOnSpecificLives(player, 2, false)) continue;
            return true;
        }
        return false;
    }

    public boolean anyAlivePlayers(class_3222 exception) {
        for (class_3222 player : this.getAlivePlayers()) {
            if (player == exception) continue;
            return true;
        }
        return false;
    }

    public boolean canChangeLivesNaturally() {
        if (this.ONLY_TAKE_LIVES_IN_SESSION && Main.currentSession != null) {
            return Main.currentSession.statusStarted();
        }
        return true;
    }
}

