/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.ToggleableSuperpower;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.TeamUtils;
import net.mat0u5.lifeseries.utils.world.WorldUtils;
import net.minecraft.class_10275;
import net.minecraft.class_10339;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5819;

public class Creaking
extends ToggleableSuperpower {
    public static final List<UUID> allCreatedEntities = new ArrayList<UUID>();
    private final List<String> createdTeams = new ArrayList<String>();
    private final List<class_10275> createdEntities = new ArrayList<class_10275>();

    public Creaking(class_3222 player) {
        super(player);
    }

    @Override
    public Superpowers getSuperpower() {
        return Superpowers.CREAKING;
    }

    @Override
    public void tick() {
        if (!this.active) {
            return;
        }
        this.spawnTrailParticles();
    }

    @Override
    public void activate() {
        super.activate();
        class_3222 player = this.getPlayer();
        if (player == null) {
            return;
        }
        class_3218 playerWorld = PlayerUtils.getServerWorld(player);
        class_268 playerTeam = TeamUtils.getPlayerTeam(player);
        if (playerTeam == null) {
            return;
        }
        String newTeamName = "creaking_" + player.method_5820();
        TeamUtils.deleteTeam(newTeamName);
        TeamUtils.createTeam(newTeamName, playerTeam.method_1202());
        this.createdTeams.add(newTeamName);
        for (int i = 0; i < 3; ++i) {
            class_2338 spawnPos = WorldUtils.getCloseBlockPos(playerWorld, player.method_24515(), 6.0, 3, true);
            class_10275 creaking = (class_10275)class_1299.field_54560.method_47821(playerWorld, spawnPos, class_3730.field_16462);
            if (creaking == null) continue;
            creaking.method_5684(true);
            creaking.method_5780("creakingFromSuperpower");
            this.createdEntities.add(creaking);
            allCreatedEntities.add(creaking.method_5667());
            Creaking.makeFriendly(newTeamName, (class_1297)creaking, player);
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (Main.server != null) {
            this.createdEntities.forEach(class_1297::method_31472);
            this.createdEntities.clear();
        }
        for (String teamAdded : this.createdTeams) {
            TeamUtils.deleteTeam(teamAdded);
        }
        this.createdTeams.clear();
        if (this.getPlayer() != null && TeamUtils.getPlayerTeam(this.getPlayer()) == null) {
            Main.currentSeason.reloadPlayerTeam(this.getPlayer());
        }
    }

    @Override
    public int deactivateCooldownMillis() {
        return 10000;
    }

    private static void makeFriendly(String teamName, class_1297 entity, class_3222 player) {
        TeamUtils.addEntityToTeam(teamName, (class_1297)player);
        TeamUtils.addEntityToTeam(teamName, entity);
        PlayerUtils.getServerWorld(player).method_65096((class_2394)class_2398.field_11236, entity.method_19538().method_10216(), entity.method_19538().method_10214(), entity.method_19538().method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public void spawnTrailParticles() {
        class_3222 player = this.getPlayer();
        if (player == null) {
            return;
        }
        class_3218 world = PlayerUtils.getServerWorld(player);
        if (world == null) {
            return;
        }
        for (class_10275 creakingEntity : this.createdEntities) {
            if (creakingEntity.method_59922().method_43048(50) == 0) {
                this.spawnTrailParticles(creakingEntity, 1, false);
            }
            if (creakingEntity.field_6235 <= 0) continue;
            this.spawnTrailParticles(creakingEntity, 4, true);
        }
    }

    public void spawnTrailParticles(class_10275 creaking, int count, boolean towardsPlayer) {
        class_3222 player = this.getPlayer();
        if (player == null) {
            return;
        }
        class_3218 world = PlayerUtils.getServerWorld(player);
        if (world == null) {
            return;
        }
        int i = towardsPlayer ? 16545810 : 0x5F5F5F;
        class_5819 random = world.field_9229;
        for (double d = 0.0; d < (double)count; d += 1.0) {
            class_238 box = creaking.method_5829();
            class_243 vec3d = box.method_61125().method_1031(random.method_43058() * box.method_17939(), random.method_43058() * box.method_17940(), random.method_43058() * box.method_17941());
            class_243 vec3d2 = player.method_19538().method_1031(random.method_43058() - 0.5, random.method_43058(), random.method_43058() - 0.5);
            if (!towardsPlayer) {
                class_243 vec3d3 = vec3d;
                vec3d = vec3d2;
                vec3d2 = vec3d3;
            }
            class_10339 trailParticleEffect2 = new class_10339(vec3d2, i, random.method_43048(40) + 10);
            world.method_14199((class_2394)trailParticleEffect2, true, true, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void killUnassignedMobs() {
        if (Main.server == null) {
            return;
        }
        for (class_3218 world : Main.server.method_3738()) {
            ArrayList toKill = new ArrayList();
            world.method_27909().forEach(entity -> {
                if (!(entity instanceof class_10275)) {
                    return;
                }
                if (allCreatedEntities.contains(entity.method_5667())) {
                    return;
                }
                if (!entity.method_5752().contains("creakingFromSuperpower")) {
                    return;
                }
                toKill.add(entity);
            });
            toKill.forEach(class_1297::method_31472);
        }
    }
}

