/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.player;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.fakeplayer.FakePlayer;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLife;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Necromancy;
import net.mat0u5.lifeseries.seasons.session.Session;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.world.WorldUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2709;
import net.minecraft.class_2720;
import net.minecraft.class_2765;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_7828;
import net.minecraft.class_7923;
import net.minecraft.class_9053;

public class PlayerUtils {
    private static HashMap<class_2561, Integer> broadcastCooldown = new HashMap();
    private static final Random rnd = new Random();
    public static List<UUID> updateInventoryQueue = new ArrayList<UUID>();

    public static void sendTitleWithSubtitle(class_3222 player, class_2561 title, class_2561 subtitle, int fadeIn, int stay, int fadeOut) {
        if (Main.server == null) {
            return;
        }
        if (player == null) {
            return;
        }
        if (player.method_29504()) {
            TaskScheduler.scheduleTask(5, () -> PlayerUtils.sendTitleWithSubtitle(PlayerUtils.getPlayer(player.method_5667()), title, subtitle, fadeIn, stay, fadeOut));
            return;
        }
        class_5905 fadePacket = new class_5905(fadeIn, stay, fadeOut);
        player.field_13987.method_14364((class_2596)fadePacket);
        class_5904 titlePacket = new class_5904(title);
        player.field_13987.method_14364((class_2596)titlePacket);
        class_5903 subtitlePacket = new class_5903(subtitle);
        player.field_13987.method_14364((class_2596)subtitlePacket);
    }

    public static void sendTitle(class_3222 player, class_2561 title, int fadeIn, int stay, int fadeOut) {
        if (Main.server == null) {
            return;
        }
        if (player == null) {
            return;
        }
        if (player.method_29504()) {
            TaskScheduler.scheduleTask(5, () -> PlayerUtils.sendTitle(PlayerUtils.getPlayer(player.method_5667()), title, fadeIn, stay, fadeOut));
            return;
        }
        class_5905 fadePacket = new class_5905(fadeIn, stay, fadeOut);
        player.field_13987.method_14364((class_2596)fadePacket);
        class_5904 titlePacket = new class_5904(title);
        player.field_13987.method_14364((class_2596)titlePacket);
    }

    public static void sendTitleToPlayers(Collection<class_3222> players, class_2561 title, int fadeIn, int stay, int fadeOut) {
        for (class_3222 player : players) {
            PlayerUtils.sendTitle(player, title, fadeIn, stay, fadeOut);
        }
    }

    public static void sendTitleWithSubtitleToPlayers(Collection<class_3222> players, class_2561 title, class_2561 subtitle, int fadeIn, int stay, int fadeOut) {
        for (class_3222 player : players) {
            PlayerUtils.sendTitleWithSubtitle(player, title, subtitle, fadeIn, stay, fadeOut);
        }
    }

    public static void playSoundToPlayers(Collection<class_3222> players, class_3414 sound) {
        PlayerUtils.playSoundToPlayers(players, sound, class_3419.field_15250, 1.0f, 1.0f);
    }

    public static void playSoundToPlayers(Collection<class_3222> players, class_3414 sound, float volume, float pitch) {
        PlayerUtils.playSoundToPlayers(players, sound, class_3419.field_15250, volume, pitch);
    }

    public static void playSoundToPlayers(Collection<class_3222> players, class_3414 sound, class_3419 soundCategory, float volume, float pitch) {
        for (class_3222 player : players) {
            player.method_17356(sound, soundCategory, volume, pitch);
        }
    }

    public static void playSoundToPlayer(class_3222 player, class_3414 sound) {
        PlayerUtils.playSoundToPlayer(player, sound, 1.0f, 1.0f);
    }

    public static void playSoundToPlayer(class_3222 player, class_3414 sound, float volume, float pitch) {
        player.method_17356(sound, class_3419.field_15250, volume, pitch);
    }

    public static void playSoundWithSourceToPlayers(class_1297 source, class_3414 sound, class_3419 soundCategory, float volume, float pitch) {
        PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), source, sound, soundCategory, volume, pitch);
    }

    public static void playSoundWithSourceToPlayers(Collection<class_3222> players, class_1297 source, class_3414 sound, class_3419 soundCategory, float volume, float pitch) {
        class_2765 packet = new class_2765(class_7923.field_41172.method_47983((Object)sound), soundCategory, source, volume, pitch, rnd.nextLong());
        for (class_3222 player : players) {
            player.field_13987.method_14364((class_2596)packet);
        }
    }

    public static List<class_3222> getAllPlayers() {
        ArrayList<class_3222> result = new ArrayList<class_3222>();
        if (Main.server == null) {
            return result;
        }
        for (class_3222 player : Main.server.method_3760().method_14571()) {
            if (player instanceof FakePlayer) continue;
            result.add(player);
        }
        return result;
    }

    public static List<class_3222> getAllFunctioningPlayers() {
        List<class_3222> result = PlayerUtils.getAllPlayers();
        result.removeIf(WatcherManager::isWatcher);
        return result;
    }

    public static List<class_3222> getAdminPlayers() {
        List<class_3222> result = PlayerUtils.getAllPlayers();
        result.removeIf(player -> !PermissionManager.isAdmin(player));
        return result;
    }

    public static class_3222 getPlayer(String name) {
        if (Main.server == null || name == null) {
            return null;
        }
        return Main.server.method_3760().method_14566(name);
    }

    public static class_3222 getPlayer(UUID uuid) {
        if (Main.server == null || uuid == null) {
            return null;
        }
        return Main.server.method_3760().method_14602(uuid);
    }

    public static void applyResourcepack(UUID uuid) {
        if (NetworkHandlerServer.wasHandshakeSuccessful(uuid)) {
            return;
        }
        PlayerUtils.applyServerResourcepack(uuid);
    }

    public static void applyServerResourcepack(UUID uuid) {
        if (Main.server == null) {
            return;
        }
        class_3222 player = PlayerUtils.getPlayer(uuid);
        if (player == null) {
            return;
        }
        PlayerUtils.applySingleResourcepack(player, "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-main-a4e7ddfa4558be90d6259e0d655f9589cb60dd88/main.zip", "2a1e2e58b330631370d9f95203618e86500c4397", "Life Series Resourcepack.");
        PlayerUtils.applySingleResourcepack(player, "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-minimal_armor-a4e7ddfa4558be90d6259e0d655f9589cb60dd88/minimal_armor.zip", "1d349628ab6121691fa991770289d01458d561f4", "Life Series Resourcepack.");
        if (Main.currentSeason instanceof SecretLife) {
            PlayerUtils.applySingleResourcepack(player, "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-secretlife-a4e7ddfa4558be90d6259e0d655f9589cb60dd88/secretlife.zip", "231313213c1cd24145506fb496db2880dd1f9c1c", "Life Series Resourcepack.");
        } else {
            PlayerUtils.removeSingleResourcepack(player, "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-secretlife-a4e7ddfa4558be90d6259e0d655f9589cb60dd88/secretlife.zip");
        }
    }

    private static void applySingleResourcepack(class_3222 player, String link, String sha1, String message) {
        UUID id = UUID.nameUUIDFromBytes(link.getBytes(StandardCharsets.UTF_8));
        class_2720 resourcepackPacket = new class_2720(id, link, sha1, false, Optional.of(class_2561.method_43471((String)message)));
        player.field_13987.method_14364((class_2596)resourcepackPacket);
    }

    private static void removeSingleResourcepack(class_3222 player, String link) {
        UUID id = UUID.nameUUIDFromBytes(link.getBytes(StandardCharsets.UTF_8));
        class_9053 removePackPacket = new class_9053(Optional.of(id));
        player.field_13987.method_14364((class_2596)removePackPacket);
    }

    public static List<class_1799> getPlayerInventory(class_3222 player) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            list.add(itemStack);
        }
        return list;
    }

    public static void clearItemStack(class_3222 player, class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return;
        }
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.equals(itemStack)) continue;
            inventory.method_5441(i);
        }
    }

    public static class_1297 getEntityLookingAt(class_3222 player, double maxDistance) {
        class_243 direction;
        class_243 end;
        class_243 start = player.method_5836(1.0f);
        class_3966 entityHit = class_1675.method_18075((class_1297)player, (class_243)start, (class_243)(end = start.method_1019(direction = player.method_5828(1.0f).method_1029().method_1021(maxDistance))), (class_238)player.method_5829().method_18804(direction).method_1014(1.0), entity -> !entity.method_7325() && entity.method_5805(), (double)(maxDistance * maxDistance));
        if (entityHit instanceof class_3966) {
            class_3966 entityHitResult = entityHit;
            return entityHitResult.method_17782();
        }
        return null;
    }

    public static class_243 getPosLookingAt(class_3222 player, double maxDistance) {
        class_239 blockHit = player.method_5745(maxDistance, 1.0f, false);
        if (Math.sqrt(blockHit.method_24801((class_1297)player)) >= maxDistance * 0.99) {
            return null;
        }
        if (blockHit instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)blockHit;
            return blockHitResult.method_17784();
        }
        return null;
    }

    public static boolean isFakePlayer(class_1657 player) {
        return player instanceof FakePlayer;
    }

    public static void displayMessageToPlayer(class_3222 player, class_2561 text, int timeFor) {
        Session.skipTimer.put(player.method_5667(), timeFor / 5);
        player.method_7353(text, true);
    }

    public static void updatePlayerInventory(class_3222 player) {
        if (updateInventoryQueue.contains(player.method_5667())) {
            return;
        }
        updateInventoryQueue.add(player.method_5667());
    }

    public static void resendCommandTree(class_3222 player) {
        if (player == null) {
            return;
        }
        if (player.method_5682() == null) {
            return;
        }
        player.method_5682().method_3734().method_9241(player);
    }

    public static void resendCommandTrees() {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            PlayerUtils.resendCommandTree(player);
        }
    }

    public static class_1799 getEquipmentSlot(class_1657 player, int slot) {
        return player.method_31548().method_5438(slot + 36);
    }

    public static List<class_1799> getArmorItems(class_3222 player) {
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        result.add(PlayerUtils.getEquipmentSlot((class_1657)player, 0));
        result.add(PlayerUtils.getEquipmentSlot((class_1657)player, 1));
        result.add(PlayerUtils.getEquipmentSlot((class_1657)player, 2));
        result.add(PlayerUtils.getEquipmentSlot((class_1657)player, 3));
        return result;
    }

    public static void updatePlayerLists() {
        if (Main.server == null) {
            return;
        }
        if (Main.currentSeason == null) {
            return;
        }
        List allPlayers = Main.server.method_3760().method_14571();
        for (class_3222 receivingPlayer : allPlayers) {
            ArrayList<class_3222> visiblePlayers = new ArrayList<class_3222>();
            ArrayList<UUID> hiddenPlayerUUIDs = new ArrayList<UUID>();
            ArrayList<String> hiddenPlayerNames = new ArrayList<String>();
            for (class_3222 player : allPlayers) {
                if (player == receivingPlayer) continue;
                boolean hidePlayer = false;
                if (!(Main.currentSeason.TAB_LIST_SHOW_DEAD_PLAYERS || !Main.livesManager.isAlive(receivingPlayer) || Main.livesManager.isAlive(player) || WatcherManager.isWatcher((class_1657)player) || Necromancy.isRessurectedPlayer(player))) {
                    hidePlayer = true;
                }
                if (!Main.currentSeason.WATCHERS_IN_TAB && !WatcherManager.isWatcher((class_1657)receivingPlayer) && WatcherManager.isWatcher((class_1657)player)) {
                    hidePlayer = true;
                }
                if (hidePlayer) {
                    hiddenPlayerUUIDs.add(player.method_5667());
                    hiddenPlayerNames.add(player.method_5820());
                    continue;
                }
                visiblePlayers.add(player);
            }
            if (!visiblePlayers.isEmpty()) {
                receivingPlayer.field_13987.method_14364((class_2596)class_2703.method_43886(visiblePlayers));
            }
            if (!hiddenPlayerUUIDs.isEmpty()) {
                class_7828 hidePacket = new class_7828(hiddenPlayerUUIDs);
                receivingPlayer.field_13987.method_14364((class_2596)hidePacket);
            }
            NetworkHandlerServer.sendStringListPacket(receivingPlayer, PacketNames.UPDATE_HIDDEN_PLAYERS, hiddenPlayerNames);
        }
    }

    public static class_3218 getServerWorld(class_3222 player) {
        return player.method_51469();
    }

    public static void onTick() {
        if (!broadcastCooldown.isEmpty()) {
            HashMap<class_2561, Integer> newCooldowns = new HashMap<class_2561, Integer>();
            for (Map.Entry<class_2561, Integer> entry : broadcastCooldown.entrySet()) {
                Integer value;
                class_2561 key = entry.getKey();
                Integer n = value = entry.getValue();
                value = value - 1;
                if (value <= 0) continue;
                newCooldowns.put(key, value);
            }
            broadcastCooldown = newCooldowns;
        }
        if (!updateInventoryQueue.isEmpty()) {
            for (UUID uuid : updateInventoryQueue) {
                class_3222 player = PlayerUtils.getPlayer(uuid);
                if (player == null) continue;
                player.method_31548().method_7381();
                player.field_7512.method_7623();
                if (player.method_68878()) continue;
                player.field_7512.method_34252();
                player.field_7498.method_34252();
            }
            updateInventoryQueue.clear();
        }
    }

    public static void broadcastMessage(class_2561 message) {
        PlayerUtils.broadcastMessage(message, 1);
    }

    public static void broadcastMessageToAdmins(class_2561 message) {
        PlayerUtils.broadcastMessageToAdmins(message, 1);
    }

    public static void broadcastMessageExcept(class_2561 message, class_3222 exceptPlayer) {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            if (player == exceptPlayer) continue;
            player.method_7353(message, false);
        }
    }

    public static void broadcastMessage(class_2561 message, int cooldownTicks) {
        if (broadcastCooldown.containsKey(message)) {
            return;
        }
        broadcastCooldown.put(message, cooldownTicks);
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            player.method_7353(message, false);
        }
    }

    public static void broadcastMessageToAdmins(class_2561 message, int cooldownTicks) {
        if (broadcastCooldown.containsKey(message)) {
            return;
        }
        broadcastCooldown.put(message, cooldownTicks);
        for (class_3222 player : PlayerUtils.getAdminPlayers()) {
            player.method_7353(message, false);
        }
        Main.LOGGER.info(message.getString());
    }

    public static void teleport(class_3222 player, class_2338 pos) {
        PlayerUtils.teleport(player, PlayerUtils.getServerWorld(player), pos.method_61082());
    }

    public static void teleport(class_3222 player, class_243 pos) {
        PlayerUtils.teleport(player, PlayerUtils.getServerWorld(player), pos);
    }

    public static void teleport(class_3222 player, double destX, double destY, double destZ) {
        PlayerUtils.teleport(player, PlayerUtils.getServerWorld(player), destX, destY, destZ);
    }

    public static void teleport(class_3222 player, class_3218 world, double destX, double destY, double destZ) {
        PlayerUtils.teleport(player, world, destX, destY, destZ, player.method_36454(), player.method_36455());
    }

    public static void teleport(class_3222 player, class_3218 world, class_2338 pos) {
        PlayerUtils.teleport(player, world, pos.method_61082());
    }

    public static void teleport(class_3222 player, class_3218 world, class_243 pos) {
        PlayerUtils.teleport(player, world, pos.method_10216(), pos.method_10214(), pos.method_10215(), player.method_36454(), player.method_36455());
    }

    public static void teleport(class_3222 player, class_3218 world, class_243 pos, float yaw, float pitch) {
        PlayerUtils.teleport(player, world, pos.method_10216(), pos.method_10214(), pos.method_10215(), yaw, pitch);
    }

    public static void teleport(class_3222 player, class_3218 world, double destX, double destY, double destZ, float yaw, float pitch) {
        player.method_48105(world, destX, destY, destZ, EnumSet.noneOf(class_2709.class), yaw, pitch, false);
    }

    public static void safelyPutIntoSurvival(class_3222 player) {
        if (player.field_13974.method_14257() == class_1934.field_9215) {
            return;
        }
        class_2338.class_2339 playerBlockPos = player.method_24515().method_25503();
        int safeY = WorldUtils.findTopSafeY((class_1937)PlayerUtils.getServerWorld(player), playerBlockPos.method_46558());
        playerBlockPos.method_33098(safeY);
        PlayerUtils.teleport(player, (class_2338)playerBlockPos);
        player.method_7336(class_1934.field_9215);
    }

    public static class_3222 getPlayerOrProjection(class_3222 player) {
        if (player == null) {
            return null;
        }
        if (!PlayerUtils.isFakePlayer((class_1657)player)) {
            return player;
        }
        if (player instanceof FakePlayer) {
            FakePlayer fakePlayer = (FakePlayer)player;
            return PlayerUtils.getPlayer(fakePlayer.shadow);
        }
        return player;
    }

    public static void damage(class_3222 player, class_3218 world, class_1282 source, float amount) {
        player.method_64397(world, source, amount);
    }

    public static void damage(class_3222 player, class_1282 source, float amount) {
        PlayerUtils.damage(player, PlayerUtils.getServerWorld(player), source, amount);
    }

    public static void killFromSource(class_3222 player, class_1282 source) {
        player.method_6033(1.0E-4f);
        PlayerUtils.damage(player, source, 10.0f);
        if (player.method_5805()) {
            player.method_5768(PlayerUtils.getServerWorld(player));
        }
    }
}

