/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.resources.datapack;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class OldDatapackManager {
    public static boolean deletedOldDatapacks = false;

    public static void deleteOldDatapacks(MinecraftServer server) {
        if (server == null) {
            return;
        }
        if (deletedOldDatapacks) {
            return;
        }
        deletedOldDatapacks = true;
        Path datapackFolder = server.method_27050(class_5218.field_24186);
        try {
            for (Seasons season : Seasons.getAllImplemented()) {
                Path datapackPath;
                String datapackName = Seasons.getDatapackName(season);
                if (datapackName == null || !Files.exists(datapackPath = datapackFolder.resolve(datapackName), new LinkOption[0]) || !Files.isRegularFile(datapackPath, new LinkOption[0])) continue;
                Files.delete(datapackPath);
                Main.LOGGER.info("[LifeSeries] Deleted old datapack: {}", (Object)datapackName);
            }
        }
        catch (Exception e) {
            Main.LOGGER.error("Error deleting datapacks: {}", (Object)e.getMessage());
        }
    }

    public static void disableOldDatapacks() {
        for (Seasons season : Seasons.getAllImplemented()) {
            String datapackName = Seasons.getDatapackName(season);
            OtherUtils.executeCommand("datapack disable \"file/" + datapackName + "\"");
        }
    }
}

