/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.session;

import java.util.ArrayList;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.secretlife.Task;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SessionTranscript {
    public static final List<String> messages = new ArrayList<String>();

    public static void newSuperpower(class_3222 player, Superpowers superpower) {
        SessionTranscript.addMessageWithTime(player.method_5820() + " has been assigned the " + Superpowers.getString(superpower) + " superpower.");
    }

    public static void newTriviaBot(class_3222 player) {
        SessionTranscript.addMessageWithTime("Spawned trivia bot for " + player.method_5820());
    }

    public static void endingIsYours() {
        SessionTranscript.addMessageWithTime("The ending is yours... Make it WILD.");
    }

    public static void newHungerRule() {
        SessionTranscript.addMessageWithTime("[Wildcard] Food has been randomized.");
    }

    public static void mobSwap() {
        SessionTranscript.addMessageWithTime("[Wildcard] Mobs have been swapped.");
    }

    public static void deactivateWildcard(Wildcards type) {
        SessionTranscript.addMessageWithTime("Deactivated Wildcard: " + String.valueOf((Object)type));
    }

    public static void activateWildcard(Wildcards type) {
        SessionTranscript.addMessageWithTime("Activated Wildcard: " + String.valueOf((Object)type));
    }

    public static void logPlayers() {
        ArrayList<String> names = new ArrayList<String>();
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            names.add(player.method_5820());
        }
        SessionTranscript.addMessageWithTime("Players online: " + String.join((CharSequence)", ", names));
    }

    public static void rerollTask(class_3222 player) {
        SessionTranscript.addMessageWithTime(player.method_5820() + " has rerolled their task.");
    }

    public static void successTask(class_3222 player) {
        SessionTranscript.addMessageWithTime(player.method_5820() + " has passed their task.");
    }

    public static void failTask(class_3222 player) {
        SessionTranscript.addMessageWithTime(player.method_5820() + " has failed their task.");
    }

    public static void assignTask(class_3222 player, Task task, List<String> linesStr) {
        SessionTranscript.addMessageWithTime(player.method_5820() + " has been given a " + task.type.name() + " task: " + String.join((CharSequence)" ", linesStr));
    }

    public static void claimKill(class_3222 killer, class_3222 victim) {
        SessionTranscript.addMessageWithTime(killer.method_5820() + "'s kill claim of " + victim.method_5820() + " has been accepted.");
    }

    public static void soulmate(class_3222 player, class_3222 soulmate) {
        SessionTranscript.addMessageWithTime(player.method_5820() + "'s soulmate has been chosen to be " + soulmate.method_5820());
    }

    public static void assignRandomLives(class_3222 player, int amount) {
        SessionTranscript.addMessageWithTime(player.method_5820() + " has been randomly assigned " + amount + " lives");
    }

    public static void givelife(class_2561 playerName, class_3222 target) {
        SessionTranscript.addMessageWithTime("<@", "> ", playerName.getString() + " gave a life to " + target.method_5820());
    }

    public static void playerLeave(class_3222 player) {
        SessionTranscript.addMessageWithTime("<@", "> ", player.method_5820() + " left the game.");
    }

    public static void playerJoin(class_3222 player) {
        SessionTranscript.addMessageWithTime("<@", "> ", player.method_5820() + " joined the game.");
    }

    public static void triggerSessionAction(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        SessionTranscript.addMessageWithTime("TRIGGERED_SESSION_ACTION: " + message);
    }

    public static void onPlayerDeath(class_3222 player, class_1282 source) {
        SessionTranscript.addMessageWithTime("<@", "> ", source.method_5506((class_1309)player).getString());
    }

    public static void onPlayerLostAllLives(class_3222 player) {
        SessionTranscript.addMessageWithTime(player.method_5820() + " lost all lives.");
    }

    public static void boogeymenChosen(List<class_3222> players) {
        ArrayList<String> names = new ArrayList<String>();
        for (class_3222 player : players) {
            names.add(player.method_5820());
        }
        SessionTranscript.addMessageWithTime("Boogeymen chosen: " + String.join((CharSequence)", ", names));
    }

    public static void sessionStart() {
        SessionTranscript.addMessageWithTime("-----  Session started!  -----");
    }

    public static void sessionEnd() {
        SessionTranscript.addMessageWithTime("-----  The session has ended!  -----");
    }

    public static void addMessageWithTime(String message) {
        SessionTranscript.addMessageWithTime("[@", "] ", message);
    }

    private static void addMessageWithTime(String start, String end, String message) {
        String time = Main.currentSession.getPassedTime();
        Object finalMessage = start + time + end + message;
        if (Main.currentSession.statusNotStarted() || Main.currentSession.statusFinished()) {
            finalMessage = message;
        }
        if (messages.isEmpty()) {
            SessionTranscript.addDefaultMessages();
        }
        messages.add((String)finalMessage);
    }

    public static void resetStats() {
        messages.clear();
        SessionTranscript.addDefaultMessages();
    }

    public static void addDefaultMessages() {
        messages.add("-----  Life Series Mod by Mat0u5  |  Mod version: dev-1.3.6.10  -----");
        messages.add("-----  " + Main.currentSeason.getSeason().name() + "  |  Time and date: " + OtherUtils.getTimeAndDate() + "  -----");
        messages.add("-----  Session Transcript  -----");
    }

    public static String getStats() {
        return String.join((CharSequence)"\n", messages);
    }

    public static void sendTranscriptToAdmins() {
        class_2561 sessionTranscript = SessionTranscript.getTranscriptMessage();
        PlayerUtils.broadcastMessageToAdmins(sessionTranscript);
    }

    public static class_2561 getTranscriptMessage() {
        return class_2561.method_43470((String)"\u00a77Click ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10977(class_124.field_1078).method_10958(TextUtils.copyClipboardClickEvent(SessionTranscript.getStats())).method_30938(Boolean.valueOf(true)))).method_10852(class_2561.method_30163((String)"\u00a77 to copy the session transcript."));
    }
}

