/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class ClaimKillCommand {
    public static boolean isAllowed() {
        return Main.currentSeason.getSeason() != Seasons.UNASSIGNED;
    }

    public static boolean checkBanned(class_2168 source) {
        if (ClaimKillCommand.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is only available when you have selected a Season."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"claimkill").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).suggests((context, builder) -> class_2172.method_9265(ClaimKillCommand.getSuggestions(), (SuggestionsBuilder)builder)).executes(context -> ClaimKillCommand.claimCredit((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"validate").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"killer", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"victim", (ArgumentType)class_2186.method_9305()).executes(context -> ClaimKillCommand.claimCreditAccept((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"killer"), class_2186.method_9315((CommandContext)context, (String)"victim")))))));
    }

    public static List<String> getSuggestions() {
        if (Main.server == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        Set<UUID> recentDeaths = Main.currentSession.playerNaturalDeathLog.keySet();
        for (UUID uuid : recentDeaths) {
            class_3222 player = PlayerUtils.getPlayer(uuid);
            if (player == null) continue;
            suggestions.add(player.method_5820());
        }
        return suggestions;
    }

    public static int claimCredit(class_2168 source, class_3222 victim) {
        UUID victimUUID;
        if (ClaimKillCommand.checkBanned(source)) {
            return -1;
        }
        if (victim == null) {
            return -1;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        Set<UUID> recentDeaths = Main.currentSession.playerNaturalDeathLog.keySet();
        if (!recentDeaths.contains(victimUUID = victim.method_5667())) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} did not die in the last 2 minutes. Or they might have been killed by a player directly.", victim));
            return -1;
        }
        if (player == victim) {
            source.method_9213(class_2561.method_30163((String)"You cannot claim credit for your own death :P"));
            return -1;
        }
        class_5250 textAll = TextUtils.format("{}\u00a77 claims credit for {}\u00a77's death. Only an admin can validate this claim.", player, victim);
        PlayerUtils.broadcastMessage((class_2561)textAll);
        String validateCommand = TextUtils.formatString("/claimkill validate {} {}", player, victim);
        class_5250 adminText = class_2561.method_43470((String)"\u00a77Click ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10977(class_124.field_1078).method_10958(TextUtils.runCommandClickEvent(validateCommand)).method_30938(Boolean.valueOf(true)))).method_10852(class_2561.method_30163((String)"\u00a77 to accept the claim if you think it's valid."));
        PlayerUtils.broadcastMessageToAdmins((class_2561)adminText, 120);
        return 1;
    }

    public static int claimCreditAccept(class_2168 source, class_3222 killer, class_3222 victim) {
        if (ClaimKillCommand.checkBanned(source)) {
            return -1;
        }
        if (killer == null) {
            return -1;
        }
        if (victim == null) {
            return -1;
        }
        class_5250 message = TextUtils.format("{}\u00a77's kill claim on {}\u00a77 was accepted.", killer, victim);
        PlayerUtils.broadcastMessage((class_2561)message);
        Main.currentSeason.onClaimKill(killer, victim);
        Main.currentSession.playerNaturalDeathLog.remove(victim.method_5667());
        return 1;
    }
}

