/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.secretlife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLife;
import net.mat0u5.lifeseries.seasons.season.secretlife.Task;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskManager;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskTypes;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class SecretLifeCommands {
    public static final List<UUID> playersGiven = new ArrayList<UUID>();

    public static boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.SECRET_LIFE;
    }

    public static boolean checkBanned(class_2168 source) {
        if (SecretLifeCommands.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is only available when playing Secret Life."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"health").requires(source -> SecretLifeCommands.isAllowed())).executes(context -> SecretLifeCommands.showHealth((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"sync").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> SecretLifeCommands.syncHealth((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> SecretLifeCommands.healthManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), 1.0, false))).then(class_2170.method_9244((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> SecretLifeCommands.healthManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), false)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> SecretLifeCommands.healthManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), -1.0, false))).then(class_2170.method_9244((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> SecretLifeCommands.healthManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), -DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), false)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> SecretLifeCommands.healthManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), true)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> SecretLifeCommands.getHealthFor((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> SecretLifeCommands.resetHealth((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"task").requires(source -> SecretLifeCommands.isAllowed() && (PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null))).then(class_2170.method_9247((String)"succeed").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> SecretLifeCommands.succeedTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"fail").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> SecretLifeCommands.failTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"reroll").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> SecretLifeCommands.rerollTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"assignRandom").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> SecretLifeCommands.assignTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"clearTask").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> SecretLifeCommands.clearTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(List.of("easy", "hard", "red"), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"task", (ArgumentType)StringArgumentType.greedyString()).executes(context -> SecretLifeCommands.setTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"task"))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gift").requires(source -> SecretLifeCommands.isAllowed())).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> SecretLifeCommands.gift((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"secretlife").requires(source -> SecretLifeCommands.isAllowed() && (PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null))).then(class_2170.method_9247((String)"changeLocations").executes(context -> SecretLifeCommands.changeLocations((class_2168)context.getSource()))));
    }

    public static int setTask(class_2168 source, Collection<class_3222> targets, String type, String task) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        TaskTypes taskType = TaskTypes.EASY;
        if (type.equalsIgnoreCase("hard")) {
            taskType = TaskTypes.HARD;
        }
        if (type.equalsIgnoreCase("red")) {
            taskType = TaskTypes.RED;
        }
        task = task.replaceAll("\\\\n", "\n");
        for (class_3222 player : targets) {
            TaskManager.preAssignedTasks.put(player.method_5667(), new Task(task, taskType));
            if (TaskManager.removePlayersTaskBook(player) || TaskManager.tasksChosen) {
                TaskManager.assignRandomTaskToPlayer(player, taskType);
                AnimationUtils.playTotemAnimation(player);
                if (targets.size() != 1) continue;
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Changed {}'s task", player));
                continue;
            }
            if (targets.size() != 1) continue;
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Pre-assigned {}'s task for randomization", player));
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77They will be given the task book once you / the game rolls the tasks"));
        }
        if (targets.size() != 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Changed or pre-assigned task of {} targets", targets.size()));
        }
        return 1;
    }

    public static int changeLocations(class_2168 source) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Changing Secret Life locations..."));
        TaskManager.deleteLocations();
        TaskManager.checkSecretLifePositions();
        return 1;
    }

    public static int clearTask(class_2168 source, Collection<class_3222> targets) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        ArrayList<class_3222> affected = new ArrayList<class_3222>();
        for (class_3222 player : targets) {
            if (!TaskManager.removePlayersTaskBook(player)) continue;
            affected.add(player);
        }
        if (affected.isEmpty()) {
            source.method_9213(class_2561.method_30163((String)"No task books were found"));
            return -1;
        }
        if (affected.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Removed task book from {}", affected.getFirst()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Removed task book from {} targets", affected.size()));
        }
        return 1;
    }

    public static int assignTask(class_2168 source, Collection<class_3222> targets) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Assigning random task to {}", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Assigning random tasks to {} targets", targets.size()));
        }
        TaskManager.chooseTasks(targets.stream().toList(), null);
        return 1;
    }

    public static int succeedTask(class_2168 source, Collection<class_3222> targets) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Succeeding task for {}\u00a77...", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Succeeding task for {}\u00a77 targets...", targets.size()));
        }
        for (class_3222 player : targets) {
            TaskManager.succeedTask(player, true);
        }
        return 1;
    }

    public static int failTask(class_2168 source, Collection<class_3222> targets) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Failing task for {}\u00a77...", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Failing task for {}\u00a77 targets...", targets.size()));
        }
        for (class_3222 player : targets) {
            TaskManager.failTask(player, true);
        }
        return 1;
    }

    public static int rerollTask(class_2168 source, Collection<class_3222> targets) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Rerolling task for {}\u00a77...", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Rerolling task for {}\u00a77 targets...", targets.size()));
        }
        for (class_3222 player : targets) {
            TaskManager.rerollTask(player, true);
        }
        return 1;
    }

    public static int gift(class_2168 source, class_3222 target) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        SecretLife secretLife = (SecretLife)Main.currentSeason;
        if (target == self) {
            source.method_9213(class_2561.method_30163((String)"Nice Try."));
            return -1;
        }
        if (playersGiven.contains(self.method_5667())) {
            source.method_9213(class_2561.method_30163((String)"You have already gifted a heart this session"));
            return -1;
        }
        if (!Main.livesManager.isAlive(target)) {
            source.method_9213(class_2561.method_30163((String)"That player is not alive"));
            return -1;
        }
        if (!Main.currentSession.statusStarted()) {
            source.method_9213(class_2561.method_30163((String)"The session has not started"));
            return -1;
        }
        playersGiven.add(self.method_5667());
        secretLife.addPlayerHealth(target, 2.0);
        class_5250 senderMessage = TextUtils.format("You have gifted a heart to {}", target);
        class_5250 recipientMessage = TextUtils.format("{} gave you a heart", self);
        self.method_64398((class_2561)senderMessage);
        PlayerUtils.sendTitle(target, (class_2561)recipientMessage, 20, 20, 20);
        target.method_64398((class_2561)recipientMessage);
        AnimationUtils.createSpiral(target, 40);
        PlayerUtils.playSoundToPlayers(List.of(self, target), class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"secretlife_life")));
        return 1;
    }

    public static int showHealth(class_2168 source) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        SecretLife secretLife = (SecretLife)Main.currentSeason;
        if (!Main.livesManager.isAlive(self)) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"You're dead..."));
            return -1;
        }
        double playerHealth = secretLife.getRoundedHealth(self);
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("You have {} health", playerHealth));
        return 1;
    }

    public static int getHealthFor(class_2168 source, class_3222 target) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        SecretLife secretLife = (SecretLife)Main.currentSeason;
        if (!Main.livesManager.isAlive(target)) {
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{} is dead", target));
            return -1;
        }
        double playerHealth = secretLife.getRoundedHealth(target);
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{} has {} health", target, playerHealth));
        return 1;
    }

    public static int syncHealth(class_2168 source) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        SecretLife secretLife = (SecretLife)Main.currentSeason;
        secretLife.syncAllPlayerHealth();
        return 1;
    }

    public static int healthManager(class_2168 source, Collection<class_3222> targets, double amount, boolean setNotGive) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        SecretLife secretLife = (SecretLife)Main.currentSeason;
        if (setNotGive) {
            for (class_3222 player : targets) {
                secretLife.setPlayerHealth(player, amount);
            }
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set {}'s health to {}", targets.iterator().next(), amount));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set the health of {} targets to {}", targets.size(), amount));
            }
        } else {
            String toOrFrom;
            for (class_3222 player : targets) {
                secretLife.addPlayerHealth(player, amount);
            }
            String addOrRemove = amount >= 0.0 ? "Added" : "Removed";
            String string = toOrFrom = amount >= 0.0 ? "to" : "from";
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} health {} {}", addOrRemove, Math.abs(amount), toOrFrom, targets.iterator().next()));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} health {} {} targets", addOrRemove, Math.abs(amount), toOrFrom, targets.size()));
            }
        }
        return 1;
    }

    public static int resetHealth(class_2168 source, Collection<class_3222> targets) {
        if (SecretLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        for (class_3222 player : targets) {
            SecretLife secretLife = (SecretLife)Main.currentSeason;
            secretLife.resetPlayerHealth(player);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset {}'s health to the default", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset the health to default for {} targets", targets.size()));
        }
        return 1;
    }
}

