/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.trivia;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.features.Trivia;
import net.mat0u5.lifeseries.gui.DefaultScreen;
import net.mat0u5.lifeseries.gui.trivia.ConfirmQuizAnswerScreen;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.utils.TextColors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8113;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class QuizScreen
extends DefaultScreen {
    private static final int[] ANSWER_COLORS = new int[]{TextColors.PASTEL_BLUE, TextColors.PASTEL_ORANGE, TextColors.PASTEL_LIME, TextColors.PASTEL_YELLOW, TextColors.PASTEL_RED};
    private final List<List<class_5481>> answers = new ArrayList<List<class_5481>>();
    private String difficulty = "Difficulty: null";
    private long timerSeconds = 120L;
    private final List<Rectangle> answerRects = new ArrayList<Rectangle>();

    public QuizScreen() {
        super((class_2561)class_2561.method_43470((String)"Quiz Screen"));
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.timerSeconds = Trivia.getRemainingTime();
        int fifth3 = this.startX + this.BG_WIDTH / 5 * 3;
        int answersStartX = fifth3 + 15;
        int answersStopX = this.endX - 15;
        int maxWidth = answersStopX - answersStartX;
        int currentYPos = this.startY + 30;
        int gap = 8;
        this.answers.clear();
        this.answerRects.clear();
        for (int i = 0; i < Trivia.answers.size(); ++i) {
            char answerIndex = (char)(i + 65);
            class_5250 label = class_2561.method_43470((String)(answerIndex + ": ")).method_27692(class_124.field_1067);
            class_5250 answerText = class_2561.method_43470((String)Trivia.answers.get(i));
            answerText.method_10862(answerText.method_10866().method_10982(Boolean.valueOf(false)));
            class_5250 text = label.method_10852((class_2561)answerText);
            List answer = this.field_22793.method_1728((class_5348)text, maxWidth);
            this.answers.add(answer);
            Objects.requireNonNull(this.field_22793);
            int answerBoxHeight = 9 * answer.size() + 2;
            int answerBoxWidth = 0;
            for (class_5481 line : answer) {
                int lineWidth = this.field_22793.method_30880(line);
                if (lineWidth <= answerBoxWidth) continue;
                answerBoxWidth = lineWidth;
            }
            Rectangle rect = new Rectangle(answersStartX, currentYPos, answerBoxWidth += 2, answerBoxHeight);
            this.answerRects.add(rect);
            currentYPos += answerBoxHeight + gap;
        }
        switch (Trivia.difficulty) {
            case 1: {
                this.difficulty = "Difficulty: Easy";
                break;
            }
            case 2: {
                this.difficulty = "Difficulty: Medium";
                break;
            }
            case 3: {
                this.difficulty = "Difficulty: Hard";
                break;
            }
            default: {
                this.difficulty = "Difficulty: null";
            }
        }
    }

    public void method_25393() {
        super.method_25393();
        this.timerSeconds = Trivia.getRemainingTime();
        if (this.timerSeconds <= 0L) {
            this.method_25419();
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (int i = 0; i < this.answerRects.size(); ++i) {
                if (!this.answerRects.get(i).contains(mouseX, mouseY)) continue;
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new ConfirmQuizAnswerScreen(this, i));
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY) {
        int i;
        int fifth1 = this.startX + this.BG_WIDTH / 5;
        int fifth2 = this.startX + this.BG_WIDTH / 5 * 2;
        int fifth4 = this.startX + this.BG_WIDTH / 5 * 4;
        int questionX = this.startX + 10;
        int questionWidth = fifth2 - 10 - questionX;
        int minY = this.startY + 9;
        int maxY = this.endY - 23;
        int questionY = this.startY + 30;
        long minutes = this.timerSeconds / 60L;
        long seconds = this.timerSeconds - minutes * 60L;
        Object secondsStr = String.valueOf(seconds);
        Object minutesStr = String.valueOf(minutes);
        while (((String)secondsStr).length() < 2) {
            secondsStr = "0" + (String)secondsStr;
        }
        while (((String)minutesStr).length() < 2) {
            minutesStr = "0" + (String)minutesStr;
        }
        if (this.timerSeconds <= 5L) {
            RenderUtils.drawTextCenter(context, this.field_22793, TextColors.RED, class_2561.method_30163((String)((String)minutesStr + ":" + (String)secondsStr)), this.centerX, minY);
        } else if (this.timerSeconds <= 30L) {
            RenderUtils.drawTextCenter(context, this.field_22793, TextColors.ORANGE, class_2561.method_30163((String)((String)minutesStr + ":" + (String)secondsStr)), this.centerX, minY);
        } else {
            RenderUtils.drawTextCenter(context, this.field_22793, class_2561.method_30163((String)((String)minutesStr + ":" + (String)secondsStr)), this.centerX, minY);
        }
        RenderUtils.drawTextCenter(context, this.field_22793, class_2561.method_30163((String)this.difficulty), this.centerX, maxY);
        RenderUtils.drawTextCenter(context, this.field_22793, (class_2561)class_2561.method_43470((String)"Question").method_27692(class_124.field_1073), fifth1, minY);
        List wrappedQuestion = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)Trivia.question), questionWidth);
        for (i = 0; i < wrappedQuestion.size(); ++i) {
            class_5481 class_54812 = (class_5481)wrappedQuestion.get(i);
            Objects.requireNonNull(this.field_22793);
            RenderUtils.drawOrderedTextLeft(context, this.field_22793, DEFAULT_TEXT_COLOR, class_54812, questionX, questionY + i * 9);
        }
        RenderUtils.drawTextCenter(context, this.field_22793, (class_2561)class_2561.method_43470((String)"Answers").method_27692(class_124.field_1073), fifth4, minY);
        for (i = 0; i < Trivia.answers.size(); ++i) {
            Rectangle rect = this.answerRects.get(i);
            int borderColor = ANSWER_COLORS[i % ANSWER_COLORS.length];
            context.method_25294(rect.x - 1, rect.y - 1, rect.x + rect.width + 1, rect.y, borderColor);
            context.method_25294(rect.x - 1, rect.y + rect.height, rect.x + rect.width + 2, rect.y + rect.height + 2, borderColor);
            context.method_25294(rect.x - 1, rect.y, rect.x, rect.y + rect.height, borderColor);
            context.method_25294(rect.x + rect.width, rect.y - 1, rect.x + rect.width + 2, rect.y + rect.height, borderColor);
            boolean hovered = rect.contains(mouseX, mouseY);
            int textColor = hovered ? TextColors.WHITE : DEFAULT_TEXT_COLOR;
            int lineY = rect.y + 2;
            for (class_5481 line : this.answers.get(i)) {
                RenderUtils.drawOrderedTextLeft(context, this.field_22793, textColor, line, rect.x + 1, lineY);
                Objects.requireNonNull(this.field_22793);
                lineY += 9;
            }
        }
        context.method_25294(this.centerX - 33, this.centerY - 55, this.centerX + 33, this.centerY + 55, TextColors.BLACK);
        this.drawEntity(context, this.startX, this.startY, mouseX, mouseY, this.centerX, this.centerY - 50, 40);
    }

    private void drawEntity(class_332 context, int i, int j, int mouseX, int mouseY, int x, int y, int size) {
        if (this.field_22787 == null) {
            return;
        }
        if (this.field_22787.field_1687 == null) {
            return;
        }
        if (this.field_22787.field_1724 == null) {
            return;
        }
        ArrayList<class_8113.class_8122> allEntities = new ArrayList<class_8113.class_8122>();
        ArrayList<class_8113.class_8122> matchingBotEntities = new ArrayList<class_8113.class_8122>();
        for (class_8113.class_8122 entity2 : this.field_22787.field_1687.method_8390(class_8113.class_8122.class, this.field_22787.field_1724.method_5829().method_1014(10.0), entity -> true)) {
            if (MainClient.triviaBotPartUUIDs.contains(entity2.method_5667())) {
                matchingBotEntities.add(entity2);
            }
            allEntities.add(entity2);
        }
        if (matchingBotEntities.isEmpty()) {
            matchingBotEntities = allEntities;
        }
        for (class_8113.class_8122 entity2 : matchingBotEntities) {
            QuizScreen.drawEntity(context, x - 30, y - 55, x + 30, y + 85, size, 0.0625f, mouseX, mouseY, (class_1297)entity2);
        }
    }

    public static void drawEntity(class_332 context, int x1, int y1, int x2, int y2, int size, float f, float mouseX, float mouseY, class_1297 entity) {
        context.method_44379(x1, y1, x2, y2);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(0.0f);
        quaternionf.mul((Quaternionfc)quaternionf2);
        float originalYaw = entity.method_36454();
        float originalPitch = entity.method_36455();
        entity.method_36456(180.0f);
        entity.method_36457(0.0f);
        Vector3f vector3f = new Vector3f(0.0f, entity.method_17682() / 2.0f + f, 0.0f);
        QuizScreen.drawEntity(context, (float)(x1 + x2) / 2.0f, (float)(y1 + y2) / 2.0f, size, vector3f, quaternionf, quaternionf2, entity);
        entity.method_36456(originalYaw);
        entity.method_36457(originalPitch);
        context.method_44380();
    }

    public static void drawEntity(class_332 context, float x, float y, float size, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, class_1297 entity) {
        context.method_51448().method_22903();
        context.method_51448().method_22904((double)x, (double)y, 50.0);
        context.method_51448().method_22905(size, size, -size);
        context.method_51448().method_46416(vector3f.x, vector3f.y, vector3f.z);
        context.method_51448().method_22907(quaternionf);
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        if (quaternionf2 != null) {
            entityRenderDispatcher.method_24196(quaternionf2.conjugate(new Quaternionf()).rotateY((float)Math.PI));
        }
        entityRenderDispatcher.method_3948(false);
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, context.method_51448(), (class_4597)context.method_51450(), 0xF000F0));
        context.method_51452();
        entityRenderDispatcher.method_3948(true);
        context.method_51448().method_22909();
        class_308.method_24211();
    }
}

