/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.mixin.client;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.features.Trivia;
import net.minecraft.class_2561;
import net.minecraft.class_2703;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_7828;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_634.class}, priority=1)
public class ClientPlayNetworkHandlerMixin {
    @Unique
    private static final List<String> notAllowedCommand = List.of("msg", "tell", "whisper", "w", "me");
    @Final
    @Shadow
    private Map<UUID, class_640> field_3693;
    @Unique
    private final Map<UUID, class_640> copy_playerListEntries = Maps.newHashMap();

    @Inject(method={"sendChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSendChatMessage(String message, CallbackInfo ci) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        if (Trivia.isDoingTrivia()) {
            class_310.method_1551().field_1724.method_43496(class_2561.method_30163((String)"<Trivia Bot> No phoning a friend allowed!"));
            ci.cancel();
            return;
        }
        if (MainClient.mutedForTicks > 0) {
            class_310.method_1551().field_1724.method_43496(class_2561.method_30163((String)"Dead players aren't allowed to talk in chat! Admins can change this behavior."));
            ci.cancel();
            return;
        }
    }

    @Inject(method={"sendChatCommand"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSendChatCommand(String command, CallbackInfo ci) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        if (!Trivia.isDoingTrivia()) {
            return;
        }
        for (String s : notAllowedCommand) {
            if (!command.startsWith(s + " ")) continue;
            class_310.method_1551().field_1724.method_43496(class_2561.method_30163((String)"<Trivia Bot> No phoning a friend allowed!"));
            ci.cancel();
            return;
        }
    }

    @Inject(method={"handlePlayerListAction"}, at={@At(value="HEAD")}, cancellable=true)
    private void handlePlayerListAction(class_2703.class_5893 action, class_2703.class_2705 receivedEntry, class_640 currentEntry, CallbackInfo ci) {
        if (action == class_2703.class_5893.field_29139) {
            return;
        }
        if (receivedEntry.comp_1107() == null) {
            return;
        }
        if (receivedEntry.comp_1107().getName().startsWith("`")) {
            ci.cancel();
        }
    }

    @Inject(method={"getPlayerListEntry(Ljava/util/UUID;)Lnet/minecraft/client/network/PlayerListEntry;"}, at={@At(value="RETURN")}, cancellable=true)
    public void getPlayerListEntry(UUID uuid, CallbackInfoReturnable<class_640> cir) {
        if (cir.getReturnValue() != null) {
            return;
        }
        cir.setReturnValue((Object)this.copy_playerListEntries.get(uuid));
    }

    @Inject(method={"onPlayerRemove"}, at={@At(value="HEAD")})
    public void onPlayerRemove(class_7828 packet, CallbackInfo ci) {
        for (UUID uUID : packet.comp_1105()) {
            class_640 playerListEntry = this.field_3693.get(uUID);
            if (playerListEntry == null) continue;
            this.copy_playerListEntries.put(uUID, playerListEntry);
        }
    }
}

