/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.limitedlife;

import java.util.Collection;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.boogeyman.Boogeyman;
import net.mat0u5.lifeseries.seasons.boogeyman.BoogeymanManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeBoogeymanManager;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeConfig;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.enums.SessionTimerStates;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.mat0u5.lifeseries.utils.player.TeamUtils;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9011;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;

public class LimitedLife
extends Season {
    public static final String COMMANDS_ADMIN_TEXT = "/lifeseries, /session, /claimkill, /lives, /boogeyman";
    public static final String COMMANDS_TEXT = "/claimkill, /lives";
    public static int DEFAULT_TIME = 86400;
    public static int YELLOW_TIME = 57600;
    public static int RED_TIME = 28800;
    private boolean SHOW_DEATH_TITLE = true;
    private int DEATH_NORMAL = -3600;
    private int DEATH_BOOGEYMAN = -7200;
    private int KILL_NORMAL = 1800;
    private int KILL_BOOGEYMAN = 3600;
    public static boolean TICK_OFFLINE_PLAYERS = false;
    public static boolean BROADCAST_COLOR_CHANGES = false;
    private int secondCounter = 0;

    @Override
    public Seasons getSeason() {
        return Seasons.LIMITED_LIFE;
    }

    @Override
    public ConfigManager getConfig() {
        return new LimitedLifeConfig();
    }

    @Override
    public BoogeymanManager createBoogeymanManager() {
        return new LimitedLifeBoogeymanManager();
    }

    @Override
    public void displayTimers(MinecraftServer server) {
        String message = "";
        if (this.statusNotStarted()) {
            message = "Session has not started";
        } else if (this.statusStarted()) {
            message = this.getRemainingTime();
        } else if (this.statusPaused()) {
            message = "Session has been paused";
        } else if (this.statusFinished()) {
            message = "Session has ended";
        }
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            if (NetworkHandlerServer.wasHandshakeSuccessful(player)) {
                Integer playerLivesInt;
                long timestamp = SessionTimerStates.OFF.getValue();
                if (this.statusNotStarted()) {
                    timestamp = SessionTimerStates.NOT_STARTED.getValue();
                } else if (this.statusPaused()) {
                    timestamp = SessionTimerStates.PAUSED.getValue();
                } else if (this.statusFinished()) {
                    timestamp = SessionTimerStates.ENDED.getValue();
                } else if (this.sessionLength != null) {
                    long remainingMillis = (this.sessionLength - (int)this.passedTime) * 50;
                    timestamp = System.currentTimeMillis() + remainingMillis;
                }
                if (timestamp != (long)SessionTimerStates.OFF.getValue()) {
                    NetworkHandlerServer.sendLongPacket(player, "session_timer", timestamp);
                }
                if (!this.hasAssignedLives(player) || this.getPlayerLives(player) == null) continue;
                long playerLives = this.isAlive(player) ? ((playerLivesInt = this.getPlayerLives(player)) == null ? -1L : (long)playerLivesInt.intValue()) : -1L;
                String livesColor = this.getColorForLives(this.getPlayerLives(player)).toString();
                NetworkHandlerServer.sendLongPacket(player, "limited_life_timer__" + livesColor, playerLives);
                continue;
            }
            class_5250 fullMessage = class_2561.method_43473();
            if (this.displayTimer.contains(player.method_5667())) {
                fullMessage.method_10852((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1080));
            }
            if (this.hasAssignedLives(player)) {
                if (!fullMessage.getString().isEmpty()) {
                    fullMessage.method_10852(class_2561.method_30163((String)"  |  "));
                }
                fullMessage.method_10852(this.getFormattedLives(this.getPlayerLives(player)));
            }
            player.method_7353((class_2561)fullMessage, true);
        }
    }

    @Override
    public void tickSessionOn(MinecraftServer server) {
        super.tickSessionOn(server);
        --this.secondCounter;
        if (this.secondCounter <= 0) {
            this.secondCounter = 20;
            for (class_3222 player : PlayerUtils.getAllPlayers()) {
                if (!this.statusStarted() || !this.isAlive(player)) continue;
                this.removePlayerLife(player);
            }
            if (TICK_OFFLINE_PLAYERS && this.statusStarted()) {
                Collection<class_9011> entries = ScoreboardUtils.getScores("Lives");
                for (class_9011 entry : entries) {
                    if (entry.comp_2128() <= 0 || PlayerUtils.getPlayer(entry.comp_2127()) != null) continue;
                    ScoreboardUtils.setScore(class_9015.method_55422((String)entry.comp_2127()), "Lives", entry.comp_2128() - 1);
                }
            }
        }
    }

    @Override
    public class_124 getColorForLives(Integer lives) {
        if (lives == null) {
            return class_124.field_1080;
        }
        if (lives > YELLOW_TIME) {
            return class_124.field_1060;
        }
        if (lives > RED_TIME) {
            return class_124.field_1054;
        }
        if (lives > 0) {
            return class_124.field_1061;
        }
        return class_124.field_1063;
    }

    @Override
    public class_2561 getFormattedLives(Integer lives) {
        if (lives == null) {
            return class_2561.method_43473();
        }
        class_124 color = this.getColorForLives(lives);
        return class_2561.method_43470((String)OtherUtils.formatTime(lives * 20)).method_27692(color);
    }

    @Override
    public void reloadPlayerTeamActual(class_3222 player) {
        Integer lives = this.getPlayerLives(player);
        if (lives == null) {
            TeamUtils.addEntityToTeam("lives_null", (class_1297)player);
        } else if (lives <= 0) {
            TeamUtils.addEntityToTeam("lives_0", (class_1297)player);
        } else if (lives > YELLOW_TIME) {
            TeamUtils.addEntityToTeam("lives_3", (class_1297)player);
        } else if (lives > RED_TIME) {
            TeamUtils.addEntityToTeam("lives_2", (class_1297)player);
        } else if (lives > 0) {
            TeamUtils.addEntityToTeam("lives_1", (class_1297)player);
        }
    }

    @Override
    public void setPlayerLives(class_3222 player, int lives) {
        class_124 colorNow;
        Integer livesBefore = this.getPlayerLives(player);
        class_124 colorBefore = null;
        if (player.method_5781() != null) {
            colorBefore = player.method_5781().method_1202();
        }
        ScoreboardUtils.setScore(class_9015.method_55422((String)player.method_5820()), "Lives", lives);
        if (lives <= 0) {
            this.playerLostAllLives(player, livesBefore);
        }
        if (colorBefore != (colorNow = this.getColorForLives(lives))) {
            if (player.method_7325() && lives > 0) {
                player.method_7336(class_1934.field_9215);
            }
            if (lives > 0 && colorBefore != null && livesBefore != null && BROADCAST_COLOR_CHANGES) {
                class_5250 livesText = class_2561.method_43470((String)(colorNow.method_537().replaceAll("_", " ").toLowerCase() + " name")).method_27692(colorNow);
                PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 is now a {}\u00a77.", player, livesText));
            }
            this.reloadPlayerTeam(player);
        }
    }

    @Override
    public Boolean isOnLastLife(class_3222 player) {
        if (!this.isAlive(player)) {
            return null;
        }
        Integer lives = Main.currentSeason.getPlayerLives(player);
        if (lives == null) {
            return null;
        }
        return lives < RED_TIME;
    }

    @Override
    public Boolean isOnSpecificLives(class_3222 player, int check) {
        if (!this.isAlive(player)) {
            return null;
        }
        Integer lives = Main.currentSeason.getPlayerLives(player);
        if (lives == null) {
            return null;
        }
        if (check == 1) {
            return 0 < lives && lives < RED_TIME;
        }
        if (check == 2) {
            return RED_TIME <= lives && lives < YELLOW_TIME;
        }
        if (check == 3) {
            return lives >= YELLOW_TIME;
        }
        return null;
    }

    @Override
    public void onPlayerDeath(class_3222 player, class_1282 source) {
        class_1297 class_12972;
        if (source != null && (class_12972 = source.method_5529()) instanceof class_3222) {
            class_3222 serverAttacker = (class_3222)class_12972;
            if (player != source.method_5529()) {
                this.onPlayerKilledByPlayer(player, serverAttacker);
                return;
            }
        }
        if (player.method_6124() != null && (class_12972 = player.method_6124()) instanceof class_3222) {
            class_3222 serverAdversary = (class_3222)class_12972;
            if (player != player.method_6124()) {
                this.onPlayerKilledByPlayer(player, serverAdversary);
                return;
            }
        }
        this.onPlayerDiedNaturally(player);
        this.addToPlayerLives(player, this.DEATH_NORMAL);
        if (this.isAlive(player)) {
            PlayerUtils.sendTitle(player, (class_2561)class_2561.method_43470((String)OtherUtils.formatSecondsToReadable(this.DEATH_NORMAL)).method_27692(class_124.field_1061), 20, 80, 20);
        }
    }

    @Override
    public void onClaimKill(class_3222 killer, class_3222 victim) {
        SessionTranscript.claimKill(killer, victim);
        Boogeyman boogeyman = this.boogeymanManagerNew.getBoogeyman(killer);
        if (boogeyman == null || boogeyman.cured || this.isOnLastLife(victim, true)) {
            this.addToPlayerLives(killer, this.KILL_NORMAL);
            PlayerUtils.sendTitle(killer, (class_2561)class_2561.method_43470((String)OtherUtils.formatSecondsToReadable(this.KILL_NORMAL)).method_27692(class_124.field_1060), 20, 80, 20);
            return;
        }
        this.boogeymanManagerNew.cure(killer);
        boolean wasAlive = false;
        String msgVictim = OtherUtils.formatSecondsToReadable(this.DEATH_BOOGEYMAN - this.DEATH_NORMAL);
        String msgKiller = OtherUtils.formatSecondsToReadable(this.KILL_BOOGEYMAN);
        if (this.isAlive(victim)) {
            this.addToPlayerLives(victim, this.DEATH_BOOGEYMAN - this.DEATH_NORMAL);
            wasAlive = true;
        }
        this.addToPlayerLives(killer, this.KILL_BOOGEYMAN);
        if (this.isAlive(victim)) {
            PlayerUtils.sendTitle(killer, (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), 20, 80, 20);
            PlayerUtils.sendTitle(victim, (class_2561)class_2561.method_43470((String)msgVictim).method_27692(class_124.field_1061), 20, 80, 20);
        } else if (wasAlive && this.SHOW_DEATH_TITLE) {
            PlayerUtils.sendTitleWithSubtitle(killer, (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), (class_2561)class_2561.method_43473().method_10852(victim.method_55423()).method_10852((class_2561)class_2561.method_43470((String)" ran out of time!")), 20, 80, 20);
        } else {
            PlayerUtils.sendTitle(killer, (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), 20, 80, 20);
        }
    }

    @Override
    public void onPlayerKilledByPlayer(class_3222 victim, class_3222 killer) {
        Boogeyman boogeyman = this.boogeymanManagerNew.getBoogeyman(killer);
        if (boogeyman == null || boogeyman.cured || this.isOnLastLife(victim, true)) {
            boolean wasAllowedToAttack = this.isAllowedToAttack(killer, victim);
            String msgVictim = OtherUtils.formatSecondsToReadable(this.DEATH_NORMAL);
            String msgKiller = OtherUtils.formatSecondsToReadable(this.KILL_NORMAL);
            this.addToPlayerLives(victim, this.DEATH_NORMAL);
            this.addToPlayerLives(killer, this.KILL_NORMAL);
            if (this.isAlive(victim) || !this.SHOW_DEATH_TITLE) {
                PlayerUtils.sendTitle(victim, (class_2561)class_2561.method_43470((String)msgVictim).method_27692(class_124.field_1061), 20, 80, 20);
                PlayerUtils.sendTitle(killer, (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), 20, 80, 20);
            } else {
                PlayerUtils.sendTitleWithSubtitle(killer, (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), (class_2561)class_2561.method_43473().method_10852(victim.method_55423()).method_10852((class_2561)class_2561.method_43470((String)" ran out of time!")), 20, 80, 20);
            }
            if (wasAllowedToAttack) {
                return;
            }
            PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)("\u00a7c [Unjustified Kill?] \u00a7f" + victim.method_5820() + "\u00a77 was killed by \u00a7f" + killer.method_5820() + "\u00a77, who is not \u00a7cred name\u00a77 (nor a \u00a7eyellow name\u00a77, with the victim being a \u00a7agreen name\u00a77), and is not a \u00a7cboogeyman\u00a7f!")));
            PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"\u00a77Remember to remove or add time (using \u00a7f/limitedlife time add/remove <player> <time>\u00a77) if this was indeed an unjustified kill."));
            return;
        }
        this.boogeymanManagerNew.cure(killer);
        String msgVictim = OtherUtils.formatSecondsToReadable(this.DEATH_BOOGEYMAN);
        String msgKiller = OtherUtils.formatSecondsToReadable(this.KILL_BOOGEYMAN);
        this.addToPlayerLives(victim, this.DEATH_BOOGEYMAN);
        this.addToPlayerLives(killer, this.KILL_BOOGEYMAN);
        if (this.isAlive(victim) || !this.SHOW_DEATH_TITLE) {
            PlayerUtils.sendTitle(victim, (class_2561)class_2561.method_43470((String)msgVictim).method_27692(class_124.field_1061), 20, 80, 20);
            PlayerUtils.sendTitleWithSubtitle(killer, class_2561.method_30163((String)"\u00a7aYou are cured!"), (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), 20, 80, 20);
        } else {
            PlayerUtils.sendTitleWithSubtitle(killer, class_2561.method_30163((String)("\u00a7aYou are cured, " + msgKiller)), (class_2561)class_2561.method_43473().method_10852(victim.method_55423()).method_10852((class_2561)class_2561.method_43470((String)" ran out of time!")), 20, 80, 20);
        }
    }

    @Override
    public boolean isAllowedToAttack(class_3222 attacker, class_3222 victim) {
        if (this.isOnLastLife(attacker, false)) {
            return true;
        }
        if (attacker.method_6124() == victim && this.isOnLastLife(victim, false)) {
            return true;
        }
        if (this.isOnSpecificLives(attacker, 2, false) && this.isOnSpecificLives(victim, 3, false)) {
            return true;
        }
        if (attacker.method_6124() == victim && this.isOnSpecificLives(victim, 2, false) && this.isOnSpecificLives(attacker, 3, false)) {
            return true;
        }
        Boogeyman boogeymanAttacker = this.boogeymanManagerNew.getBoogeyman(attacker);
        Boogeyman boogeymanVictim = this.boogeymanManagerNew.getBoogeyman(victim);
        if (boogeymanAttacker != null && !boogeymanAttacker.cured) {
            return true;
        }
        return attacker.method_6124() == victim && boogeymanVictim != null && !boogeymanVictim.cured;
    }

    @Override
    public void onPlayerJoin(class_3222 player) {
        super.onPlayerJoin(player);
        if (!this.hasAssignedLives(player)) {
            this.setPlayerLives(player, DEFAULT_TIME);
        }
    }

    @Override
    public void onPlayerFinishJoining(class_3222 player) {
        if (PermissionManager.isAdmin(player)) {
            player.method_43496(class_2561.method_30163((String)"\u00a77Limited Life commands: \u00a7r/lifeseries, /session, /claimkill, /lives, /boogeyman"));
        } else {
            player.method_43496(class_2561.method_30163((String)"\u00a77Limited Life non-admin commands: \u00a7r/claimkill, /lives"));
        }
        super.onPlayerFinishJoining(player);
    }

    @Override
    public void reload() {
        super.reload();
        ConfigManager configManager = Main.seasonConfig;
        if (!(configManager instanceof LimitedLifeConfig)) {
            return;
        }
        LimitedLifeConfig config = (LimitedLifeConfig)configManager;
        DEFAULT_TIME = LimitedLifeConfig.TIME_DEFAULT.get(config);
        YELLOW_TIME = LimitedLifeConfig.TIME_YELLOW.get(config);
        RED_TIME = LimitedLifeConfig.TIME_RED.get(config);
        this.DEATH_NORMAL = LimitedLifeConfig.TIME_DEATH.get(config);
        this.DEATH_BOOGEYMAN = LimitedLifeConfig.TIME_DEATH_BOOGEYMAN.get(config);
        this.KILL_NORMAL = LimitedLifeConfig.TIME_KILL.get(config);
        this.KILL_BOOGEYMAN = LimitedLifeConfig.TIME_KILL_BOOGEYMAN.get(config);
        TICK_OFFLINE_PLAYERS = LimitedLifeConfig.TICK_OFFLINE_PLAYERS.get(config);
        BROADCAST_COLOR_CHANGES = LimitedLifeConfig.BROADCAST_COLOR_CHANGES.get(config);
    }
}

