/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.boogeyman.advanceddeaths;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.boogeyman.advanceddeaths.AdvancedDeath;
import net.mat0u5.lifeseries.seasons.boogeyman.advanceddeaths.AdvancedDeaths;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class AdvancedDeathsManager {
    private static int lastDeathIndex = new Random().nextInt(1000);
    private static final Map<UUID, PlayerAdvancedDeath> queuedDeaths = new HashMap<UUID, PlayerAdvancedDeath>();

    public static void tick() {
        if (queuedDeaths.isEmpty()) {
            return;
        }
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, PlayerAdvancedDeath> entry : queuedDeaths.entrySet()) {
            UUID uuid = entry.getKey();
            PlayerAdvancedDeath playerAdvancedDeath = entry.getValue();
            class_3222 player = PlayerUtils.getPlayer(uuid);
            if (player == null || playerAdvancedDeath.queuedDeaths().isEmpty() || Objects.equals(Main.livesManager.getPlayerLives(player), playerAdvancedDeath.lives())) {
                toRemove.add(uuid);
                continue;
            }
            if (playerAdvancedDeath.queuedDeaths().getFirst().isFinished() || playerAdvancedDeath.queuedDeaths().getFirst().started && playerAdvancedDeath.queuedDeaths().getFirst().playerNotFound()) {
                playerAdvancedDeath.queuedDeaths().removeFirst();
                if (playerAdvancedDeath.queuedDeaths().isEmpty()) {
                    toRemove.add(uuid);
                    continue;
                }
            }
            playerAdvancedDeath.queuedDeaths().getFirst().onTick();
        }
        for (UUID uuid : toRemove) {
            PlayerAdvancedDeath playerAdvancedDeath = queuedDeaths.get(uuid);
            Main.livesManager.setScore(playerAdvancedDeath.nameForScoreboard(), playerAdvancedDeath.lives());
            playerAdvancedDeath.queuedDeaths().forEach(AdvancedDeath::onEnd);
            queuedDeaths.remove(uuid);
        }
    }

    public static void setPlayerLives(class_3222 player, int lives) {
        Integer currentLives = Main.livesManager.getPlayerLives(player);
        if (currentLives == null || currentLives <= lives) {
            Main.livesManager.setPlayerLives(player, lives);
            return;
        }
        ArrayList<AdvancedDeath> queuedPlayerDeaths = new ArrayList<AdvancedDeath>();
        for (int i = currentLives.intValue(); i > lives; --i) {
            AdvancedDeath death = AdvancedDeathsManager.getPseudoRandomDeath(player);
            if (death == null) continue;
            queuedPlayerDeaths.add(death);
        }
        if (queuedPlayerDeaths.isEmpty()) {
            Main.livesManager.setPlayerLives(player, lives);
            return;
        }
        queuedDeaths.put(player.method_5667(), new PlayerAdvancedDeath(player.method_5820(), lives, queuedPlayerDeaths));
    }

    public static void onPlayerDeath(class_3222 player) {
        if (queuedDeaths.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, PlayerAdvancedDeath> entry : queuedDeaths.entrySet()) {
            UUID uuid = entry.getKey();
            if (uuid != player.method_5667()) continue;
            PlayerAdvancedDeath playerAdvancedDeath = entry.getValue();
            playerAdvancedDeath.queuedDeaths().getFirst().onEnd();
            playerAdvancedDeath.queuedDeaths().removeFirst();
        }
    }

    @Nullable
    private static AdvancedDeath getPseudoRandomDeath(class_3222 player) {
        List<AdvancedDeaths> advancedDeaths = AdvancedDeaths.getAllDeaths();
        lastDeathIndex = (lastDeathIndex + 1) % advancedDeaths.size();
        return advancedDeaths.get(lastDeathIndex).getInstance(player);
    }

    public record PlayerAdvancedDeath(String nameForScoreboard, int lives, List<AdvancedDeath> queuedDeaths) {
    }
}

