/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.limitedlife;

import java.util.ArrayList;
import java.util.List;
import net.mat0u5.lifeseries.config.ConfigFileEntry;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.other.TextUtils;

public class LimitedLifeConfig
extends ConfigManager {
    public static final List<String> BLACKLISTED_ITEMS = List.of("lectern", "bookshelf", "mace", "leather_helmet", "chainmail_helmet", "golden_helmet", "iron_helmet", "diamond_helmet", "netherite_helmet", "turtle_helmet", "elytra");
    public static final List<String> BLACKLISTED_BLOCKS = List.of("lectern", "bookshelf");
    public static final List<String> CLAMPED_ENCHANTMENTS = List.of("sharpness", "smite", "bane_of_arthropods", "fire_aspect", "knockback", "sweeping_edge", "power", "punch", "protection", "projectile_protection", "blast_protection", "fire_protection", "feather_falling", "thorns", "breach", "density", "wind_burst", "multishot", "piercing", "quick_charge");
    public static final ConfigFileEntry<Integer> TIME_DEFAULT = new ConfigFileEntry<Integer>("time_default", 86400, ConfigTypes.SECONDS, "season.time", "Time Default", "The time with which players start, in seconds.");
    public static final ConfigFileEntry<Integer> TIME_YELLOW = new ConfigFileEntry<Integer>("time_yellow", 57600, ConfigTypes.SECONDS, "season.time", "Time Yellow", "The Green-Yellow time border, in seconds.");
    public static final ConfigFileEntry<Integer> TIME_RED = new ConfigFileEntry<Integer>("time_red", 28800, ConfigTypes.SECONDS, "season.time", "Time Red", "The Yellow-Red time border, in seconds.");
    public static final ConfigFileEntry<Integer> TIME_DEATH = new ConfigFileEntry<Integer>("time_death", -3600, ConfigTypes.SECONDS, "season.time", "Time Death", "Time time you lose for dying, in seconds.");
    public static final ConfigFileEntry<Integer> TIME_DEATH_BOOGEYMAN = new ConfigFileEntry<Integer>("time_death_boogeyman", -7200, ConfigTypes.SECONDS, "season.time", "Time Death Boogeyman", "The time you lose for the Boogeyman killing you, in seconds.");
    public static final ConfigFileEntry<Integer> TIME_KILL = new ConfigFileEntry<Integer>("time_kill", 1800, ConfigTypes.SECONDS, "season.time", "Time Kill", "The time you gain for killing someone, in seconds.");
    public static final ConfigFileEntry<Integer> TIME_KILL_BOOGEYMAN = new ConfigFileEntry<Integer>("time_kill_boogeyman", 3600, ConfigTypes.SECONDS, "season.time", "Time Kill Boogeyman", "The time you gain for killing someone while you are the boogeyman, in seconds.");
    public static final ConfigFileEntry<Boolean> TICK_OFFLINE_PLAYERS = new ConfigFileEntry<Boolean>("tick_offline_players", false, "season", "Tick Offline Players", "Controls whether even players that are offline lose time when the session is on.");
    public static final ConfigFileEntry<Boolean> BROADCAST_COLOR_CHANGES = new ConfigFileEntry<Boolean>("broadcast_color_changes", false, "season", "Broadcast Color Changes", "Sends a message in chat to all players when someone changes color.");
    public static final ConfigFileEntry<Object> GROUP_TIME = new ConfigFileEntry<Object>("group_time", null, ConfigTypes.TEXT, "{season.time}", "Time Rewards / Punishments", "");

    public LimitedLifeConfig() {
        super("./config/lifeseries", "limitedlife.properties");
    }

    @Override
    protected List<ConfigFileEntry<?>> getDefaultConfigEntries() {
        List<ConfigFileEntry<?>> defaultEntries = super.getDefaultConfigEntries();
        defaultEntries.remove(this.DEFAULT_LIVES);
        defaultEntries.remove(this.GIVELIFE_COMMAND_ENABLED);
        defaultEntries.remove(this.GIVELIFE_LIVES_MAX);
        defaultEntries.remove(this.GIVELIFE_BROADCAST);
        defaultEntries.remove(this.GIVELIFE_CAN_REVIVE);
        defaultEntries.remove(this.TAB_LIST_SHOW_EXACT_LIVES);
        return defaultEntries;
    }

    @Override
    protected List<ConfigFileEntry<?>> getSeasonSpecificConfigEntries() {
        return new ArrayList(List.of(TICK_OFFLINE_PLAYERS, BROADCAST_COLOR_CHANGES, GROUP_TIME, TIME_DEFAULT, TIME_YELLOW, TIME_RED, TIME_DEATH, TIME_DEATH_BOOGEYMAN, TIME_KILL, TIME_KILL_BOOGEYMAN));
    }

    @Override
    public void instantiateProperties() {
        this.CUSTOM_ENCHANTER_ALGORITHM.defaultValue = true;
        this.BLACKLIST_ITEMS.defaultValue = TextUtils.formatString("[{}]", BLACKLISTED_ITEMS);
        this.BLACKLIST_BLOCKS.defaultValue = TextUtils.formatString("[{}]", BLACKLISTED_BLOCKS);
        this.BLACKLIST_CLAMPED_ENCHANTS.defaultValue = TextUtils.formatString("[{}]", CLAMPED_ENCHANTMENTS);
        this.FINAL_DEATH_TITLE_SUBTITLE.defaultValue = "ran out of time!";
        this.FINAL_DEATH_MESSAGE.defaultValue = "${player} ran out of time.";
        this.BOOGEYMAN.defaultValue = true;
        this.BOOGEYMAN_MAX_AMOUNT.defaultValue = 1;
        this.BOOGEYMAN_MESSAGE.defaultValue = "\u00a77You are the Boogeyman. You must by any means necessary kill a \u00a72dark green\u00a77, \u00a7agreen\u00a77 or \u00a7eyellow\u00a77 name by direct action to be cured of the curse. If you fail, your time will be dropped to the next color. All loyalties and friendships are removed while you are the Boogeyman.";
        super.instantiateProperties();
    }
}

