/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.secretsociety;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.secretsociety.SecretSociety;
import net.mat0u5.lifeseries.seasons.secretsociety.SocietyMember;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class SocietyCommands {
    public static SecretSociety get() {
        return Main.currentSeason.secretSociety;
    }

    public static boolean isAllowed() {
        return SocietyCommands.get().SOCIETY_ENABLED;
    }

    public static boolean checkBanned(class_2168 source) {
        if (SocietyCommands.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is only available when the Secret Society has been enabled in the Life Series config."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"initiate").requires(source -> SocietyCommands.isAllowed())).executes(context -> SocietyCommands.initiate((class_2168)context.getSource())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"society").requires(source -> SocietyCommands.isAllowed())).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"success").executes(context -> SocietyCommands.societySuccess((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"confirm").requires(PermissionManager::isAdmin)).executes(context -> SocietyCommands.societySuccessConfirm((class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"fail").executes(context -> SocietyCommands.societyFail((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"confirm").requires(PermissionManager::isAdmin)).executes(context -> SocietyCommands.societyFailConfirm((class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"begin").requires(PermissionManager::isAdmin)).then(class_2170.method_9244((String)"secret_word", (ArgumentType)StringArgumentType.string()).executes(context -> SocietyCommands.societyBegin((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"secret_word"))))).executes(context -> SocietyCommands.societyBegin((class_2168)context.getSource(), null)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"end").requires(PermissionManager::isAdmin)).executes(context -> SocietyCommands.societyEnd((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"members").requires(PermissionManager::isAdmin)).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> SocietyCommands.membersAdd((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> SocietyCommands.membersRemove((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"list").executes(context -> SocietyCommands.membersList((class_2168)context.getSource())))));
    }

    public static int membersRemove(class_2168 source, class_3222 target) {
        if (SocietyCommands.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = SocietyCommands.get();
        if (society == null) {
            return -1;
        }
        if (SocietyCommands.checkSocietyRunning(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        if (!society.isMember(target)) {
            source.method_9213(class_2561.method_30163((String)"That player is not a Member"));
            return -1;
        }
        society.removeMemberManually(target);
        return 1;
    }

    public static int membersAdd(class_2168 source, class_3222 target) {
        if (SocietyCommands.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = SocietyCommands.get();
        if (society == null) {
            return -1;
        }
        if (SocietyCommands.checkSocietyRunning(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        if (society.isMember(target)) {
            source.method_9213(class_2561.method_30163((String)"That player already a Member"));
            return -1;
        }
        society.addMemberManually(target);
        return 1;
    }

    public static int membersList(class_2168 source) {
        if (SocietyCommands.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = SocietyCommands.get();
        if (society == null) {
            return -1;
        }
        if (SocietyCommands.checkSocietyRunning(source)) {
            return -1;
        }
        if (society.members.isEmpty()) {
            source.method_9213(class_2561.method_30163((String)"The are no Secret Society members"));
            return -1;
        }
        ArrayList<String> societyMembers = new ArrayList<String>();
        for (SocietyMember member : society.members) {
            class_3222 player = member.getPlayer();
            if (player == null) continue;
            societyMembers.add(player.method_5820());
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.formatLoosely("Secret Society Members: \u00a77{}", societyMembers));
        return 1;
    }

    public static boolean checkSocietyRunning(class_2168 source) {
        SecretSociety society = SocietyCommands.get();
        if (society == null) {
            return false;
        }
        if (society.societyEnded) {
            source.method_9213(class_2561.method_30163((String)"The Secret Society has already ended"));
            if (PermissionManager.isAdmin(source)) {
                OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77Use '/society begin' or '/society begin <secret_word>' to start."));
            }
            return true;
        }
        if (!society.societyStarted) {
            source.method_9213(class_2561.method_30163((String)"The Secret Society has not started yet"));
            if (PermissionManager.isAdmin(source)) {
                OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77Use '/society begin' or '/society begin <secret_word>' to start."));
            }
            return true;
        }
        return false;
    }

    public static int societyBegin(class_2168 source, String word) {
        if (SocietyCommands.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = SocietyCommands.get();
        if (society == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Starting the Secret Society..."));
        society.startSociety(word);
        return 1;
    }

    public static int societyEnd(class_2168 source) {
        if (SocietyCommands.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = SocietyCommands.get();
        if (society == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Ending the Secret Society..."));
        society.forceEndSociety();
        return 1;
    }

    public static int societyFail(class_2168 source) {
        if (SocietyCommands.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = SocietyCommands.get();
        if (society == null) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (SocietyCommands.checkSocietyRunning(source)) {
            return -1;
        }
        SocietyMember member = society.getMember(self);
        if (member == null) {
            source.method_9213(class_2561.method_30163((String)"You are not a member of the Secret Society"));
            if (PermissionManager.isAdmin(self)) {
                OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Use the \u00a7f\"/society fail \u00a7lconfirm\"\u00a7l\u00a77 command to bypass this"));
            }
            return -1;
        }
        if (!member.initiated) {
            source.method_9213(class_2561.method_30163((String)"You have not been initiated"));
            return -1;
        }
        society.endFail();
        SessionTranscript.societyEndFail(self);
        return 1;
    }

    public static int societyFailConfirm(class_2168 source) {
        if (SocietyCommands.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = SocietyCommands.get();
        if (society == null) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (SocietyCommands.checkSocietyRunning(source)) {
            return -1;
        }
        society.endFail();
        SessionTranscript.societyEndFail(self);
        return 1;
    }

    public static int societySuccess(class_2168 source) {
        if (SocietyCommands.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = SocietyCommands.get();
        if (society == null) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (SocietyCommands.checkSocietyRunning(source)) {
            return -1;
        }
        SocietyMember member = society.getMember(self);
        if (member == null) {
            source.method_9213(class_2561.method_30163((String)"You are not a member of the Secret Society"));
            if (PermissionManager.isAdmin(self)) {
                OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Use the \u00a7f\"/society success \u00a7lconfirm\"\u00a7l\u00a77 command to bypass this"));
            }
            return -1;
        }
        if (!member.initiated) {
            source.method_9213(class_2561.method_30163((String)"You have not been initiated"));
            return -1;
        }
        society.endSuccess();
        SessionTranscript.societyEndSuccess(self);
        return 1;
    }

    public static int societySuccessConfirm(class_2168 source) {
        if (SocietyCommands.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = SocietyCommands.get();
        if (society == null) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (SocietyCommands.checkSocietyRunning(source)) {
            return -1;
        }
        society.endSuccess();
        SessionTranscript.societyEndSuccess(self);
        return 1;
    }

    public static int initiate(class_2168 source) {
        if (SocietyCommands.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = SocietyCommands.get();
        if (society == null) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (SocietyCommands.checkSocietyRunning(source)) {
            return -1;
        }
        SocietyMember member = society.getMember(self);
        if (member == null) {
            source.method_9213(class_2561.method_30163((String)"You are not a member of the Secret Society"));
            return -1;
        }
        if (member.initiated) {
            source.method_9213(class_2561.method_30163((String)"You have already been initiated"));
            return -1;
        }
        society.initiateMember(self);
        return 1;
    }
}

