/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.network.packets.SnailTexturePacket;
import net.mat0u5.lifeseries.resources.ResourceHandler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.versions.VersionControl;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class SnailSkins {
    public static void sendTexturesTo(class_3222 player) {
        SnailSkins.sendTexturesTo(List.of(player));
    }

    public static void sendTexturesTo(List<class_3222> players) {
        for (File file : SnailSkins.getAllSkinFiles()) {
            try {
                String name = file.getName().toLowerCase(Locale.ROOT).replaceAll(".png", "");
                byte[] textureData = Files.readAllBytes(file.toPath());
                SnailTexturePacket packet = new SnailTexturePacket(name, textureData);
                for (class_3222 player : players) {
                    if (VersionControl.isDevVersion()) {
                        Main.LOGGER.info(TextUtils.formatString("Sending snail texture '{}' to {}", name, player));
                    }
                    ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void sendTextures() {
        SnailSkins.sendTexturesTo(PlayerUtils.getAllPlayers());
    }

    public static List<File> getAllSkinFiles() {
        ArrayList<File> result = new ArrayList<File>();
        try {
            File folder = new File("./config/lifeseries/wildlife/snailskins/");
            File[] files = folder.listFiles();
            if (files == null) {
                return result;
            }
            for (File file : files) {
                String name;
                if (!file.isFile() || (name = file.getName().toLowerCase(Locale.ROOT)).equalsIgnoreCase("example.png") || !name.endsWith(".png")) continue;
                result.add(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<String> getAllSkins() {
        ArrayList<String> result = new ArrayList<String>();
        for (File file : SnailSkins.getAllSkinFiles()) {
            String name = file.getName().toLowerCase(Locale.ROOT).replaceAll(".png", "");
            result.add(name);
        }
        return result;
    }

    public static void createConfig() {
        File folder = new File("./config/lifeseries/wildlife/snailskins/");
        if (!folder.exists() && !folder.mkdirs()) {
            Main.LOGGER.error("Failed to create folder {}", (Object)folder);
            return;
        }
        ResourceHandler handler = new ResourceHandler();
        Path modelResult = new File("./config/lifeseries/wildlife/snailskins/snail.bbmodel").toPath();
        handler.copyBundledSingleFile("/files/snails/snail-old.bbmodel", modelResult);
        Path textureResult = new File("./config/lifeseries/wildlife/snailskins/example.png").toPath();
        handler.copyBundledSingleFile("/files/snails/example.png", textureResult);
    }
}

