/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.world;

import java.awt.Color;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.ItemStackUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2663;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import org.joml.Vector3f;

public class AnimationUtils {
    private static int spiralDuration = 175;

    public static void playTotemAnimation(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_2663((class_1297)player, 35));
    }

    public static void playRealTotemAnimation(class_3222 player) {
        player.ls$getServerLevel().method_8421((class_1297)player, (byte)35);
    }

    public static void playSecretLifeTotemAnimation(class_3222 player, boolean red) {
        if (NetworkHandlerServer.wasHandshakeSuccessful(player)) {
            NetworkHandlerServer.sendStringPacket(player, PacketNames.SHOW_TOTEM, red ? "task_red" : "task");
            PlayerUtils.playSoundToPlayer(player, class_3414.method_47908((class_2960)IdentifierHelper.parse("secretlife_task_totem")));
            return;
        }
        class_1799 totemItem = AnimationUtils.getSecretLifeTotemItem(red);
        class_1799 mainhandItem = player.method_6047().method_7972();
        player.method_6122(class_1268.field_5808, totemItem);
        TaskScheduler.scheduleTask(1, () -> {
            player.field_13987.method_14364((class_2596)new class_2663((class_1297)player, 35));
            PlayerUtils.playSoundToPlayer(player, class_3414.method_47908((class_2960)IdentifierHelper.parse("secretlife_task_totem")));
        });
        TaskScheduler.scheduleTask(2, () -> player.method_6122(class_1268.field_5808, mainhandItem));
    }

    public static class_1799 getSecretLifeTotemItem(boolean red) {
        class_1799 totemItem = class_1802.field_8288.method_7854();
        ItemStackUtils.setCustomComponentBoolean(totemItem, "FakeTotem", true);
        totemItem.method_57379(class_9334.field_54199, (Object)IdentifierHelper.mod(red ? "task_red_totem" : "task_totem"));
        return totemItem;
    }

    public static void createSpiral(class_3222 player, int duration) {
        spiralDuration = duration;
        TaskScheduler.scheduleTask(1, () -> AnimationUtils.startSpiral(player));
    }

    private static void startSpiral(class_3222 player) {
        TaskScheduler.scheduleTask(1, () -> AnimationUtils.runSpiralStep(player, 0));
    }

    private static void runSpiralStep(class_3222 player, int step) {
        if (player == null) {
            return;
        }
        AnimationUtils.processSpiral(player, step);
        AnimationUtils.processSpiral(player, step + 1);
        AnimationUtils.processSpiral(player, step + 2);
        AnimationUtils.processSpiral(player, step + 3);
        if (step <= spiralDuration) {
            TaskScheduler.scheduleTask(1, () -> AnimationUtils.runSpiralStep(player, step + 4));
        }
    }

    private static void processSpiral(class_3222 player, int step) {
        class_3218 level = player.ls$getServerLevel();
        double x = player.method_23317();
        double z = player.method_23321();
        double yStart = player.method_23318();
        double height = 1.0;
        double radius = 0.8;
        int pointsPerCircle = 40;
        double angle = Math.PI * 2 * (double)(step % pointsPerCircle) / (double)pointsPerCircle + (double)step / 4.0;
        double y = yStart + height * Math.sin(Math.PI * (double)(step - 20) / 20.0) + 1.0;
        double offsetX = radius * Math.cos((float)angle);
        double offsetZ = radius * Math.sin((float)angle);
        level.method_65096((class_2394)class_2398.field_11211, x + offsetX, y, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static void createGlyphAnimation(class_3218 level, class_243 target, int duration) {
        if (level == null || target == null || duration <= 0) {
            return;
        }
        double radius = 7.5;
        for (int step = 0; step < duration; ++step) {
            TaskScheduler.scheduleTask(step, () -> AnimationUtils.spawnGlyphParticles(level, target, radius));
        }
    }

    private static void spawnGlyphParticles(class_3218 level, class_243 target, double radius) {
        int particlesPerTick = 50;
        class_5819 random = level.method_8409();
        for (int i = 0; i < particlesPerTick; ++i) {
            double angle = random.method_43058() * 2.0 * Math.PI;
            double distance = radius * (random.method_43058() * 0.5);
            double startX = target.method_10216() + distance * Math.cos(angle);
            double startY = target.method_10214() + random.method_43058() * 2.0 + 1.0;
            double startZ = target.method_10215() + distance * Math.sin(angle);
            double targetX = target.method_10216();
            double targetY = target.method_10214();
            double targetZ = target.method_10215();
            double dx = targetX - startX;
            double dy = targetY - startY;
            double dz = targetZ - startZ;
            double velocityScale = -50.0;
            double vx = dx * velocityScale;
            double vy = dy * velocityScale;
            double vz = dz * velocityScale;
            level.method_65096((class_2394)class_2398.field_11215, startX, startY, startZ, 0, vx, vy, vz, 0.2);
        }
    }

    public static void spawnFireworkBall(class_3218 level, class_243 position, int duration, double radius, Vector3f color) {
        if (level == null || position == null || duration <= 0 || radius <= 0.0) {
            return;
        }
        class_5819 random = level.method_8409();
        for (int step = 0; step < duration; ++step) {
            TaskScheduler.scheduleTask(step, () -> {
                for (int i = 0; i < 50; ++i) {
                    double theta = random.method_43058() * 2.0 * Math.PI;
                    double phi = random.method_43058() * Math.PI;
                    double r = radius * (0.8 + 0.2 * random.method_43058());
                    double x = r * Math.sin(phi) * Math.cos(theta);
                    double y = r * Math.sin(phi) * Math.sin(theta);
                    double z = r * Math.cos(phi);
                    class_2390 particleEffect = new class_2390(new Color(color.x, color.y, color.z).getRGB(), 1.0f);
                    level.method_65096((class_2394)particleEffect, position.method_10216() + x, position.method_10214() + y, position.method_10215() + z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            });
        }
    }

    public static void spawnTeleportParticles(class_3218 level, class_243 pos) {
        level.method_65096((class_2394)class_2398.field_11214, pos.field_1352, pos.field_1351, pos.field_1350, 30, 0.0, 0.0, 0.0, 0.35);
    }
}

