/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.features;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class SnailSkinsClient {
    private static final Map<String, class_2960> snailTextures = new HashMap<String, class_2960>();

    public static void handleSnailTexture(String skinName, byte[] textureData) {
        try {
            Main.LOGGER.info(TextUtils.formatString("Received snail texture '{}'", skinName));
            class_310 client = class_310.method_1551();
            class_2960 textureId = class_2960.method_60655((String)"lifeseries", (String)("dynamic/snailskin/" + skinName));
            class_1011 image = class_1011.method_4309((InputStream)new ByteArrayInputStream(textureData));
            if (image.method_4307() == 32 && image.method_4323() == 32) {
                Main.LOGGER.info("Converting old 32x32 snail texture to the new format.");
                SnailSkinsClient.saveImageDebug(image, "before");
                image = SnailSkinsClient.convertOldSnailTexture(image);
                SnailSkinsClient.saveImageDebug(image, "after");
            }
            if (image.method_4307() != 128 || image.method_4323() != 128) {
                Main.LOGGER.info("Snail texture has wrong dimensions, ignoring.");
                return;
            }
            class_1043 texture = new class_1043(() -> skinName, image);
            SnailSkinsClient.removeSnailTexture(skinName);
            client.method_1531().method_4616(textureId, (class_1044)texture);
            Main.LOGGER.info(TextUtils.formatString("Added snail texture '{}'", textureId));
            snailTextures.put(skinName, textureId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class_2960 getSnailTexture(String skinName) {
        if (skinName == null) {
            return null;
        }
        return snailTextures.get(skinName);
    }

    public static void removeSnailTexture(String skinName) {
        class_2960 textureId = snailTextures.remove(skinName);
        if (textureId != null) {
            class_310.method_1551().method_1531().method_4615(textureId);
            Main.LOGGER.info(TextUtils.formatString("Removed old snail texture '{}'", textureId));
        }
    }

    public static class_1011 convertOldSnailTexture(class_1011 original) {
        class_1011 remapped = new class_1011(128, 128, true);
        SnailSkinsClient.scaleRegion(original, remapped, 24, 18, 4, 4, 16, 0, 4);
        SnailSkinsClient.scaleRegion(original, remapped, 24, 18, 4, 4, 32, 0, 4);
        SnailSkinsClient.scaleRegionXY(original, remapped, 28, 18, 4, 1, 16, 16, 4, 1);
        SnailSkinsClient.scaleRegionXY(original, remapped, 28, 19, 4, 1, 0, 16, 4, 1);
        SnailSkinsClient.scaleRegionXY(original, remapped, 28, 20, 4, 1, 48, 16, 4, 1);
        SnailSkinsClient.scaleRegionXY(original, remapped, 28, 21, 4, 1, 32, 16, 4, 1);
        SnailSkinsClient.copyRegion(original, remapped, 26, 1, 1, 4, 60, 37);
        SnailSkinsClient.copyRegion(original, remapped, 26, 1, 1, 4, 58, 38);
        SnailSkinsClient.copyRegion(original, remapped, 26, 1, 1, 4, 58, 42);
        SnailSkinsClient.copyRegion(original, remapped, 26, 1, 1, 4, 58, 47);
        SnailSkinsClient.copyRegion(original, remapped, 26, 1, 1, 4, 46, 58);
        SnailSkinsClient.copyRegion(original, remapped, 26, 1, 1, 4, 44, 58);
        SnailSkinsClient.copyRegion(original, remapped, 26, 1, 1, 4, 40, 59);
        SnailSkinsClient.copyRegion(original, remapped, 26, 1, 1, 4, 42, 59);
        SnailSkinsClient.scaleRegionXY(original, remapped, 29, 0, 1, 1, 34, 33, 34, 4);
        SnailSkinsClient.scaleRegionXY(original, remapped, 29, 0, 1, 1, 0, 50, 34, 1);
        SnailSkinsClient.scaleRegionXY(original, remapped, 29, 0, 1, 1, 0, 33, 34, 1);
        SnailSkinsClient.scaleRegionXY(original, remapped, 29, 0, 1, 1, 16, 17, 2, 34);
        SnailSkinsClient.copyRegion(original, remapped, 24, 18, 4, 4, 36, 53);
        SnailSkinsClient.copyRegion(original, remapped, 24, 18, 4, 4, 40, 53);
        SnailSkinsClient.copyRegion(original, remapped, 28, 18, 4, 1, 36, 57);
        SnailSkinsClient.copyRegion(original, remapped, 28, 19, 4, 1, 32, 57);
        SnailSkinsClient.copyRegion(original, remapped, 28, 20, 4, 1, 44, 57);
        SnailSkinsClient.copyRegion(original, remapped, 28, 21, 4, 1, 40, 57);
        SnailSkinsClient.scaleRegionXY(original, remapped, 25, 5, 1, 1, 37, 58, 2, 1);
        SnailSkinsClient.scaleRegionXY(original, remapped, 25, 5, 1, 1, 36, 59, 4, 2);
        SnailSkinsClient.copyRegion(original, remapped, 26, 6, 6, 6, 40, 47);
        SnailSkinsClient.copyRegion(original, remapped, 0, 0, 8, 8, 42, 25);
        SnailSkinsClient.copyRegion(original, remapped, 8, 0, 8, 8, 58, 25);
        SnailSkinsClient.copyRegion(original, remapped, 16, 0, 8, 8, 50, 17);
        SnailSkinsClient.copyRegion(original, remapped, 0, 8, 8, 8, 34, 25);
        SnailSkinsClient.flipRegionHorizontal(remapped, 34, 25, 8, 8);
        SnailSkinsClient.copyRegion(original, remapped, 8, 8, 8, 8, 50, 25);
        SnailSkinsClient.copyRegion(original, remapped, 0, 16, 8, 8, 42, 17);
        SnailSkinsClient.copyRegion(original, remapped, 24, 24, -4, -2, 2, 58);
        SnailSkinsClient.copyRegion(original, remapped, 16, 23, -4, 2, 6, 58);
        SnailSkinsClient.copyRegion(original, remapped, 22, 14, 4, 2, 2, 60);
        SnailSkinsClient.copyRegion(original, remapped, 24, 3, 2, 2, 6, 60);
        SnailSkinsClient.copyRegion(original, remapped, 22, 16, 4, 2, 8, 60);
        SnailSkinsClient.copyRegion(original, remapped, 24, 1, 2, 2, 0, 60);
        SnailSkinsClient.copyRegion(original, remapped, 12, 20, -4, -4, 20, 51);
        SnailSkinsClient.copyRegion(original, remapped, 20, 8, -4, 4, 24, 51);
        SnailSkinsClient.copyRegion(original, remapped, 26, 12, 4, 2, 16, 55);
        SnailSkinsClient.scaleRegionXY(original, remapped, 0, 24, 4, 1, 20, 55, 1, 2);
        SnailSkinsClient.copyRegion(original, remapped, 26, 12, 4, 2, 24, 55);
        SnailSkinsClient.scaleRegionXY(original, remapped, 24, 0, 4, 1, 28, 55, 1, 2);
        SnailSkinsClient.copyRegion(original, remapped, 12, 24, -4, -8, 42, 37);
        SnailSkinsClient.copyRegion(original, remapped, 20, 8, -4, 8, 46, 37);
        SnailSkinsClient.copyRegion(original, remapped, 22, 12, 8, 2, 34, 45);
        SnailSkinsClient.scaleRegionXY(original, remapped, 0, 24, 4, 1, 42, 45, 1, 2);
        SnailSkinsClient.copyRegion(original, remapped, 22, 12, 8, 2, 46, 45);
        SnailSkinsClient.scaleRegionXY(original, remapped, 24, 0, 4, 1, 54, 45, 1, 2);
        SnailSkinsClient.copyRegion(original, remapped, 26, 10, -4, -2, 18, 57);
        SnailSkinsClient.copyRegion(original, remapped, 26, 10, -4, 2, 22, 57);
        SnailSkinsClient.copyRegion(original, remapped, 16, 23, 2, 2, 16, 59);
        SnailSkinsClient.copyRegion(original, remapped, 12, 21, 4, 2, 18, 59);
        SnailSkinsClient.copyRegion(original, remapped, 18, 23, 2, 2, 22, 59);
        SnailSkinsClient.copyRegion(original, remapped, 16, 21, 4, 2, 24, 59);
        SnailSkinsClient.copyRegion(original, remapped, 24, 20, -4, -2, 50, 53);
        SnailSkinsClient.copyRegion(original, remapped, 24, 20, -4, 2, 54, 53);
        SnailSkinsClient.copyRegion(original, remapped, 20, 8, 2, 5, 48, 55);
        SnailSkinsClient.copyRegion(original, remapped, 12, 16, 4, 5, 50, 55);
        SnailSkinsClient.copyRegion(original, remapped, 20, 13, 2, 5, 54, 55);
        SnailSkinsClient.copyRegion(original, remapped, 16, 16, 4, 5, 56, 55);
        SnailSkinsClient.copyRegion(original, remapped, 8, 25, -1, -1, 13, 58);
        SnailSkinsClient.copyRegion(original, remapped, 9, 24, -1, 1, 14, 58);
        SnailSkinsClient.copyRegion(original, remapped, 5, 24, 1, 3, 12, 59);
        SnailSkinsClient.copyRegion(original, remapped, 4, 24, 1, 3, 13, 59);
        SnailSkinsClient.copyRegion(original, remapped, 6, 24, 1, 3, 14, 59);
        SnailSkinsClient.copyRegion(original, remapped, 24, 5, 1, 3, 15, 59);
        SnailSkinsClient.copyRegion(original, remapped, 8, 25, -1, -1, 29, 57);
        SnailSkinsClient.copyRegion(original, remapped, 9, 24, -1, 1, 30, 57);
        SnailSkinsClient.copyRegion(original, remapped, 5, 24, 1, 3, 28, 58);
        SnailSkinsClient.copyRegion(original, remapped, 4, 24, 1, 3, 29, 58);
        SnailSkinsClient.copyRegion(original, remapped, 6, 24, 1, 3, 30, 58);
        SnailSkinsClient.copyRegion(original, remapped, 24, 5, 1, 3, 31, 58);
        return remapped;
    }

    private static void copyRegion(class_1011 source, class_1011 dest, int srcX, int srcY, int width, int height, int destX, int destY) {
        if (width < 0) {
            srcX += width;
            width *= -1;
        }
        if (height < 0) {
            srcY += height;
            height *= -1;
        }
        for (int y = 0; y < Math.abs(height); ++y) {
            for (int x = 0; x < Math.abs(width); ++x) {
                int color = SnailSkinsClient.getColor(source, srcX + x, srcY + y);
                SnailSkinsClient.setColor(dest, destX + x, destY + y, color);
            }
        }
    }

    private static void scaleRegion(class_1011 source, class_1011 dest, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int scale) {
        for (int y = 0; y < srcHeight; ++y) {
            for (int x = 0; x < srcWidth; ++x) {
                int color = SnailSkinsClient.getColor(source, srcX + x, srcY + y);
                for (int sy = 0; sy < scale; ++sy) {
                    for (int sx = 0; sx < scale; ++sx) {
                        SnailSkinsClient.setColor(dest, destX + x * scale + sx, destY + y * scale + sy, color);
                    }
                }
            }
        }
    }

    private static void scaleRegionXY(class_1011 source, class_1011 dest, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int scaleX, int scaleY) {
        for (int y = 0; y < srcHeight; ++y) {
            for (int x = 0; x < srcWidth; ++x) {
                int color = SnailSkinsClient.getColor(source, srcX + x, srcY + y);
                for (int sy = 0; sy < scaleY; ++sy) {
                    for (int sx = 0; sx < scaleX; ++sx) {
                        SnailSkinsClient.setColor(dest, destX + x * scaleX + sx, destY + y * scaleY + sy, color);
                    }
                }
            }
        }
    }

    private static void flipRegionHorizontal(class_1011 image, int x, int y, int width, int height) {
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width / 2; ++col) {
                int leftColor = SnailSkinsClient.getColor(image, x + col, y + row);
                int rightColor = SnailSkinsClient.getColor(image, x + width - 1 - col, y + row);
                SnailSkinsClient.setColor(image, x + col, y + row, rightColor);
                SnailSkinsClient.setColor(image, x + width - 1 - col, y + row, leftColor);
            }
        }
    }

    private static int getColor(class_1011 image, int x, int y) {
        return image.method_61940(x, y);
    }

    private static void setColor(class_1011 image, int x, int y, int color) {
        image.method_61941(x, y, color);
    }

    private static void saveImageDebug(class_1011 image, String filename) {
        try {
            Path debugPath = Paths.get("debug_textures", new String[0]);
            Files.createDirectories(debugPath, new FileAttribute[0]);
            Path outputPath = debugPath.resolve(filename + ".png");
            image.method_4314(outputPath);
            System.out.println("Saved debug texture to: " + String.valueOf(outputPath.toAbsolutePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

