/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.network;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.DefaultConfigValues;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.network.packets.ConfigPayload;
import net.mat0u5.lifeseries.network.packets.HandshakePayload;
import net.mat0u5.lifeseries.network.packets.ImagePayload;
import net.mat0u5.lifeseries.network.packets.LongPayload;
import net.mat0u5.lifeseries.network.packets.NumberPayload;
import net.mat0u5.lifeseries.network.packets.PlayerDisguisePayload;
import net.mat0u5.lifeseries.network.packets.StringListPayload;
import net.mat0u5.lifeseries.network.packets.StringPayload;
import net.mat0u5.lifeseries.network.packets.TriviaQuestionPayload;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.WildLife;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.SizeShifting;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.TimeDilation;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.TripleJump;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.versions.VersionControl;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_8710;
import net.minecraft.class_9812;
import net.minecraft.server.MinecraftServer;

public class NetworkHandlerServer {
    public static final List<UUID> handshakeSuccessful = new ArrayList<UUID>();
    public static boolean updatedConfigThisTick = false;
    public static boolean configNeedsReload = false;

    public static void registerPackets() {
        PayloadTypeRegistry.playS2C().register(NumberPayload.ID, NumberPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(StringPayload.ID, StringPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(StringListPayload.ID, StringListPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(HandshakePayload.ID, HandshakePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(TriviaQuestionPayload.ID, TriviaQuestionPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(LongPayload.ID, LongPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PlayerDisguisePayload.ID, PlayerDisguisePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ImagePayload.ID, ImagePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ConfigPayload.ID, ConfigPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(NumberPayload.ID, NumberPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(StringPayload.ID, StringPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(StringListPayload.ID, StringListPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(HandshakePayload.ID, HandshakePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(TriviaQuestionPayload.ID, TriviaQuestionPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(LongPayload.ID, LongPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(PlayerDisguisePayload.ID, PlayerDisguisePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ImagePayload.ID, ImagePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ConfigPayload.ID, ConfigPayload.CODEC);
    }

    public static void registerServerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver(HandshakePayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = context.server();
            server.execute(() -> NetworkHandlerServer.handleHandshakeResponse(player, payload));
        });
        ServerPlayNetworking.registerGlobalReceiver(NumberPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = context.server();
            server.execute(() -> NetworkHandlerServer.handleNumberPacket(player, payload));
        });
        ServerPlayNetworking.registerGlobalReceiver(StringPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = context.server();
            server.execute(() -> NetworkHandlerServer.handleStringPacket(player, payload));
        });
        ServerPlayNetworking.registerGlobalReceiver(ConfigPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = context.server();
            server.execute(() -> NetworkHandlerServer.handleConfigPacket(player, payload));
        });
    }

    public static void handleConfigPacket(class_3222 player, ConfigPayload payload) {
        if (PermissionManager.isAdmin(player)) {
            ConfigTypes configType = ConfigTypes.getFromString(payload.configType());
            String id = payload.id();
            List<String> args = payload.args();
            if (VersionControl.isDevVersion()) {
                Main.LOGGER.info(TextUtils.formatString("[PACKET_SERVER] Received config update from {}: {{}, {}, {}}", new Object[]{player, configType, id, args}));
            }
            if (configType.parentString() && !args.isEmpty()) {
                Main.seasonConfig.setProperty(id, args.getFirst());
                updatedConfigThisTick = true;
            } else if (configType.parentBoolean() && !args.isEmpty()) {
                Main.seasonConfig.setProperty(id, String.valueOf(args.getFirst().equalsIgnoreCase("true")));
                updatedConfigThisTick = true;
            } else if (configType.parentDouble() && !args.isEmpty()) {
                try {
                    double value = Double.parseDouble(args.getFirst());
                    Main.seasonConfig.setProperty(id, String.valueOf(value));
                    updatedConfigThisTick = true;
                }
                catch (Exception value) {}
            } else if (configType.parentInteger() && !args.isEmpty()) {
                try {
                    int value = Integer.parseInt(args.getFirst());
                    Main.seasonConfig.setProperty(id, String.valueOf(value));
                    updatedConfigThisTick = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (updatedConfigThisTick && DefaultConfigValues.RELOAD_NEEDED.contains(id)) {
                configNeedsReload = true;
            }
        }
    }

    public static void onUpdatedConfig() {
        PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"\u00a77Config has been successfully updated."));
        if (configNeedsReload) {
            PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"Run \u00a77'/lifeseries reload'\u00a7r to apply all the changes."));
        }
        updatedConfigThisTick = false;
        configNeedsReload = false;
        Main.softestReloadStart();
    }

    public static void handleNumberPacket(class_3222 player, NumberPayload payload) {
        String nameStr = payload.name();
        PacketNames name = PacketNames.fromName(nameStr);
        double value = payload.number();
        int intValue = (int)value;
        if (name == PacketNames.TRIVIA_ANSWER) {
            if (VersionControl.isDevVersion()) {
                Main.LOGGER.info(TextUtils.formatString("[PACKET_SERVER] Received trivia answer (from {}): {}", player, intValue));
            }
            TriviaWildcard.handleAnswer(player, intValue);
        }
    }

    public static void handleStringPacket(class_3222 player, StringPayload payload) {
        Superpower power;
        String nameStr = payload.name();
        PacketNames name = PacketNames.fromName(nameStr);
        String value = payload.value();
        if (name == PacketNames.HOLDING_JUMP && Main.currentSeason.getSeason() == Seasons.WILD_LIFE && WildcardManager.isActiveWildcard(Wildcards.SIZE_SHIFTING)) {
            SizeShifting.onHoldingJump(player);
        }
        if (name == PacketNames.SUPERPOWER_KEY && Main.currentSeason.getSeason() == Seasons.WILD_LIFE) {
            SuperpowersWildcard.pressedSuperpowerKey(player);
        }
        if (name == PacketNames.TRANSCRIPT) {
            player.method_64398(SessionTranscript.getTranscriptMessage());
        }
        if (PermissionManager.isAdmin(player)) {
            Wildcards wildcard;
            if (name == PacketNames.SELECTED_WILDCARD && (wildcard = Wildcards.getFromString(value)) != null && wildcard != Wildcards.NULL) {
                WildcardManager.chosenWildcard(wildcard);
            }
            if (name == PacketNames.REQUEST_CONFIG) {
                Main.seasonConfig.sendConfigTo(player);
            }
        }
        if (name == PacketNames.SET_SEASON && (PermissionManager.isAdmin(player) || Main.currentSeason.getSeason() == Seasons.UNASSIGNED)) {
            Seasons newSeason = Seasons.getSeasonFromStringName(value);
            if (newSeason == Seasons.UNASSIGNED) {
                return;
            }
            if (Main.changeSeasonTo(newSeason.getId())) {
                PlayerUtils.broadcastMessage((class_2561)TextUtils.formatLoosely("\u00a7aSuccessfully changed the season to {}.", value));
            }
        }
        if (name == PacketNames.REQUEST_SNAIL_MODEL) {
            Snail snail;
            if (Snails.snails.containsKey(player.method_5667())) {
                snail = Snails.snails.get(player.method_5667());
                snail.updateModel(true);
            }
            if (TriviaWildcard.snails.containsKey(player.method_5667())) {
                snail = TriviaWildcard.snails.get(player.method_5667());
                snail.updateModel(true);
            }
        }
        if (name == PacketNames.TRIPLE_JUMP && Main.currentSeason.getSeason() == Seasons.WILD_LIFE && SuperpowersWildcard.hasActivatedPower(player, Superpowers.TRIPLE_JUMP) && (power = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof TripleJump) {
            TripleJump tripleJump = (TripleJump)power;
            tripleJump.isInAir = true;
        }
    }

    public static void handleHandshakeResponse(class_3222 player, HandshakePayload payload) {
        String clientVersionStr = payload.modVersionStr();
        String clientCompatibilityStr = payload.compatibilityStr();
        String serverVersionStr = "dev-1.3.7.18";
        String serverCompatibilityStr = VersionControl.serverCompatibilityMin();
        int clientVersion = payload.modVersion();
        int clientCompatibility = payload.compatibility();
        int serverVersion = VersionControl.getModVersionInt(serverVersionStr);
        int serverCompatibility = VersionControl.getModVersionInt(serverCompatibilityStr);
        if (clientVersion < serverCompatibility) {
            class_5250 disconnectText = class_2561.method_43470((String)("[Life Series Mod] Client-Server version mismatch!\nUpdate the client version to at least version " + serverCompatibilityStr));
            player.field_13987.method_60673(new class_9812((class_2561)disconnectText));
            return;
        }
        if (serverVersion < clientCompatibility) {
            class_5250 disconnectText = class_2561.method_43470((String)("[Life Series Mod] Server-Client version mismatch!\nThe client version is too new for the server.\nEither update the server, or downgrade the client version to " + serverVersionStr));
            player.field_13987.method_60673(new class_9812((class_2561)disconnectText));
            return;
        }
        Main.LOGGER.info(TextUtils.formatString("[PACKET_SERVER] Received handshake (from {}): {{}, {}}", player, payload.modVersionStr(), payload.modVersion()));
        handshakeSuccessful.add(player.method_5667());
        PlayerUtils.resendCommandTree(player);
    }

    public static void sendTriviaPacket(class_3222 player, String question, int difficulty, long timestamp, int timeToComplete, List<String> answers) {
        TriviaQuestionPayload triviaQuestionPacket = new TriviaQuestionPayload(question, difficulty, timestamp, timeToComplete, answers);
        if (VersionControl.isDevVersion()) {
            Main.LOGGER.info(TextUtils.formatString("[PACKET_SERVER] Sending trivia question packet to {}): {{}, {}, {}, {}, {}}", player, question, difficulty, timestamp, timeToComplete, answers));
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)triviaQuestionPacket);
    }

    public static void sendConfig(class_3222 player, ConfigPayload configPacket) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)configPacket);
    }

    public static void sendHandshake(class_3222 player) {
        String serverVersionStr = "dev-1.3.7.18";
        String serverCompatibilityStr = VersionControl.serverCompatibilityMin();
        int serverVersion = VersionControl.getModVersionInt(serverVersionStr);
        int serverCompatibility = VersionControl.getModVersionInt(serverCompatibilityStr);
        HandshakePayload payload = new HandshakePayload(serverVersionStr, serverVersion, serverCompatibilityStr, serverCompatibility);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        handshakeSuccessful.remove(player.method_5667());
        if (VersionControl.isDevVersion()) {
            Main.LOGGER.info(TextUtils.formatString("[PACKET_SERVER] Sending handshake to {}: {{}, {}}", player, serverVersionStr, serverVersion));
        }
    }

    public static void sendStringPacket(class_3222 player, PacketNames name, String value) {
        StringPayload payload = new StringPayload(name.getName(), value);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static void sendStringListPacket(class_3222 player, PacketNames name, List<String> value) {
        StringListPayload payload = new StringListPayload(name.getName(), value);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static void sendStringListPackets(PacketNames name, List<String> value) {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            StringListPayload payload = new StringListPayload(name.getName(), value);
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }

    public static void sendNumberPacket(class_3222 player, PacketNames name, double number) {
        if (player == null) {
            return;
        }
        NumberPayload payload = new NumberPayload(name.getName(), number);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static void sendLongPacket(class_3222 player, PacketNames name, long number) {
        if (player == null) {
            return;
        }
        LongPayload payload = new LongPayload(name.getName(), number);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static void sendImagePacket(class_3222 player, ImagePayload payload) {
        if (player == null) {
            return;
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static void sendImagePackets(ImagePayload payload) {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }

    public static void sendLongPackets(PacketNames name, long number) {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            NetworkHandlerServer.sendLongPacket(player, name, number);
        }
    }

    public static void sendUpdatePacketTo(class_3222 player) {
        if (Main.currentSeason instanceof WildLife) {
            NetworkHandlerServer.sendNumberPacket(player, PacketNames.PLAYER_MIN_MSPT, TimeDilation.MIN_PLAYER_MSPT);
            ArrayList<String> activeWildcards = new ArrayList<String>();
            for (Wildcards wildcard : WildcardManager.activeWildcards.keySet()) {
                activeWildcards.add(wildcard.getStringName());
            }
            NetworkHandlerServer.sendStringPacket(player, PacketNames.ACTIVE_WILDCARDS, String.join((CharSequence)"__", activeWildcards));
        }
        NetworkHandlerServer.sendStringPacket(player, PacketNames.CURRENT_SEASON, Main.currentSeason.getSeason().getId());
        NetworkHandlerServer.sendStringPacket(player, PacketNames.TABLIST_SHOW_EXACT, String.valueOf(Season.TAB_LIST_SHOW_EXACT_LIVES));
    }

    public static void sendUpdatePackets() {
        PlayerUtils.getAllPlayers().forEach(NetworkHandlerServer::sendUpdatePacketTo);
    }

    public static void sendPlayerDisguise(String hiddenUUID, String hiddenName, String shownUUID, String shownName) {
        PlayerDisguisePayload payload = new PlayerDisguisePayload(PacketNames.PLAYER_DISGUISE.getName(), hiddenUUID, hiddenName, shownUUID, shownName);
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }

    public static void sendPlayerInvisible(UUID uuid, long timestamp) {
        LongPayload payload = new LongPayload(PacketNames.PLAYER_INVISIBLE.getName() + uuid.toString(), timestamp);
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }

    public static void sendVignette(class_3222 player, long durationMillis) {
        LongPayload payload = new LongPayload(PacketNames.SHOW_VIGNETTE.getName(), durationMillis);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static void tryKickFailedHandshake(class_3222 player) {
        if (Main.server == null) {
            return;
        }
        if (Main.currentSeason.getSeason() != Seasons.WILD_LIFE) {
            return;
        }
        if (NetworkHandlerServer.wasHandshakeSuccessful(player)) {
            return;
        }
        class_5250 disconnectText = class_2561.method_43470((String)"You must have the \u00a72Life Series mod\n\u00a7l installed on the client\u00a7r\u00a7r\u00a7f to play Wild Life!\n").method_10852((class_2561)class_2561.method_43470((String)"\u00a79\u00a7nThe Life Series mod is available on Modrinth."));
        player.field_13987.method_60673(new class_9812((class_2561)disconnectText));
    }

    public static boolean wasHandshakeSuccessful(class_3222 player) {
        if (player == null) {
            return false;
        }
        return NetworkHandlerServer.wasHandshakeSuccessful(player.method_5667());
    }

    public static boolean wasHandshakeSuccessful(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return handshakeSuccessful.contains(uuid);
    }
}

