/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.network;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.config.ClientConfig;
import net.mat0u5.lifeseries.config.ClientConfigGuiManager;
import net.mat0u5.lifeseries.config.ClientConfigNetwork;
import net.mat0u5.lifeseries.features.SnailSkinsClient;
import net.mat0u5.lifeseries.features.Trivia;
import net.mat0u5.lifeseries.gui.other.ChooseWildcardScreen;
import net.mat0u5.lifeseries.gui.other.SnailTextureInfoScreen;
import net.mat0u5.lifeseries.gui.seasons.ChooseSeasonScreen;
import net.mat0u5.lifeseries.gui.seasons.SeasonInfoScreen;
import net.mat0u5.lifeseries.network.packets.ConfigPayload;
import net.mat0u5.lifeseries.network.packets.HandshakePayload;
import net.mat0u5.lifeseries.network.packets.ImagePayload;
import net.mat0u5.lifeseries.network.packets.LongPayload;
import net.mat0u5.lifeseries.network.packets.NumberPayload;
import net.mat0u5.lifeseries.network.packets.PlayerDisguisePayload;
import net.mat0u5.lifeseries.network.packets.StringListPayload;
import net.mat0u5.lifeseries.network.packets.StringPayload;
import net.mat0u5.lifeseries.network.packets.TriviaQuestionPayload;
import net.mat0u5.lifeseries.render.VignetteRenderer;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.morph.MorphManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.TimeDilation;
import net.mat0u5.lifeseries.seasons.session.SessionStatus;
import net.mat0u5.lifeseries.utils.ClientResourcePacks;
import net.mat0u5.lifeseries.utils.ClientTaskScheduler;
import net.mat0u5.lifeseries.utils.versions.VersionControl;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class NetworkHandlerClient {
    public static void registerClientReceiver() {
        ClientPlayNetworking.registerGlobalReceiver(NumberPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleNumberPacket(payload.name(), payload.number()));
        });
        ClientPlayNetworking.registerGlobalReceiver(StringPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleStringPacket(payload.name(), payload.value()));
        });
        ClientPlayNetworking.registerGlobalReceiver(HandshakePayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(NetworkHandlerClient::sendHandshake);
        });
        ClientPlayNetworking.registerGlobalReceiver(TriviaQuestionPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> Trivia.receiveTrivia(payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(LongPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleLongPacket(payload.name(), payload.number()));
        });
        ClientPlayNetworking.registerGlobalReceiver(PlayerDisguisePayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handlePlayerDisguise(payload.name(), payload.hiddenUUID(), payload.hiddenName(), payload.shownUUID(), payload.shownName()));
        });
        ClientPlayNetworking.registerGlobalReceiver(ImagePayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleImagePacket(payload.name(), payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(ConfigPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleConfigPacket(payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(StringListPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleStringListPacket(payload.name(), payload.value()));
        });
    }

    public static void handleStringListPacket(String name, List<String> value) {
        if (name.equalsIgnoreCase("morph")) {
            try {
                String morphUUIDStr = value.get(0);
                UUID morphUUID = UUID.fromString(morphUUIDStr);
                String morphTypeStr = value.get(1);
                class_1299 morphType = null;
                if (!morphTypeStr.equalsIgnoreCase("null") && !morphUUIDStr.isEmpty()) {
                    morphType = (class_1299)class_7923.field_41177.method_10223(class_2960.method_60654((String)morphTypeStr));
                }
                if (VersionControl.isDevVersion()) {
                    Main.LOGGER.info("[PACKET_CLIENT] Received morph packet: {} ({})", morphType, (Object)morphUUID);
                }
                MorphManager.setFromPacket(morphUUID, morphType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void handleConfigPacket(ConfigPayload payload) {
        ClientConfigNetwork.handleConfigPacket(payload, false);
    }

    public static void handleImagePacket(String name, ImagePayload payload) {
        if (name.equalsIgnoreCase("snail_skin")) {
            SnailSkinsClient.handleSnailSkin(payload);
        }
    }

    public static void handleStringPacket(String name, String value) {
        class_2338 pos;
        String[] split2;
        UUID uuid2;
        Seasons season;
        if (name.equalsIgnoreCase("currentSeason")) {
            if (VersionControl.isDevVersion()) {
                Main.LOGGER.info("[PACKET_CLIENT] Updated current season to {}", (Object)value);
            }
            MainClient.clientCurrentSeason = Seasons.getSeasonFromStringName(value);
            ClientResourcePacks.checkClientPacks();
            MainClient.reloadConfig();
        }
        if (name.equalsIgnoreCase("sessionStatus")) {
            MainClient.clientSessionStatus = SessionStatus.getSessionName(SessionStatus.getStringName(Main.currentSession.status));
        }
        if (name.equalsIgnoreCase("activeWildcards")) {
            ArrayList<Wildcards> newList = new ArrayList<Wildcards>();
            for (String wildcardStr : value.split("__")) {
                newList.add(Wildcards.getFromString(wildcardStr));
            }
            if (VersionControl.isDevVersion()) {
                Main.LOGGER.info("[PACKET_CLIENT] Updated current wildcards to {}", newList);
            }
            MainClient.clientActiveWildcards = newList;
        }
        if (name.equalsIgnoreCase("jump") && class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_6043();
        }
        if (name.equalsIgnoreCase("reset_trivia")) {
            Trivia.resetTrivia();
        }
        if (name.equalsIgnoreCase("select_wildcards")) {
            class_310.method_1551().method_1507((class_437)new ChooseWildcardScreen());
        }
        if (name.equalsIgnoreCase("open_config")) {
            ClientConfigNetwork.load();
            ClientTaskScheduler.scheduleTask(20, ClientConfigGuiManager::openConfig);
        }
        if (name.equalsIgnoreCase("select_season")) {
            class_310.method_1551().method_1507((class_437)new ChooseSeasonScreen(!value.isEmpty()));
        }
        if (name.equalsIgnoreCase("season_info") && (season = Seasons.getSeasonFromStringName(value)) != Seasons.UNASSIGNED) {
            class_310.method_1551().method_1507((class_437)new SeasonInfoScreen(season));
        }
        if (name.equalsIgnoreCase("trivia_bot_part")) {
            try {
                uuid2 = UUID.fromString(value);
                MainClient.triviaBotPartUUIDs.add(uuid2);
            }
            catch (Exception uuid2) {
                // empty catch block
            }
        }
        if (name.equalsIgnoreCase("snail_part")) {
            try {
                uuid2 = UUID.fromString(value);
                MainClient.snailPartUUIDs.add(uuid2);
            }
            catch (Exception uuid3) {
                // empty catch block
            }
        }
        if (name.equalsIgnoreCase("snail_pos")) {
            try {
                split2 = value.split("_");
                MainClient.snailPos = pos = new class_2338(Integer.parseInt(split2[0]), Integer.parseInt(split2[1]), Integer.parseInt(split2[2]));
                MainClient.snailPosTime = System.currentTimeMillis();
            }
            catch (Exception split2) {
                // empty catch block
            }
        }
        if (name.equalsIgnoreCase("trivia_snail_part")) {
            try {
                uuid2 = UUID.fromString(value);
                MainClient.triviaSnailPartUUIDs.add(uuid2);
            }
            catch (Exception uuid4) {
                // empty catch block
            }
        }
        if (name.equalsIgnoreCase("trivia_snail_pos")) {
            try {
                split2 = value.split("_");
                MainClient.triviaSnailPos = pos = new class_2338(Integer.parseInt(split2[0]), Integer.parseInt(split2[1]), Integer.parseInt(split2[2]));
                MainClient.triviaSnailPosTime = System.currentTimeMillis();
            }
            catch (Exception split3) {
                // empty catch block
            }
        }
        if (name.equalsIgnoreCase("snail_textures_info")) {
            class_310.method_1551().method_1507((class_437)new SnailTextureInfoScreen());
        }
        if (name.equalsIgnoreCase("prevent_gliding")) {
            MainClient.preventGliding = value.equalsIgnoreCase("true");
        }
        if (name.equalsIgnoreCase("toggle_timer")) {
            String key = ClientConfig.SESSION_TIMER.key;
            if (MainClient.clientCurrentSeason == Seasons.LIMITED_LIFE) {
                key = ClientConfig.SESSION_TIMER_LIMITEDLIFE.key;
            }
            MainClient.clientConfig.setProperty(key, String.valueOf(!MainClient.SESSION_TIMER));
            MainClient.reloadConfig();
        }
    }

    public static void handleNumberPacket(String name, double number) {
        int intNumber = (int)number;
        if (name.equalsIgnoreCase("player_min_mspt")) {
            if (VersionControl.isDevVersion()) {
                Main.LOGGER.info("[PACKET_CLIENT] Updated min. player MSPT to {}", (Object)number);
            }
            TimeDilation.MIN_PLAYER_MSPT = (float)number;
        }
        if (name.equalsIgnoreCase("snail_air")) {
            MainClient.snailAir = intNumber;
            MainClient.snailAirTimestamp = System.currentTimeMillis();
        }
        if (name.equalsIgnoreCase("fake_thunder") && class_310.method_1551().field_1687 != null) {
            class_310.method_1551().field_1687.method_8509(intNumber);
        }
        if (name.equalsIgnoreCase("mute")) {
            MainClient.mutedForTicks = intNumber;
        }
    }

    public static void handleLongPacket(String name, long number) {
        if (name.equalsIgnoreCase("superpower_cooldown")) {
            MainClient.SUPERPOWER_COOLDOWN_TIMESTAMP = number;
        }
        if (name.equalsIgnoreCase("show_vignette")) {
            if (VersionControl.isDevVersion()) {
                Main.LOGGER.info("[PACKET_CLIENT] Showing vignette for {}", (Object)number);
            }
            VignetteRenderer.showVignetteFor(0.35f, number);
        }
        if (name.equalsIgnoreCase("mimicry_cooldown")) {
            MainClient.MIMICRY_COOLDOWN_TIMESTAMP = number;
        }
        if (name.startsWith("player_invisible__")) {
            try {
                UUID uuid = UUID.fromString(name.replaceFirst("player_invisible__", ""));
                if (number == 0L) {
                    MainClient.invisiblePlayers.remove(uuid);
                } else {
                    MainClient.invisiblePlayers.put(uuid, number);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (name.equalsIgnoreCase("time_dilation")) {
            MainClient.TIME_DILATION_TIMESTAMP = number;
        }
        if (name.equalsIgnoreCase("session_timer")) {
            MainClient.sessionTime = number;
            MainClient.sessionTimeLastUpdated = System.currentTimeMillis();
        }
        if (name.startsWith("limited_life_timer__")) {
            MainClient.limitedLifeTimerColor = name.replaceFirst("limited_life_timer__", "");
            MainClient.limitedLifeLives = number;
            MainClient.limitedLifeTimeLastUpdated = System.currentTimeMillis();
        }
        if (name.equalsIgnoreCase("curse_sliding")) {
            MainClient.CURSE_SLIDING = number;
        }
    }

    public static void handlePlayerDisguise(String name, String hiddenUUID, String hiddenName, String shownUUID, String shownName) {
        if (name.equalsIgnoreCase("player_disguise")) {
            if (shownName.isEmpty()) {
                MainClient.playerDisguiseNames.remove(hiddenName);
                try {
                    UUID hideUUID = UUID.fromString(hiddenUUID);
                    MainClient.playerDisguiseUUIDs.remove(hideUUID);
                }
                catch (Exception hideUUID) {}
            } else {
                MainClient.playerDisguiseNames.put(hiddenName, shownName);
                try {
                    UUID hideUUID = UUID.fromString(hiddenUUID);
                    UUID showUUID = UUID.fromString(shownUUID);
                    MainClient.playerDisguiseUUIDs.put(hideUUID, showUUID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void sendHandshake() {
        String clientVersionStr = "dev-1.3.6.10";
        String clientCompatibilityStr = VersionControl.clientCompatibilityMin();
        int clientVersion = VersionControl.getModVersionInt(clientVersionStr);
        int clientCompatibility = VersionControl.getModVersionInt(clientCompatibilityStr);
        HandshakePayload sendPayload = new HandshakePayload(clientVersionStr, clientVersion, clientCompatibilityStr, clientCompatibility);
        ClientPlayNetworking.send((class_8710)sendPayload);
        if (VersionControl.isDevVersion()) {
            Main.LOGGER.info("[PACKET_CLIENT] Sent handshake");
        }
    }

    public static void sendConfigUpdate(String configType, String id, List<String> args) {
        ConfigPayload configPacket = new ConfigPayload(configType, id, -1, "", "", args);
        ClientPlayNetworking.send((class_8710)configPacket);
    }

    public static void sendTriviaAnswer(int answer) {
        if (VersionControl.isDevVersion()) {
            Main.LOGGER.info("[PACKET_CLIENT] Sending trivia answer: {}", (Object)answer);
        }
        ClientPlayNetworking.send((class_8710)new NumberPayload("trivia_answer", answer));
    }

    public static void sendHoldingJumpPacket() {
        ClientPlayNetworking.send((class_8710)new StringPayload("holding_jump", "true"));
    }

    public static void pressSuperpowerKey() {
        ClientPlayNetworking.send((class_8710)new StringPayload("superpower_key", "true"));
    }

    public static void sendStringPacket(String name, String value) {
        ClientPlayNetworking.send((class_8710)new StringPayload(name, value));
    }

    public static void sendNumberPacket(String name, double value) {
        ClientPlayNetworking.send((class_8710)new NumberPayload(name, value));
    }
}

