/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.limitedlife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_9011;

public class LimitedLifeCommands {
    public static boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.LIMITED_LIFE;
    }

    public static boolean checkBanned(class_2168 source) {
        if (LimitedLifeCommands.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is only available when playing Limited Life."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"limitedlife").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"time").executes(context -> LimitedLifeCommands.showLives((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> LimitedLifeCommands.reloadLives((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(List.of("30m", "1h"), (SuggestionsBuilder)builder)).executes(context -> LimitedLifeCommands.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"time"), false, false)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(List.of("30m", "1h"), (SuggestionsBuilder)builder)).executes(context -> LimitedLifeCommands.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"time"), false, true)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(List.of("8h", "16h", "24h"), (SuggestionsBuilder)builder)).executes(context -> LimitedLifeCommands.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"time"), true, false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> LimitedLifeCommands.getLivesFor((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"))))).then(class_2170.method_9247((String)"*").executes(context -> LimitedLifeCommands.getAllLives((class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> LimitedLifeCommands.resetLives((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"resetAll").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> LimitedLifeCommands.resetAllLives((class_2168)context.getSource())))));
    }

    public static int showLives(class_2168 source) {
        if (LimitedLifeCommands.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (!Main.currentSeason.hasAssignedLives(self)) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"You have not been assigned any time yet"));
            return 1;
        }
        Integer playerLives = Main.currentSeason.getPlayerLives(self);
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("You have {} left", Main.currentSeason.getFormattedLives(playerLives)));
        if (playerLives == null || playerLives <= 0) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"Womp womp."));
        }
        return 1;
    }

    public static int getAllLives(class_2168 source) {
        if (LimitedLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (!ScoreboardUtils.existsObjective("Lives")) {
            source.method_9213(class_2561.method_30163((String)"Nobody has been assigned time yet"));
            return -1;
        }
        Collection<class_9011> entries = ScoreboardUtils.getScores("Lives");
        if (entries.isEmpty()) {
            source.method_9213(class_2561.method_30163((String)"Nobody has been assigned time yet"));
            return -1;
        }
        class_5250 text = class_2561.method_43470((String)"Assigned Time: \n");
        for (class_9011 entry : entries) {
            String name = entry.comp_2127();
            if (name.startsWith("`")) continue;
            int lives = entry.comp_2128();
            class_124 color = Main.currentSeason.getColorForLives(lives);
            text.method_10852((class_2561)TextUtils.format("{} has {} left\n", class_2561.method_43470((String)name).method_27692(color), Main.currentSeason.getFormattedLives(lives)));
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)text);
        return 1;
    }

    public static int getLivesFor(class_2168 source, class_3222 target) {
        if (LimitedLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        if (!Main.currentSeason.hasAssignedLives(target)) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} has not been assigned any time", target));
            return -1;
        }
        Integer lives = Main.currentSeason.getPlayerLives(target);
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{} has {} left", target, Main.currentSeason.getFormattedLives(lives)));
        return 1;
    }

    public static int reloadLives(class_2168 source) {
        if (LimitedLifeCommands.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Reloading times..."));
        Main.currentSeason.reloadAllPlayerTeams();
        return 1;
    }

    public static int lifeManager(class_2168 source, Collection<class_3222> targets, String timeArgument, boolean setNotGive, boolean reverse) {
        if (LimitedLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        Integer amount = OtherUtils.parseTimeSecondsFromArgument(timeArgument);
        if (amount == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid time format. Use h, m, s for hours, minutes, and seconds."));
            return -1;
        }
        if (reverse) {
            amount = amount * -1;
        }
        if (setNotGive) {
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set {}'s time to {}", targets.iterator().next(), Main.currentSeason.getFormattedLives(amount)));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set time to {} for {} targets", Main.currentSeason.getFormattedLives(amount), targets.size()));
            }
            for (class_3222 player : targets) {
                Main.currentSeason.setPlayerLives(player, amount);
            }
        } else {
            String toOrFrom;
            String addOrRemove = amount >= 0 ? "Added" : "Removed";
            String time = OtherUtils.formatTime(Math.abs(amount) * 20);
            String string = toOrFrom = amount >= 0 ? "to" : "from";
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} {} {}", addOrRemove, time, toOrFrom, targets.iterator().next()));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} {} {} targets", addOrRemove, time, toOrFrom, targets.size()));
            }
            for (class_3222 player : targets) {
                Main.currentSeason.addToPlayerLives(player, amount);
            }
        }
        return 1;
    }

    public static int resetLives(class_2168 source, Collection<class_3222> targets) {
        if (LimitedLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        for (class_3222 player : targets) {
            Main.currentSeason.resetPlayerLife(player);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset {}'s time", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset time of {} targets", targets.size()));
        }
        return 1;
    }

    public static int resetAllLives(class_2168 source) {
        if (LimitedLifeCommands.checkBanned(source)) {
            return -1;
        }
        Main.currentSeason.resetAllPlayerLives();
        OtherUtils.sendCommandFeedback(source, (class_2561)class_2561.method_43470((String)"Reset everyone's time"));
        return 1;
    }
}

