/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife;

import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.seasons.boogeyman.Boogeyman;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.WildLifeConfig;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Hunger;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.MobSwap;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.SizeShifting;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.TimeDilation;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.ToggleableSuperpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.AnimalDisguise;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Creaking;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Flight;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Invisibility;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Necromancy;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.PlayerDisguise;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.SuperPunch;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Superspeed;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.TripleJump;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.WindCharge;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.utils.player.AttributeUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_7260;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class WildLife
extends Season {
    public static final String COMMANDS_ADMIN_TEXT = "/lifeseries, /session, /claimkill, /lives, /wildcard, /superpower, /snail";
    public static final String COMMANDS_TEXT = "/claimkill, /lives, /snail";
    public static boolean KILLING_DARK_GREENS_GAINS_LIVES = true;

    @Override
    public Seasons getSeason() {
        return Seasons.WILD_LIFE;
    }

    @Override
    public ConfigManager getConfig() {
        return new WildLifeConfig();
    }

    @Override
    public void onPlayerJoin(class_3222 player) {
        super.onPlayerJoin(player);
        if (!this.hasAssignedLives(player)) {
            int lives = (Integer)Main.seasonConfig.DEFAULT_LIVES.get(Main.seasonConfig);
            this.setPlayerLives(player, lives);
        }
        WildcardManager.onPlayerJoin(player);
    }

    @Override
    public void onPlayerFinishJoining(class_3222 player) {
        if (PermissionManager.isAdmin(player)) {
            player.method_43496(class_2561.method_30163((String)"\u00a77Wild Life commands: \u00a7r/lifeseries, /session, /claimkill, /lives, /wildcard, /superpower, /snail"));
        } else {
            player.method_43496(class_2561.method_30163((String)"\u00a77Wild Life non-admin commands: \u00a7r/claimkill, /lives, /snail"));
        }
        super.onPlayerFinishJoining(player);
        WildcardManager.onPlayerFinishJoining(player);
    }

    @Override
    public boolean isAllowedToAttack(class_3222 attacker, class_3222 victim) {
        if (Necromancy.isRessurectedPlayer(victim) || Necromancy.isRessurectedPlayer(attacker)) {
            return true;
        }
        if (this.isOnLastLife(attacker, false)) {
            return true;
        }
        if (attacker.method_6124() == victim && this.isOnLastLife(victim, false)) {
            return true;
        }
        if (this.isOnSpecificLives(attacker, 2, false) && this.isOnAtLeastLives(victim, 3, false)) {
            return true;
        }
        if (attacker.method_6124() == victim && this.isOnSpecificLives(victim, 2, false) && this.isOnAtLeastLives(attacker, 3, false)) {
            return true;
        }
        Boogeyman boogeymanAttacker = this.boogeymanManagerNew.getBoogeyman(attacker);
        Boogeyman boogeymanVictim = this.boogeymanManagerNew.getBoogeyman(victim);
        if (boogeymanAttacker != null && !boogeymanAttacker.cured) {
            return true;
        }
        return attacker.method_6124() == victim && boogeymanVictim != null && !boogeymanVictim.cured;
    }

    @Override
    public void onPlayerKilledByPlayer(class_3222 victim, class_3222 killer) {
        boolean gaveLife = false;
        boolean isAllowedToAttack = this.isAllowedToAttack(killer, victim);
        if (this.isOnAtLeastLives(victim, 4, false)) {
            ConfigManager configManager;
            if (Necromancy.isRessurectedPlayer(killer) && (configManager = Main.seasonConfig) instanceof WildLifeConfig) {
                WildLifeConfig config = (WildLifeConfig)configManager;
                if (WildLifeConfig.WILDCARD_SUPERPOWERS_ZOMBIES_REVIVE_BY_KILLING_DARK_GREEN.get(config).booleanValue()) {
                    int lives;
                    Integer currentLives = this.getPlayerLives(killer);
                    if (currentLives == null) {
                        currentLives = 0;
                    }
                    if ((lives = currentLives + 1) <= 0) {
                        ScoreboardUtils.setScore(class_9015.method_55422((String)killer.method_5820()), "Lives", lives);
                    } else {
                        this.addPlayerLife(killer);
                        Necromancy.removeRessurectedPlayer(killer);
                        AttributeUtils.resetAttributesOnPlayerJoin(killer);
                        gaveLife = true;
                    }
                }
            } else {
                if (KILLING_DARK_GREENS_GAINS_LIVES) {
                    this.addPlayerLife(killer);
                }
                gaveLife = true;
            }
        }
        if (isAllowedToAttack) {
            Boogeyman boogeyman = this.boogeymanManagerNew.getBoogeyman(killer);
            if (boogeyman != null && !boogeyman.cured && !this.isOnLastLife(victim, true)) {
                this.boogeymanManagerNew.cure(killer);
            }
        } else {
            PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)("\u00a7c [Unjustified Kill?] \u00a7f" + victim.method_5820() + "\u00a77 was killed by \u00a7f" + killer.method_5820() + "\u00a77, who is not \u00a7cred name\u00a77 (nor a \u00a7eyellow name\u00a77, with the victim being a \u00a72dark green name\u00a77)")));
            if (gaveLife) {
                PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"\u00a77Remember to remove a life from the killer (using \u00a7f/lives remove <player>\u00a77) if this was indeed an unjustified kill."));
            }
        }
    }

    @Override
    public void onClaimKill(class_3222 killer, class_3222 victim) {
        super.onClaimKill(killer, victim);
        if (this.isOnAtLeastLives(victim, 4, false) && KILLING_DARK_GREENS_GAINS_LIVES) {
            this.addPlayerLife(killer);
        }
    }

    @Override
    public void tickSessionOn(MinecraftServer server) {
        super.tickSessionOn(server);
        WildcardManager.tickSessionOn();
    }

    @Override
    public void tick(MinecraftServer server) {
        super.tick(server);
        WildcardManager.tick();
    }

    @Override
    public boolean sessionStart() {
        if (super.sessionStart()) {
            WildcardManager.onSessionStart();
            this.activeActions.addAll(WildcardManager.getActions());
            return true;
        }
        return false;
    }

    @Override
    public void sessionEnd() {
        WildcardManager.onSessionEnd();
        super.sessionEnd();
    }

    @Override
    public void initialize() {
        super.initialize();
        Snails.loadConfig();
        Snails.loadSnailNames();
        TriviaBot.initializeItemSpawner();
    }

    @Override
    public void reload() {
        super.reload();
        ConfigManager configManager = Main.seasonConfig;
        if (!(configManager instanceof WildLifeConfig)) {
            return;
        }
        WildLifeConfig config = (WildLifeConfig)configManager;
        Hunger.SWITCH_DELAY = WildLifeConfig.WILDCARD_HUNGER_RANDOMIZE_INTERVAL.get(config);
        SizeShifting.MIN_SIZE = WildLifeConfig.WILDCARD_SIZESHIFTING_MIN_SIZE.get(config);
        SizeShifting.MAX_SIZE = WildLifeConfig.WILDCARD_SIZESHIFTING_MAX_SIZE.get(config);
        SizeShifting.SIZE_CHANGE_MULTIPLIER = WildLifeConfig.WILDCARD_SIZESHIFTING_SIZE_CHANGE_MULTIPLIER.get(config);
        Snail.GLOBAL_SPEED_MULTIPLIER = WildLifeConfig.WILDCARD_SNAILS_SPEED_MULTIPLIER.get(config);
        Snail.SHOULD_DROWN_PLAYER = WildLifeConfig.WILDCARD_SNAILS_DROWN_PLAYERS.get(config);
        TimeDilation.MIN_TICK_RATE = (float)(20.0 * WildLifeConfig.WILDCARD_TIMEDILATION_MIN_SPEED.get(config));
        TimeDilation.MAX_TICK_RATE = (float)(20.0 * WildLifeConfig.WILDCARD_TIMEDILATION_MAX_SPEED.get(config));
        TimeDilation.MIN_PLAYER_MSPT = (float)(50.0 / WildLifeConfig.WILDCARD_TIMEDILATION_PLAYER_MAX_SPEED.get(config));
        MobSwap.MAX_DELAY = WildLifeConfig.WILDCARD_MOBSWAP_START_SPAWN_DELAY.get(config);
        MobSwap.MIN_DELAY = WildLifeConfig.WILDCARD_MOBSWAP_END_SPAWN_DELAY.get(config);
        MobSwap.SPAWN_MOBS = WildLifeConfig.WILDCARD_MOBSWAP_SPAWN_MOBS.get(config);
        MobSwap.BOSS_CHANCE_MULTIPLIER = WildLifeConfig.WILDCARD_MOBSWAP_BOSS_CHANCE_MULTIPLIER.get(config);
        TriviaBot.CAN_START_RIDING = WildLifeConfig.WILDCARD_TRIVIA_BOTS_CAN_ENTER_BOATS.get(config);
        TriviaWildcard.TRIVIA_BOTS_PER_PLAYER = WildLifeConfig.WILDCARD_TRIVIA_BOTS_PER_PLAYER.get(config);
        TriviaBot.EASY_TIME = WildLifeConfig.WILDCARD_TRIVIA_SECONDS_EASY.get(config);
        TriviaBot.NORMAL_TIME = WildLifeConfig.WILDCARD_TRIVIA_SECONDS_NORMAL.get(config);
        TriviaBot.HARD_TIME = WildLifeConfig.WILDCARD_TRIVIA_SECONDS_HARD.get(config);
        WindCharge.MAX_MACE_DAMAGE = WildLifeConfig.WILDCARD_SUPERPOWERS_WINDCHARGE_MAX_MACE_DAMAGE.get(config);
        Superspeed.STEP_UP = WildLifeConfig.WILDCARD_SUPERPOWERS_SUPERSPEED_STEP.get(config);
        WildcardManager.ACTIVATE_WILDCARD_MINUTE = WildLifeConfig.ACTIVATE_WILDCARD_MINUTE.get(config);
        KILLING_DARK_GREENS_GAINS_LIVES = WildLifeConfig.KILLING_DARK_GREENS_GAINS_LIVES.get(config);
        Snails.loadConfig();
        Snails.loadSnailNames();
        Snails.reloadSnailNames();
        Snails.reloadSnailSkins();
        TriviaWildcard.reload();
    }

    @Override
    public void modifyEntityDrops(class_1309 entity, class_1282 damageSource) {
        super.modifyEntityDrops(entity, damageSource);
        if (damageSource.method_5526() instanceof class_1657 && (entity instanceof class_7260 || entity instanceof class_1528 || entity instanceof class_1510)) {
            entity.method_5775(class_1802.field_8288.method_7854());
        }
    }

    @Override
    public void onPlayerDeath(class_3222 player, class_1282 source) {
        super.onPlayerDeath(player, source);
        TriviaBot.cursedGigantificationPlayers.remove(player.method_5667());
        TriviaBot.cursedHeartPlayers.remove(player.method_5667());
        AttributeUtils.resetMaxPlayerHealthIfNecessary(player);
        TriviaBot.cursedMoonJumpPlayers.remove(player.method_5667());
        AttributeUtils.resetPlayerJumpHeight(player);
    }

    public static void changedPlayerTeam(class_3222 player) {
        Superpower superpower;
        if (SuperpowersWildcard.hasActivePower(player, Superpowers.CREAKING) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof Creaking) {
            Creaking creakingPower = (Creaking)superpower;
            creakingPower.deactivate();
        }
    }

    @Override
    public void onPlayerDamage(class_3222 player, class_1282 source, float amount, CallbackInfo ci) {
        ToggleableSuperpower power;
        Superpower superpower;
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.PLAYER_DISGUISE) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof PlayerDisguise) {
            power = (PlayerDisguise)superpower;
            ((PlayerDisguise)power).onTakeDamage();
        }
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.ANIMAL_DISGUISE) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof AnimalDisguise) {
            power = (AnimalDisguise)superpower;
            ((AnimalDisguise)power).onTakeDamage();
        }
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.INVISIBILITY) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof Invisibility) {
            power = (Invisibility)superpower;
            ((Invisibility)power).onTakeDamage();
        }
    }

    @Override
    public void onPrePlayerDamage(class_3222 player, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_48792() == player.method_48923().method_48827().method_48792() || source.method_48792() == player.method_48923().method_48837().method_48792() || source.method_48792() == player.method_48923().method_48828().method_48792()) {
            Superpower power;
            Superpower superpower;
            if (SuperpowersWildcard.hasActivePower(player, Superpowers.FLIGHT) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof Flight) {
                power = (Flight)superpower;
                if (power.isLaunchedUp) {
                    if (source.method_48792() != player.method_48923().method_48828().method_48792()) {
                        power.isLaunchedUp = false;
                    }
                    cir.setReturnValue((Object)false);
                    return;
                }
            }
            if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.TRIPLE_JUMP) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof TripleJump) {
                power = (TripleJump)superpower;
                if (((TripleJump)power).isInAir) {
                    ((TripleJump)power).isInAir = false;
                    cir.setReturnValue((Object)false);
                    return;
                }
            }
            if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.SUPER_PUNCH) && player.method_5765() && player.method_5854() instanceof class_3222) {
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }

    @Override
    public void onRightClickEntity(class_3222 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        Superpower superpower;
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.SUPER_PUNCH) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof SuperPunch) {
            SuperPunch power = (SuperPunch)superpower;
            power.tryRideEntity(entity);
        }
    }

    @Override
    public void onAttackEntity(class_3222 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        Superpower superpower;
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.INVISIBILITY) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof Invisibility) {
            Invisibility power = (Invisibility)superpower;
            power.onAttack();
        }
    }
}

