/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard;

import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Callback;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1928;
import net.minecraft.class_2596;
import net.minecraft.class_2761;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_8915;

public class TimeDilation
extends Wildcard {
    public static float MIN_TICK_RATE = 1.0f;
    public static float NORMAL_TICK_RATE = 20.0f;
    public static float MAX_TICK_RATE = 100.0f;
    public static float MIN_TICK_RATE_NERFED = 10.0f;
    public static float MAX_TICK_RATE_NERFED = 30.0f;
    public static float MIN_PLAYER_MSPT = 25.0f;
    public static int updateRate = 100;
    public static int lastDiv = -1;
    public static int activatedAt = -1;
    public static float weatherTicksBacklog = 0.0f;

    @Override
    public Wildcards getType() {
        return Wildcards.TIME_DILATION;
    }

    @Override
    public void tick() {
        if (Main.server == null) {
            return;
        }
        class_8915 serverTickManager = Main.server.method_54833();
        float rate = serverTickManager.method_54748();
        if (rate > 20.0f) {
            int weatherTicks;
            if (rate > 30.0f) {
                TimeDilation.adjustCreeperFuseTimes();
            }
            if ((weatherTicks = (int)(weatherTicksBacklog += (rate - 20.0f) / 2.0f)) >= 1) {
                weatherTicksBacklog -= (float)weatherTicks;
                for (class_3218 serverWorld : Main.server.method_3738()) {
                    long newTicks = serverWorld.method_8532() + (long)weatherTicks;
                    serverWorld.method_29199(newTicks);
                    for (class_3222 player : serverWorld.method_18456()) {
                        player.field_13987.method_14364((class_2596)new class_2761(serverWorld.method_8510(), serverWorld.method_8532(), serverWorld.method_8450().method_8355(class_1928.field_19396)));
                    }
                }
            }
        }
    }

    @Override
    public void tickSessionOn() {
        int currentDiv;
        if (!this.active) {
            return;
        }
        float sessionPassedTime = (float)Main.currentSession.passedTime - (float)activatedAt;
        if (sessionPassedTime < 0.0f) {
            return;
        }
        if (sessionPassedTime > 3600.0f && sessionPassedTime < 3700.0f && !TimeDilation.isNerfed()) {
            OtherUtils.executeCommand("weather clear");
        }
        if (lastDiv != (currentDiv = (int)(Main.currentSession.passedTime / (double)updateRate))) {
            lastDiv = currentDiv;
            float progress = ((float)Main.currentSession.passedTime - (float)activatedAt) / (float)(Main.currentSession.sessionLength - activatedAt);
            if (TimeDilation.isNerfed() && (progress = ((float)Main.currentSession.passedTime - (float)activatedAt) / 6000.0f) >= 1.0f && !Callback.allWildcardsPhaseReached) {
                this.deactivate();
                WildcardManager.fadedWildcard();
                NetworkHandlerServer.sendUpdatePackets();
                return;
            }
            float rate = (progress = Math.clamp(progress, 0.0f, 1.0f)) < 0.5f ? TimeDilation.getMinTickRate() + (NORMAL_TICK_RATE - TimeDilation.getMinTickRate()) * (progress * 2.0f) : NORMAL_TICK_RATE + (TimeDilation.getMaxTickRate() - NORMAL_TICK_RATE) * (progress * 2.0f - 1.0f);
            rate = Math.min(rate, TimeDilation.getMaxTickRate());
            TimeDilation.setWorldSpeed(rate);
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        TimeDilation.setWorldSpeed(NORMAL_TICK_RATE);
        lastDiv = -1;
        OtherUtils.executeCommand("/execute as @e[type=minecraft:creeper] run data modify entity @s Fuse set value 30s");
    }

    @Override
    public void activate() {
        if (!TimeDilation.isNerfed()) {
            TaskScheduler.scheduleTask(50, () -> OtherUtils.executeCommand("weather rain"));
        }
        TaskScheduler.scheduleTask(115, () -> {
            activatedAt = (int)Main.currentSession.passedTime + 400;
            lastDiv = -1;
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3414.method_47908((class_2960)class_2960.method_60656((String)"wildlife_time_slow_down")));
            TimeDilation.slowlySetWorldSpeed(TimeDilation.getMinTickRate(), 18);
            if (!TimeDilation.isNerfed() && TimeDilation.getMinTickRate() <= 4.0f) {
                TaskScheduler.scheduleTask(18, () -> NetworkHandlerServer.sendLongPackets("time_dilation", System.currentTimeMillis()));
            }
            TaskScheduler.scheduleTask(19, () -> super.activate());
        });
    }

    public static void slowlySetWorldSpeed(float rate, int ticks) {
        if (Main.server == null) {
            return;
        }
        class_8915 serverTickManager = Main.server.method_54833();
        float currentRate = serverTickManager.method_54748();
        float step = (rate - currentRate) / (float)ticks;
        for (int i = 0; i < ticks; ++i) {
            int finalI = i;
            TaskScheduler.scheduleTask(i, () -> serverTickManager.method_54671(currentRate + step * (float)finalI));
        }
        TaskScheduler.scheduleTask(ticks + 1, () -> serverTickManager.method_54671(rate));
    }

    public static void setWorldSpeed(float rate) {
        if (Main.server == null) {
            return;
        }
        class_8915 serverTickManager = Main.server.method_54833();
        serverTickManager.method_54671(rate);
    }

    public static float getWorldSpeed() {
        if (Main.server == null) {
            return 20.0f;
        }
        class_8915 serverTickManager = Main.server.method_54833();
        return serverTickManager.method_54748();
    }

    private static void adjustCreeperFuseTimes() {
        if (Main.server == null) {
            return;
        }
        class_8915 serverTickManager = Main.server.method_54833();
        float tickRate = serverTickManager.method_54748();
        short fuseTime = (short)(20.0f * (tickRate / 20.0f));
        OtherUtils.executeCommand("/execute as @e[type=minecraft:creeper] run data modify entity @s Fuse set value " + fuseTime + "s");
    }

    public static float getMaxTickRate() {
        if (TimeDilation.isNerfed()) {
            return MAX_TICK_RATE_NERFED;
        }
        return MAX_TICK_RATE;
    }

    public static float getMinTickRate() {
        if (TimeDilation.isNerfed()) {
            return MIN_TICK_RATE_NERFED;
        }
        return Math.max(MIN_TICK_RATE, 1.0f);
    }

    public static boolean isNerfed() {
        return WildcardManager.isActiveWildcard(Wildcards.CALLBACK);
    }
}

