/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.resources.datapack.DatapackManager;
import net.mat0u5.lifeseries.seasons.boogeyman.advanceddeaths.AdvancedDeathsManager;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLife;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.morph.MorphManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.SnailSkins;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.versions.UpdateChecker;
import net.mat0u5.lifeseries.utils.world.ItemStackUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6860;
import net.minecraft.server.MinecraftServer;

public class Events {
    public static boolean skipNextTickReload = false;
    public static boolean updatePlayerListsNextTick = false;
    public static final List<UUID> joiningPlayers = new ArrayList<UUID>();
    private static final Map<UUID, class_243> joiningPlayersPos = new HashMap<UUID, class_243>();
    private static final Map<UUID, Float> joiningPlayersYaw = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> joiningPlayersPitch = new HashMap<UUID, Float>();

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTING.register(Events::onServerStarting);
        ServerLifecycleEvents.SERVER_STARTED.register(Events::onServerStart);
        ServerLifecycleEvents.SERVER_STOPPING.register(Events::onServerStopping);
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register(Events::onReloadStart);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register(Events::onReloadEnd);
        AttackBlockCallback.EVENT.register((player, level, hand, pos, direction) -> {
            if (!(player instanceof class_3222) || Main.modDisabled()) {
                return class_1269.field_5811;
            }
            return Events.onBlockAttack((class_3222)player, level, pos);
        });
        UseBlockCallback.EVENT.register(Events::onBlockUse);
        UseItemCallback.EVENT.register(Events::onItemUse);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> Events.onPlayerJoin(handler.method_32311()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> Events.onPlayerDisconnect(handler.method_32311()));
        ServerTickEvents.END_SERVER_TICK.register(Events::onServerTickEnd);
        ServerLivingEntityEvents.AFTER_DEATH.register(Events::onEntityDeath);
        UseEntityCallback.EVENT.register(Events::onRightClickEntity);
        AttackEntityCallback.EVENT.register(Events::onAttackEntity);
    }

    private static void onReloadStart(MinecraftServer server, class_6860 resourceManager) {
        try {
            if (Main.modDisabled()) {
                return;
            }
            if (!Main.isLogicalSide()) {
                return;
            }
            Main.reloadStart();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onReloadEnd(MinecraftServer server, class_6860 resourceManager, boolean success) {
        try {
            if (Main.modDisabled()) {
                return;
            }
            if (!Main.isLogicalSide()) {
                return;
            }
            Main.reloadEnd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onPlayerJoin(class_3222 player) {
        if (PlayerUtils.isFakePlayer((class_1297)player)) {
            return;
        }
        try {
            Events.playerStartJoining(player);
            if (Main.modDisabled()) {
                return;
            }
            Main.currentSeason.onPlayerJoin(player);
            Main.currentSeason.onUpdatedInventory(player);
            SessionTranscript.playerJoin(player);
            MorphManager.onPlayerJoin(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onPlayerFinishJoining(class_3222 player) {
        if (PlayerUtils.isFakePlayer((class_1297)player) || Main.modDisabled()) {
            return;
        }
        try {
            UpdateChecker.onPlayerJoin(player);
            Main.currentSeason.onPlayerFinishJoining(player);
            TaskScheduler.scheduleTask(10, () -> {
                NetworkHandlerServer.tryKickFailedHandshake(player);
                PlayerUtils.resendCommandTree(player);
            });
            MorphManager.onPlayerDisconnect(player);
            MorphManager.syncToPlayer((class_1657)player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onPlayerDisconnect(class_3222 player) {
        if (Main.modDisabled()) {
            return;
        }
        if (PlayerUtils.isFakePlayer((class_1297)player)) {
            return;
        }
        try {
            Main.currentSeason.onPlayerDisconnect(player);
            SessionTranscript.playerLeave(player);
            NetworkHandlerServer.preLoginHandshake.remove(player.method_5667());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onServerStopping(MinecraftServer server) {
        try {
            UpdateChecker.shutdownExecutor();
            if (Main.modDisabled()) {
                return;
            }
            Main.currentSession.sessionEnd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onServerStarting(MinecraftServer server) {
        Main.server = server;
    }

    private static void onServerStart(MinecraftServer server) {
        try {
            Main.server = server;
            DatapackManager.onServerStarted(server);
            if (Main.modDisabled()) {
                return;
            }
            Main.currentSeason.initialize();
            Main.blacklist.reloadBlacklist();
            if (Main.currentSeason.getSeason() == Seasons.DOUBLE_LIFE) {
                ((DoubleLife)Main.currentSeason).loadSoulmates();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onServerTickEnd(MinecraftServer server) {
        try {
            skipNextTickReload = false;
            if (!Main.isLogicalSide()) {
                return;
            }
            Events.checkPlayerFinishJoiningTick();
            if (Main.modDisabled()) {
                return;
            }
            if (updatePlayerListsNextTick) {
                updatePlayerListsNextTick = false;
                PlayerUtils.updatePlayerLists();
            }
            if (Main.currentSession != null) {
                Main.currentSession.tick(server);
            }
            if (server.method_54833().method_54754()) {
                return;
            }
            if (Main.currentSession != null) {
                Main.currentSeason.tick(server);
            }
            PlayerUtils.onTick();
            if (NetworkHandlerServer.updatedConfigThisTick) {
                NetworkHandlerServer.onUpdatedConfig();
            }
            AdvancedDeathsManager.tick();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onEntityDeath(class_1309 entity, class_1282 source) {
        if (Main.modDisabled()) {
            return;
        }
        if (PlayerUtils.isFakePlayer((class_1297)entity)) {
            return;
        }
        try {
            if (!Main.isLogicalSide()) {
                return;
            }
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                Events.onPlayerDeath(player, source);
                return;
            }
            Main.currentSeason.onMobDeath(entity, source);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onEntityDropItems(class_1309 entity, class_1282 source) {
        if (PlayerUtils.isFakePlayer((class_1297)entity)) {
            return;
        }
        try {
            if (!Main.isLogicalSide()) {
                return;
            }
            Main.currentSeason.onEntityDropItems(entity, source);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onPlayerDeath(class_3222 player, class_1282 source) {
        if (Events.isExcludedPlayer((class_1297)player)) {
            return;
        }
        try {
            if (!Main.isLogicalSide()) {
                return;
            }
            Main.currentSeason.onPlayerDeath(player, source);
            AdvancedDeathsManager.onPlayerDeath(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class_1269 onBlockUse(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (Main.modDisabled()) {
            return class_1269.field_5811;
        }
        if (PlayerUtils.isFakePlayer((class_1297)player)) {
            return class_1269.field_5811;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                if (Main.isLogicalSide()) {
                    try {
                        if (Main.currentSeason instanceof SecretLife) {
                            TaskManager.onBlockUse(serverPlayer, serverLevel, hitResult);
                        }
                        if (Main.blacklist == null) {
                            return class_1269.field_5811;
                        }
                        return Main.blacklist.onBlockUse(serverPlayer, (class_1937)serverLevel, hand, hitResult);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return class_1269.field_5811;
                    }
                }
            }
        }
        return class_1269.field_5811;
    }

    public static class_1269 onItemUse(class_1657 player, class_1937 level, class_1268 hand) {
        if (PlayerUtils.isFakePlayer((class_1297)player) || Main.modDisabled()) {
            return class_1269.field_5811;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                if (Main.isLogicalSide()) {
                    try {
                        class_1799 itemStack = player.method_5998(hand);
                        if (itemStack.method_31574(class_1802.field_8639) && ItemStackUtils.hasCustomComponentEntry(PlayerUtils.getEquipmentSlot((class_1657)serverPlayer, 3), "FlightSuperpower") && !class_1309.method_63624((class_1799)serverPlayer.method_6118(class_1304.field_6174), (class_1304)class_1304.field_6174) && !class_1309.method_63624((class_1799)serverPlayer.method_6118(class_1304.field_6172), (class_1304)class_1304.field_6172) && !class_1309.method_63624((class_1799)serverPlayer.method_6118(class_1304.field_6166), (class_1304)class_1304.field_6166)) {
                            return class_1269.field_5814;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return class_1269.field_5811;
                    }
                }
            }
        }
        return class_1269.field_5811;
    }

    public static class_1269 onBlockAttack(class_3222 player, class_1937 level, class_2338 pos) {
        if (PlayerUtils.isFakePlayer((class_1297)player)) {
            return class_1269.field_5811;
        }
        try {
            if (!Main.isLogicalSide()) {
                return class_1269.field_5811;
            }
            if (Main.blacklist == null) {
                return class_1269.field_5811;
            }
            if (level.method_8608()) {
                return class_1269.field_5811;
            }
            return Main.blacklist.onBlockAttack(player, level, pos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return class_1269.field_5811;
        }
    }

    private static class_1269 onRightClickEntity(class_1657 player, class_1937 level, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        if (PlayerUtils.isFakePlayer((class_1297)player) || Main.modDisabled()) {
            return class_1269.field_5811;
        }
        try {
            if (!Main.isLogicalSide()) {
                return class_1269.field_5811;
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                Main.currentSeason.onRightClickEntity(serverPlayer, level, hand, entity, hitResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return class_1269.field_5811;
    }

    private static class_1269 onAttackEntity(class_1657 player, class_1937 level, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        if (PlayerUtils.isFakePlayer((class_1297)player) || Main.modDisabled()) {
            return class_1269.field_5811;
        }
        try {
            if (!Main.isLogicalSide()) {
                return class_1269.field_5811;
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                Main.currentSeason.onAttackEntity(serverPlayer, level, hand, entity, hitResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return class_1269.field_5811;
    }

    public static void playerStartJoining(class_3222 player) {
        NetworkHandlerServer.sendHandshake(player);
        NetworkHandlerServer.sendUpdatePacketTo(player);
        SnailSkins.sendTexturesTo(player);
        if (!joiningPlayers.contains(player.method_5667())) {
            joiningPlayers.add(player.method_5667());
        }
        joiningPlayersPos.put(player.method_5667(), player.method_19538());
        joiningPlayersYaw.put(player.method_5667(), Float.valueOf(player.method_36454()));
        joiningPlayersPitch.put(player.method_5667(), Float.valueOf(player.method_36455()));
    }

    public static void checkPlayerFinishJoiningTick() {
        class_3222 player;
        UUID uuid;
        for (Map.Entry<UUID, class_243> entry : joiningPlayersPos.entrySet()) {
            uuid = entry.getKey();
            player = PlayerUtils.getPlayer(uuid);
            if (player == null || player.method_19538().equals((Object)entry.getValue())) continue;
            Events.onPlayerFinishJoining(player);
            Events.finishedJoining(player.method_5667());
            return;
        }
        for (Map.Entry<UUID, Object> entry : joiningPlayersYaw.entrySet()) {
            uuid = entry.getKey();
            player = PlayerUtils.getPlayer(uuid);
            if (player == null || player.method_36454() == ((Float)entry.getValue()).floatValue()) continue;
            Events.onPlayerFinishJoining(player);
            Events.finishedJoining(player.method_5667());
            return;
        }
        for (Map.Entry<UUID, Object> entry : joiningPlayersPitch.entrySet()) {
            uuid = entry.getKey();
            player = PlayerUtils.getPlayer(uuid);
            if (player == null || player.method_36455() == ((Float)entry.getValue()).floatValue()) continue;
            Events.onPlayerFinishJoining(player);
            Events.finishedJoining(player.method_5667());
            return;
        }
    }

    public static void finishedJoining(UUID uuid) {
        joiningPlayers.remove(uuid);
        joiningPlayersPos.remove(uuid);
        joiningPlayersYaw.remove(uuid);
        joiningPlayersPitch.remove(uuid);
    }

    public static boolean isExcludedPlayer(class_1297 entity) {
        class_3222 player;
        if (entity instanceof class_3222 && (player = (class_3222)entity).ls$isWatcher()) {
            return true;
        }
        return PlayerUtils.isFakePlayer(entity);
    }
}

