/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_10124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9335;

public class Hunger
extends Wildcard {
    private static final Random rnd = new Random();
    public static int SWITCH_DELAY = 36000;
    public static int shuffleVersion = 0;
    private static boolean shuffledBefore = false;
    private static int lastVersion = -1;
    private static long ticks = 0L;
    public static int HUNGER_EFFECT_LEVEL = 3;
    public static double EFFECT_CHANCE = 0.65;
    public static int AVG_EFFECT_DURATION = 10;
    public static double NUTRITION_CHANCE = 0.4;
    public static double SATURATION_CHANCE = 0.5;
    public static double SOUND_CHANCE = 0.01;
    private static final List<class_6880<class_1291>> effects = List.of(class_1294.field_5904, class_1294.field_5909, class_1294.field_5917, class_1294.field_5901, class_1294.field_5910, class_1294.field_5915, class_1294.field_5921, class_1294.field_5913, class_1294.field_5916, class_1294.field_5907, class_1294.field_5924, class_1294.field_5918, class_1294.field_5923, class_1294.field_5905, class_1294.field_5919, class_1294.field_5925, class_1294.field_5911, class_1294.field_5899, class_1294.field_5920, class_1294.field_5914, class_1294.field_5898, class_1294.field_5922, class_1294.field_5912, class_1294.field_5902, class_1294.field_5926, class_1294.field_5908, class_1294.field_5906, class_1294.field_5927, class_1294.field_5900, class_1294.field_18980, class_1294.field_38092, class_1294.field_50118, class_1294.field_50119, class_1294.field_50120, class_1294.field_50121);
    private static final List<class_6880<class_1291>> levelLimit = List.of(class_1294.field_5910, class_1294.field_5915, class_1294.field_5921, class_1294.field_5907, class_1294.field_5924, class_1294.field_5920, class_1294.field_5898, class_1294.field_5922);
    private static final List<class_6880<class_1291>> durationLimit = List.of(class_1294.field_5915, class_1294.field_5921, class_1294.field_5922);
    public static final List<class_1792> commonItems = Arrays.asList(class_1802.field_8831, class_1802.field_20391, class_1802.field_20412, class_1802.field_8110, class_1802.field_8858, class_1802.field_8328, class_1802.field_8583, class_1802.field_8684, class_1802.field_8170, class_1802.field_8125, class_1802.field_8820, class_1802.field_8652, class_1802.field_37512, class_1802.field_42692, class_1802.field_21981, class_1802.field_21982, class_1802.field_17503, class_1802.field_17504, class_1802.field_17505, class_1802.field_17506, class_1802.field_17507, class_1802.field_17508, class_1802.field_37511, class_1802.field_42694, class_1802.field_8182, class_1802.field_22008, class_1802.field_8118, class_1802.field_8113, class_1802.field_8191, class_1802.field_8842, class_1802.field_8651, class_1802.field_8404, class_1802.field_37507, class_1802.field_42687, class_1802.field_22489, class_1802.field_22490, class_1802.field_8780, class_1802.field_8048, class_1802.field_8174, class_1802.field_8887, class_1802.field_8605, class_1802.field_8531, class_1802.field_37530, class_1802.field_42701, class_1802.field_22004, class_1802.field_22005, class_1802.field_42696, class_1802.field_8675, class_1802.field_8397, class_1802.field_8600, class_1802.field_8276, class_1802.field_8324, class_1802.field_8270, class_1802.field_8460, class_1802.field_8246, class_1802.field_28866, class_1802.field_27020, class_1802.field_27021, class_1802.field_20407, class_1802.field_20401, class_1802.field_20394, class_1802.field_22000, class_1802.field_23843, class_1802.field_20399, class_1802.field_8067, class_1802.field_21999, class_1802.field_22013, class_1802.field_22015, class_1802.field_17520, class_1802.field_17498, class_1802.field_17532, class_1802.field_17533, class_1802.field_8317);
    public static List<String> nonEdibleStr = new ArrayList<String>();
    public static List<class_1792> nonEdible = new ArrayList<class_1792>();
    public static final List<class_1792> bannedFoodItems = List.of(class_1802.field_8162, class_1802.field_8634, class_1802.field_49098, class_1802.field_8463, class_1802.field_8367);

    @Override
    public Wildcards getType() {
        return Wildcards.HUNGER;
    }

    @Override
    public void tick() {
        int currentVersion;
        if ((Main.currentSession.sessionLength == null || (double)Main.currentSession.sessionLength.intValue() - Main.currentSession.passedTime > 6000.0) && lastVersion != (currentVersion = (int)Math.floor(Main.currentSession.passedTime / (double)SWITCH_DELAY))) {
            lastVersion = currentVersion;
            this.newFoodRules();
        }
        if (++ticks % 20L == 0L) {
            for (class_3222 player : PlayerUtils.getAllFunctioningPlayers()) {
                if (player.method_6059(class_1294.field_5903)) continue;
                Hunger.addHunger(player);
            }
        }
    }

    @Override
    public void deactivate() {
        shuffledBefore = false;
        TaskScheduler.scheduleTask(1, OtherUtils::reloadServerNoUpdate);
        TaskScheduler.scheduleTask(10, Hunger::updateInventories);
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            player.method_6016(class_1294.field_5903);
        }
        super.deactivate();
    }

    @Override
    public void activate() {
        TaskScheduler.scheduleTask(100, () -> {
            shuffleVersion = rnd.nextInt(0, 100);
            shuffledBefore = false;
            lastVersion = -1;
            super.activate();
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void newNonEdibleItems(String raw) {
        raw = raw.replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "");
        nonEdible = new ArrayList<class_1792>();
        nonEdibleStr = new ArrayList<String>();
        if (!raw.isEmpty()) {
            nonEdibleStr = new ArrayList<String>(Arrays.asList(raw.split(",")));
        }
        for (String string : nonEdibleStr) {
            void var2_2;
            if (!string.contains(":")) {
                String string2 = "minecraft:" + string;
            }
            try {
                class_2960 id = IdentifierHelper.parse((String)var2_2);
                class_5321 key = class_5321.method_29179((class_5321)class_7923.field_41178.method_46765(), (class_2960)id);
                class_1792 item = (class_1792)class_7923.field_41178.method_29107(key);
                if (item != null) {
                    nonEdible.add(item);
                    continue;
                }
                OtherUtils.throwError("[CONFIG] Invalid item: " + (String)var2_2);
            }
            catch (Exception e) {
                OtherUtils.throwError("[CONFIG] Error parsing item ID: " + (String)var2_2);
            }
        }
        NetworkHandlerServer.sendUpdatePackets();
        TaskScheduler.scheduleTask(1, OtherUtils::reloadServerNoUpdate);
        TaskScheduler.scheduleTask(5, Hunger::updateInventories);
    }

    public void newFoodRules() {
        List<class_3222> players = PlayerUtils.getAllFunctioningPlayers();
        SessionTranscript.newHungerRule();
        if (shuffledBefore) {
            PlayerUtils.playSoundToPlayers(players, (class_3414)class_3417.field_14622.comp_349());
            PlayerUtils.sendTitleWithSubtitleToPlayers(players, (class_2561)class_2561.method_43473(), class_2561.method_30163((String)"\u00a77Food is about to be randomised..."), 0, 140, 0);
            TaskScheduler.scheduleTask(40, WildcardManager::showDots);
            TaskScheduler.scheduleTask(140, () -> {
                Hunger.addHunger();
                Hunger.updateInventories();
                PlayerUtils.playSoundToPlayers(players, class_3417.field_15203, 0.2f, 1.0f);
                ++shuffleVersion;
            });
        } else {
            TaskScheduler.scheduleTask(10, Hunger::updateInventories);
            ++shuffleVersion;
        }
        shuffledBefore = true;
        Hunger.addHunger();
        TaskScheduler.scheduleTask(1, OtherUtils::reloadServerNoUpdate);
        NetworkHandlerServer.sendUpdatePackets();
    }

    public static void updateInventories() {
        PlayerUtils.getAllFunctioningPlayers().forEach(Hunger::updateInventory);
    }

    public static void updateInventory(class_3222 player) {
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            stack.method_57379(class_9334.field_50075, (Object)((class_4174)stack.method_58658().method_57829(class_9334.field_50075)));
            stack.method_57379(class_9334.field_53964, (Object)((class_10124)stack.method_58658().method_57829(class_9334.field_53964)));
            class_9326 changes = stack.method_57380();
            class_1799 newItem = new class_1799((class_1935)stack.method_7909(), stack.method_7947());
            newItem.method_59692(changes);
            inventory.method_5447(i, newItem);
        }
        PlayerUtils.updatePlayerInventory(player);
    }

    public static void addHunger() {
        PlayerUtils.getAllFunctioningPlayers().forEach(Hunger::addHunger);
    }

    public static void addHunger(class_3222 player) {
        if (player == null) {
            return;
        }
        if (player.method_7325()) {
            return;
        }
        if (HUNGER_EFFECT_LEVEL <= 0) {
            return;
        }
        class_1293 statusEffectInstance = new class_1293(class_1294.field_5903, -1, HUNGER_EFFECT_LEVEL - 1, false, false, false);
        player.method_6092(statusEffectInstance);
    }

    public static void onUseItem(class_3222 player) {
        if (!player.method_6059(class_1294.field_5903) && WildcardManager.isActiveWildcard(Wildcards.HUNGER)) {
            Hunger.addHunger(player);
        }
    }

    public static void defaultFoodComponents(class_1792 item, class_9335 components) {
        if (item == null) {
            return;
        }
        if (bannedFoodItems.contains(item)) {
            return;
        }
        components.method_57938(class_9334.field_53964, (Object)new class_10124(1.6f, class_1839.field_8950, (class_6880)class_3417.field_20614, true, List.of()));
        components.method_57938(class_9334.field_50075, (Object)new class_4174(0, 0.0f, false));
    }

    public static void finishUsing(class_1792 item, class_9323 normalComponents, class_1309 entity) {
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        if (item == null) {
            return;
        }
        if (bannedFoodItems.contains(item)) {
            return;
        }
        if (nonEdible.contains(item)) {
            return;
        }
        int nutrition = 0;
        int saturation = 0;
        class_1293 effect = null;
        if (normalComponents.method_57832(class_9334.field_50075)) {
            effect = new class_1293(class_1294.field_5903, 3600, 7, false, false, false);
        } else {
            int hash = Hunger.getHash(item);
            Random random = new Random(hash);
            if (random.nextDouble() < EFFECT_CHANCE) {
                int amplifier = random.nextInt(5);
                int duration = (int)Math.ceil((double)((random.nextInt(20) + 1) * AVG_EFFECT_DURATION) / 10.0);
                class_6880<class_1291> registryEntryEffect = effects.get(random.nextInt(effects.size()));
                if (levelLimit.contains(registryEntryEffect) || commonItems.contains(item)) {
                    amplifier = 0;
                }
                if (durationLimit.contains(registryEntryEffect)) {
                    duration = 1;
                }
                effect = new class_1293(registryEntryEffect, duration * 20, amplifier);
            }
            if (!commonItems.contains(item)) {
                if (random.nextDouble() < NUTRITION_CHANCE) {
                    nutrition = random.nextInt(8) + 1;
                }
                if (random.nextDouble() < SATURATION_CHANCE && (saturation = random.nextInt(4) + 1) > nutrition) {
                    saturation = nutrition;
                }
            }
            if (!commonItems.contains(item) && random.nextDouble() < SOUND_CHANCE) {
                ArrayList<class_3414> allSounds = new ArrayList<class_3414>();
                for (class_3414 sound : class_7923.field_41172.method_10220().toList()) {
                    if (!sound.comp_3319().method_12832().startsWith("entity.")) continue;
                    allSounds.add(sound);
                }
                if (!allSounds.isEmpty()) {
                    class_3414 sound = (class_3414)allSounds.get(random.nextInt(allSounds.size()));
                    PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 0.5f, 1.0f);
                }
            }
        }
        player.method_7344().method_7585(nutrition, (float)saturation);
        if (effect != null) {
            player.method_6092(effect);
        }
    }

    private static int getHash(class_1792 item) {
        String itemId = class_7923.field_41178.method_10221((Object)item).toString();
        return Math.abs((itemId.hashCode() + shuffleVersion) * 31);
    }
}

