/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.render;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.events.ClientKeybinds;
import net.mat0u5.lifeseries.features.Trivia;
import net.mat0u5.lifeseries.render.ClientRenderer;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.enums.SessionTimerStates;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class TextHud {
    public static long lastSessionSeconds = 0L;
    public static boolean sessionSecondChanged = false;
    private static long limitedLifeTime = -1L;
    private static long lastPressed = 0L;

    public static void renderText(class_332 context) {
        class_310 client = class_310.method_1551();
        if (client.field_1690.field_1842) {
            return;
        }
        int n = client.method_22683().method_4502() - 5;
        Objects.requireNonNull(client.field_1772);
        int yPos = n - 9;
        yPos += TextHud.renderGameNotBroken(client, context, yPos);
        yPos += TextHud.renderSessionTimer(client, context, yPos);
        yPos += TextHud.renderLimitedLifeTimer(client, context, yPos);
        yPos += TextHud.renderMimicryTimer(client, context, yPos);
        yPos += TextHud.renderSuperpowerCooldown(client, context, yPos);
        yPos += TextHud.renderTriviaTimer(client, context, yPos);
    }

    public static int _renderSnailDistance(class_310 client, class_332 context, int y) {
        try {
            if (MainClient.snailPos == null) {
                return 0;
            }
            if (System.currentTimeMillis() - MainClient.snailPosTime > 2000L) {
                return 0;
            }
            if (client.field_1724 == null) {
                return 0;
            }
            float distance = (float)client.field_1724.method_19538().method_1022(MainClient.snailPos.method_46558());
            class_5250 timerText = class_2561.method_43470((String)String.valueOf(Math.round(distance)));
            if (distance < 20.0f) {
                timerText = class_2561.method_43470((String)("\u00a7c" + Math.round(distance)));
            }
            int screenWidth = client.method_22683().method_4486();
            int x = screenWidth - 5;
            RenderUtils.drawTextRight(context, client.field_1772, (class_2561)timerText, x, y);
            Objects.requireNonNull(client.field_1772);
            return -9 - 5;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int renderGameNotBroken(class_310 client, class_332 context, int y) {
        if (client.field_1724 == null) {
            return 0;
        }
        if (!ClientRenderer.isGameFullyFrozen) {
            return 0;
        }
        long currentMillis = System.currentTimeMillis();
        int guiScale = (Integer)client.field_1690.method_42474().method_41753();
        if (guiScale <= 3 && guiScale != 0) {
            Object textString = "Don't worry, the game is not broken ";
            textString = currentMillis % 1500L <= 750L ? "\u00a77\u00a7n" + (String)textString : "\u00a77" + (String)textString;
            textString = currentMillis % 500L <= 250L ? (String)textString + "/o/" : (String)textString + "\\o\\";
            class_5250 text = class_2561.method_43470((String)textString);
            int screenWidth = client.method_22683().method_4486();
            int x = screenWidth - 5;
            RenderUtils.drawTextRight(context, client.field_1772, (class_2561)text, x, y);
            Objects.requireNonNull(client.field_1772);
            return -9 - 10;
        }
        Object textString0 = "Don't worry,";
        Object textString1 = "the game isn't broken ";
        if (currentMillis % 1500L <= 750L) {
            textString0 = "\u00a77\u00a7n" + (String)textString0;
            textString1 = "\u00a77\u00a7n" + (String)textString1;
        } else {
            textString0 = "\u00a77" + (String)textString0;
            textString1 = "\u00a77" + (String)textString1;
        }
        textString1 = currentMillis % 500L <= 250L ? (String)textString1 + "/o/" : (String)textString1 + "\\o\\";
        class_5250 text0 = class_2561.method_43470((String)textString0);
        class_5250 text1 = class_2561.method_43470((String)textString1);
        int screenWidth = client.method_22683().method_4486();
        int x = screenWidth - 5;
        RenderUtils.drawTextRight(context, client.field_1772, (class_2561)text1, x, y);
        class_327 class_3272 = client.field_1772;
        int n = x - (client.field_1772.method_27525((class_5348)text1) - client.field_1772.method_27525((class_5348)text0)) / 2;
        Objects.requireNonNull(client.field_1772);
        RenderUtils.drawTextRight(context, class_3272, (class_2561)text0, n, y - (9 + 1));
        Objects.requireNonNull(client.field_1772);
        return -9 * 2 - 15;
    }

    public static int renderSessionTimer(class_310 client, class_332 context, int y) {
        if (!MainClient.SESSION_TIMER) {
            return 0;
        }
        if (System.currentTimeMillis() - MainClient.sessionTimeLastUpdated > 15000L) {
            return 0;
        }
        if (MainClient.sessionTime == (long)SessionTimerStates.OFF.getValue()) {
            return 0;
        }
        class_5250 timerText = class_2561.method_43473();
        if (MainClient.sessionTime == (long)SessionTimerStates.ENDED.getValue()) {
            timerText = timerText.method_10852(class_2561.method_30163((String)"\u00a77Session has ended"));
        } else if (MainClient.sessionTime == (long)SessionTimerStates.PAUSED.getValue()) {
            timerText = timerText.method_10852(class_2561.method_30163((String)"\u00a77Session has been paused"));
        } else if (MainClient.sessionTime == (long)SessionTimerStates.NOT_STARTED.getValue()) {
            timerText = timerText.method_10852(class_2561.method_30163((String)"\u00a77Session has not started"));
        } else {
            long remainingTime = TextHud.roundTime(MainClient.sessionTime) - System.currentTimeMillis();
            long seconds = remainingTime / 1000L;
            if (lastSessionSeconds != seconds) {
                lastSessionSeconds = seconds;
                sessionSecondChanged = true;
            } else {
                sessionSecondChanged = false;
            }
            timerText = remainingTime < 0L ? timerText.method_10852(class_2561.method_30163((String)"\u00a77Session has ended")) : timerText.method_10852((class_2561)TextUtils.formatLoosely("\u00a77Session {}", OtherUtils.formatTimeMillis(remainingTime)));
        }
        int screenWidth = client.method_22683().method_4486();
        int x = screenWidth - 5;
        RenderUtils.drawTextRight(context, client.field_1772, (class_2561)timerText, x, y);
        Objects.requireNonNull(client.field_1772);
        return -9 - 5;
    }

    public static int renderLimitedLifeTimer(class_310 client, class_332 context, int y) {
        long remainingTime;
        if (MainClient.clientCurrentSeason != Seasons.LIMITED_LIFE) {
            return 0;
        }
        if (System.currentTimeMillis() - MainClient.limitedLifeTimeLastUpdated > 15000L) {
            return 0;
        }
        class_5250 timerText = class_2561.method_43473();
        if (sessionSecondChanged || MainClient.sessionTime <= 0L) {
            limitedLifeTime = MainClient.limitedLifeLives;
        }
        timerText = limitedLifeTime == -1L ? timerText.method_10852((class_2561)TextUtils.formatLoosely("{}0:00:00", MainClient.limitedLifeTimerColor)) : ((remainingTime = limitedLifeTime * 1000L) < 0L ? timerText.method_10852((class_2561)TextUtils.formatLoosely("{}0:00:00", MainClient.limitedLifeTimerColor)) : timerText.method_10852(class_2561.method_30163((String)(MainClient.limitedLifeTimerColor + OtherUtils.formatTimeMillis(remainingTime)))));
        int screenWidth = client.method_22683().method_4486();
        int x = screenWidth - 5;
        RenderUtils.drawTextRight(context, client.field_1772, (class_2561)timerText, x, y);
        Objects.requireNonNull(client.field_1772);
        return -9 - 5;
    }

    public static int renderTriviaTimer(class_310 client, class_332 context, int y) {
        if (!Trivia.isDoingTrivia()) {
            return 0;
        }
        if (client.field_1755 != null) {
            return 0;
        }
        long millisLeft = TextHud.roundTime(Trivia.getEndTimestamp()) - System.currentTimeMillis();
        class_2561 actualTimer = class_2561.method_30163((String)OtherUtils.formatTimeMillis(millisLeft));
        class_2561 timerText = class_2561.method_30163((String)"\u00a77Trivia timer: ");
        int screenWidth = client.method_22683().method_4486();
        int x = screenWidth - 5;
        if (millisLeft <= 5000L) {
            RenderUtils.drawTextRight(context, client.field_1772, TextColors.RED, actualTimer, x, y);
        } else if (millisLeft <= 30000L) {
            RenderUtils.drawTextRight(context, client.field_1772, TextColors.ORANGE, actualTimer, x, y);
        } else {
            RenderUtils.drawTextRight(context, client.field_1772, TextColors.WHITE, actualTimer, x, y);
        }
        RenderUtils.drawTextRight(context, client.field_1772, timerText, x - client.field_1772.method_27525((class_5348)actualTimer), y);
        Objects.requireNonNull(client.field_1772);
        return -9 - 5;
    }

    public static int renderSuperpowerCooldown(class_310 client, class_332 context, int y) {
        boolean keyPressed;
        if (ClientKeybinds.superpower != null && ClientKeybinds.superpower.method_1434()) {
            lastPressed = System.currentTimeMillis();
        }
        if (MainClient.SUPERPOWER_COOLDOWN_TIMESTAMP == 0L) {
            return 0;
        }
        long currentMillis = System.currentTimeMillis();
        if (currentMillis >= MainClient.SUPERPOWER_COOLDOWN_TIMESTAMP) {
            return 0;
        }
        long millisLeft = TextHud.roundTime(MainClient.SUPERPOWER_COOLDOWN_TIMESTAMP) - currentMillis;
        if (millisLeft > 10000000L) {
            return 0;
        }
        long pressedAgo = System.currentTimeMillis() - lastPressed;
        boolean bl = keyPressed = pressedAgo < 500L;
        if (pressedAgo > 6000L) {
            return 0;
        }
        class_5250 timerText = TextUtils.formatLoosely("{}Superpower cooldown:\u00a7f {}", keyPressed ? "\u00a7c\u00a7n" : "\u00a77", OtherUtils.formatTimeMillis(millisLeft));
        int screenWidth = client.method_22683().method_4486();
        int x = screenWidth - 5;
        RenderUtils.drawTextRight(context, client.field_1772, (class_2561)timerText, x, y);
        Objects.requireNonNull(client.field_1772);
        return -9 - 5;
    }

    public static int renderMimicryTimer(class_310 client, class_332 context, int y) {
        if (MainClient.MIMICRY_COOLDOWN_TIMESTAMP == 0L) {
            return 0;
        }
        long currentMillis = System.currentTimeMillis();
        if (currentMillis >= MainClient.MIMICRY_COOLDOWN_TIMESTAMP) {
            return 0;
        }
        long millisLeft = TextHud.roundTime(MainClient.MIMICRY_COOLDOWN_TIMESTAMP) - currentMillis;
        if (millisLeft > 10000000L) {
            return 0;
        }
        class_5250 timerText = TextUtils.formatLoosely("\u00a77Mimic power cooldown: \u00a7f{}", OtherUtils.formatTimeMillis(millisLeft));
        int screenWidth = client.method_22683().method_4486();
        int x = screenWidth - 5;
        RenderUtils.drawTextRight(context, client.field_1772, (class_2561)timerText, x, y);
        Objects.requireNonNull(client.field_1772);
        return -9 - 5;
    }

    public static long roundTime(long time) {
        return time - time % 1000L;
    }
}

