/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.boogeyman.advanceddeaths;

import java.util.UUID;
import net.mat0u5.lifeseries.seasons.boogeyman.advanceddeaths.AdvancedDeaths;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1282;
import net.minecraft.class_3222;

public abstract class AdvancedDeath {
    protected UUID playerUUID;
    protected boolean started = false;
    protected boolean finished = false;
    protected long ticks = -100L;

    public AdvancedDeath(class_3222 player) {
        this.playerUUID = player.method_5667();
    }

    protected abstract AdvancedDeaths getDeathType();

    protected abstract void tick(class_3222 var1);

    protected abstract void begin(class_3222 var1);

    protected abstract void end();

    protected abstract int maxTime();

    protected abstract class_1282 damageSource(class_3222 var1);

    public class_3222 getPlayer() {
        return PlayerUtils.getPlayer(this.playerUUID);
    }

    public void onTick() {
        if (this.playerNotFound()) {
            return;
        }
        class_3222 player = this.getPlayer();
        ++this.ticks;
        if (this.ticks >= (long)this.maxTime()) {
            this.ranOutOfTime(player);
            this.onEnd();
            return;
        }
        if (this.ticks >= 0L) {
            if (!this.started) {
                this.started = true;
                this.begin(player);
            }
            this.tick(player);
        }
    }

    public boolean playerNotFound() {
        class_3222 player = this.getPlayer();
        return player == null || !player.method_5805();
    }

    public void onEnd() {
        this.finished = true;
        this.end();
    }

    public void ranOutOfTime(class_3222 player) {
        PlayerUtils.killFromSource(player, this.damageSource(player));
    }

    public boolean isFinished() {
        return this.finished;
    }
}

