/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.lastlife;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.other.LivesManager;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.seasons.season.lastlife.LastLife;
import net.mat0u5.lifeseries.seasons.session.SessionAction;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;

public class LastLifeLivesManager
extends LivesManager {
    public SessionAction actionChooseLives = new SessionAction(OtherUtils.minutesToTicks(1), "\u00a77Assign lives if necessary \u00a7f[00:01:00]", "Assign lives if necessary"){

        @Override
        public void trigger() {
            LastLifeLivesManager.this.assignRandomLivesToUnassignedPlayers();
        }
    };
    Random rnd = new Random();

    public void assignRandomLivesToUnassignedPlayers() {
        ArrayList<class_3222> assignTo = new ArrayList<class_3222>();
        for (class_3222 player : PlayerUtils.getAllFunctioningPlayers()) {
            if (Main.livesManager.hasAssignedLives(player)) continue;
            assignTo.add(player);
            PlayerUtils.broadcastMessageToAdmins((class_2561)TextUtils.format("\u00a77Assigning random lives to {}\u00a77...", player));
        }
        if (assignTo.isEmpty()) {
            return;
        }
        this.assignRandomLives(assignTo);
    }

    public void assignRandomLives(Collection<class_3222> players) {
        HashMap<class_3222, Integer> lives = new HashMap<class_3222, Integer>();
        for (class_3222 player : players) {
            if (WatcherManager.isWatcher((class_1657)player) || lives.containsKey(player)) continue;
            lives.put(player, -1);
        }
        PlayerUtils.sendTitleToPlayers(players, (class_2561)class_2561.method_43470((String)"You will have...").method_27692(class_124.field_1080), 10, 40, 10);
        int delay = 60;
        TaskScheduler.scheduleTask(delay, () -> this.lifeRoll(0, -1, lives));
    }

    public void lifeRoll(int currentStep, int lastNum, Map<class_3222, Integer> lives) {
        int displayLives;
        int delay = 1;
        if (currentStep >= 30) {
            delay = 2;
        }
        if (currentStep >= 50) {
            delay = 4;
        }
        if (currentStep >= 65) {
            delay = 8;
        }
        if (currentStep >= 75) {
            delay = 20;
        }
        if (currentStep == 80) {
            int totalSize = lives.size();
            int chosenNotRandomly = LastLife.ROLL_MIN_LIVES;
            for (class_3222 class_32222 : lives.keySet()) {
                Integer currentLives = Main.livesManager.getPlayerLives(class_32222);
                if (currentLives != null) {
                    lives.put(class_32222, currentLives);
                    continue;
                }
                int diff = LastLife.ROLL_MAX_LIVES - LastLife.ROLL_MIN_LIVES + 2;
                if (chosenNotRandomly <= LastLife.ROLL_MAX_LIVES && totalSize > diff) {
                    lives.put(class_32222, chosenNotRandomly);
                    ++chosenNotRandomly;
                    continue;
                }
                int minLives = LastLife.ROLL_MIN_LIVES;
                int maxLives = LastLife.ROLL_MAX_LIVES;
                int randomLives = this.rnd.nextInt(minLives, maxLives + 1);
                lives.put(class_32222, randomLives);
            }
            for (Map.Entry entry : lives.entrySet()) {
                Integer livesNum = (Integer)entry.getValue();
                class_3222 player = (class_3222)entry.getKey();
                class_2561 textLives = Main.livesManager.getFormattedLives(livesNum);
                PlayerUtils.sendTitle(player, textLives, 0, 25, 0);
            }
            PlayerUtils.playSoundToPlayers(lives.keySet(), (class_3414)class_3417.field_15015.comp_349());
            TaskScheduler.scheduleTask(delay, () -> this.lifeRoll(currentStep + 1, -1, lives));
            return;
        }
        if (currentStep == 81) {
            for (Map.Entry<class_3222, Integer> playerEntry : lives.entrySet()) {
                Integer livesNum = playerEntry.getValue();
                class_3222 class_32223 = playerEntry.getKey();
                class_5250 textLives = TextUtils.format("{}\u00a7a lives.", Main.livesManager.getFormattedLives(livesNum));
                PlayerUtils.sendTitle(class_32223, (class_2561)textLives, 0, 60, 20);
                if (Main.livesManager.hasAssignedLives(class_32223)) continue;
                SessionTranscript.assignRandomLives(class_32223, livesNum);
                Main.livesManager.setPlayerLives(class_32223, livesNum);
            }
            PlayerUtils.playSoundToPlayers(lives.keySet(), class_3417.field_14981);
            Main.currentSeason.reloadAllPlayerTeams();
            return;
        }
        int minLives = LastLife.ROLL_MIN_LIVES;
        int maxLives = LastLife.ROLL_MAX_LIVES;
        while ((displayLives = this.rnd.nextInt(minLives, maxLives + 1)) == lastNum && minLives != maxLives) {
        }
        int n = displayLives;
        PlayerUtils.sendTitleToPlayers(lives.keySet(), Main.livesManager.getFormattedLives(n), 0, 25, 0);
        PlayerUtils.playSoundToPlayers(lives.keySet(), (class_3414)class_3417.field_15015.comp_349());
        TaskScheduler.scheduleTask(delay, () -> this.lifeRoll(currentStep + 1, finalDisplayLives, lives));
    }
}

