/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.pastlife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Random;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.session.SessionAction;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class PastLifeCommands {
    public static Random rnd = new Random();

    public static boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.PAST_LIFE;
    }

    public static boolean checkBanned(class_2168 source) {
        if (PastLifeCommands.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is only available when playing Past Life."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pastlife").requires(source -> PastLifeCommands.isAllowed() && PermissionManager.isAdmin(source))).then(class_2170.method_9247((String)"boogeyman").executes(context -> PastLifeCommands.pickBoogeyman((class_2168)context.getSource())))).then(class_2170.method_9247((String)"society").executes(context -> PastLifeCommands.pickSociety((class_2168)context.getSource())))).then(class_2170.method_9247((String)"pickRandom").executes(context -> PastLifeCommands.pickRandom((class_2168)context.getSource()))));
    }

    public static int pickRandom(class_2168 source) {
        if (PastLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (!Main.currentSession.statusStarted()) {
            source.method_9213(class_2561.method_30163((String)"The session has not started yet"));
            return -1;
        }
        boolean bannedSociety = !Main.currentSeason.secretSociety.SOCIETY_ENABLED || Main.currentSeason.secretSociety.societyStarted || Main.currentSeason.secretSociety.societyEnded;
        boolean bannedBoogeyman = !Main.currentSeason.boogeymanManager.BOOGEYMAN_ENABLED || Main.currentSeason.boogeymanManager.boogeymanChosen;
        for (SessionAction action : Main.currentSession.getSessionActions()) {
            if (action.sessionId != null && action.sessionId.equalsIgnoreCase("Begin Secret Society")) {
                bannedSociety = true;
            }
            if (action.sessionId == null || !action.sessionId.equalsIgnoreCase("Choose Boogeymen")) continue;
            bannedBoogeyman = true;
        }
        if (bannedBoogeyman && bannedSociety) {
            source.method_9213(class_2561.method_30163((String)"Picking failed"));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Randomly picking the Boogeyman or the Secret Society..."));
        if (!bannedBoogeyman && bannedSociety) {
            Main.currentSeason.boogeymanManager.addSessionActions();
            return 1;
        }
        if (bannedBoogeyman && !bannedSociety) {
            Main.currentSeason.secretSociety.addSessionActions();
            return 1;
        }
        if (!bannedBoogeyman && !bannedSociety) {
            if (rnd.nextInt(2) == 0) {
                Main.currentSeason.boogeymanManager.addSessionActions();
            } else {
                Main.currentSeason.secretSociety.addSessionActions();
            }
            return 1;
        }
        return 1;
    }

    public static int pickSociety(class_2168 source) {
        if (PastLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (!Main.currentSession.statusStarted()) {
            source.method_9213(class_2561.method_30163((String)"The session has not started yet"));
            return -1;
        }
        if (!Main.currentSeason.secretSociety.SOCIETY_ENABLED) {
            source.method_9213(class_2561.method_30163((String)"The Secret Society is disabled in the config"));
            return -1;
        }
        if (Main.currentSeason.secretSociety.societyEnded) {
            source.method_9213(class_2561.method_30163((String)"The Secret Society has already ended"));
            return -1;
        }
        if (Main.currentSeason.secretSociety.societyStarted) {
            source.method_9213(class_2561.method_30163((String)"The Secret Society has already started"));
            return -1;
        }
        for (SessionAction action : Main.currentSession.getSessionActions()) {
            if (action.sessionId == null || !action.sessionId.equalsIgnoreCase("Begin Secret Society")) continue;
            source.method_9213(class_2561.method_30163((String)"The Secret Society is already queued"));
            return -1;
        }
        Main.currentSeason.secretSociety.addSessionActions();
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Added the Secret Society to queued session actions"));
        return 1;
    }

    public static int pickBoogeyman(class_2168 source) {
        if (PastLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (!Main.currentSession.statusStarted()) {
            source.method_9213(class_2561.method_30163((String)"The session has not started yet"));
            return -1;
        }
        if (!Main.currentSeason.boogeymanManager.BOOGEYMAN_ENABLED) {
            source.method_9213(class_2561.method_30163((String)"The Boogeyman is disabled in the config"));
            return -1;
        }
        if (Main.currentSeason.boogeymanManager.boogeymanChosen) {
            source.method_9213(class_2561.method_30163((String)"The Boogeyman has already been chosen"));
            return -1;
        }
        for (SessionAction action : Main.currentSession.getSessionActions()) {
            if (action.sessionId == null || !action.sessionId.equalsIgnoreCase("Choose Boogeymen")) continue;
            source.method_9213(class_2561.method_30163((String)"The Boogeyman is already queued"));
            return -1;
        }
        Main.currentSeason.boogeymanManager.addSessionActions();
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Added the Boogeyman to queued session actions"));
        return 1;
    }
}

