/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.secretlife;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskTypes;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9262;

public class Task {
    public String rawTask;
    public TaskTypes type;
    public boolean anyPlayers = true;
    public boolean anyGreenPlayers = true;
    public boolean anyYellowPlayers = true;

    public Task(String task, TaskTypes type) {
        this.rawTask = task;
        this.type = type;
    }

    public void checkPlayerColors(class_3222 owner) {
        this.anyGreenPlayers = Main.livesManager.anyGreenPlayers(owner);
        this.anyYellowPlayers = Main.livesManager.anyYellowPlayers(owner);
        this.anyPlayers = Main.livesManager.anyAlivePlayers(owner);
    }

    public boolean isValid(class_3222 owner) {
        if (this.rawTask == null) {
            return false;
        }
        if (this.rawTask.isEmpty()) {
            return false;
        }
        this.checkPlayerColors(owner);
        if (this.rawTask.contains("${random_player}") && !this.anyPlayers) {
            return false;
        }
        if (this.rawTask.contains("${green/yellow}") && !this.anyGreenPlayers && !this.anyYellowPlayers) {
            return false;
        }
        if (this.rawTask.contains("${green}") && !this.anyGreenPlayers) {
            return false;
        }
        return !this.rawTask.contains("${yellow}") || this.anyYellowPlayers;
    }

    public List<class_9262<class_2561>> getBookLines(class_3222 owner) {
        ArrayList<class_9262<class_2561>> lines = new ArrayList<class_9262<class_2561>>();
        for (String page : this.rawTask.split("\\\\p")) {
            page = this.formatString(owner, page);
            lines.add((class_9262<class_2561>)class_9262.method_57137((Object)class_2561.method_30163((String)page)));
        }
        return lines;
    }

    public String formatString(class_3222 owner, String page) {
        this.checkPlayerColors(owner);
        if (page.contains("${random_player}")) {
            List<class_3222> players = Main.livesManager.getAlivePlayers();
            players.remove(owner);
            if (!players.isEmpty()) {
                Collections.shuffle(players);
                page = page.replaceAll("\\$\\{random_player}", players.getFirst().method_5820());
            }
        }
        if (page.contains("${green/yellow}")) {
            if (this.anyGreenPlayers) {
                page = page.replaceAll("\\$\\{green/yellow}", "green");
            } else if (this.anyYellowPlayers) {
                page = page.replaceAll("\\$\\{green/yellow}", "yellow");
            }
        }
        if (page.contains("${green}") && this.anyGreenPlayers) {
            page = page.replaceAll("\\$\\{green}", "green");
        }
        if (page.contains("${yellow}") && this.anyYellowPlayers) {
            page = page.replaceAll("\\$\\{yellow}", "yellow");
        }
        if (page.contains("${kill_not_permitted}") && this.anyYellowPlayers) {
            page = page.replaceAll("\\$\\{kill_not_permitted}", "");
        }
        return page;
    }

    public int getDifficulty() {
        if (this.type == TaskTypes.EASY) {
            return 1;
        }
        if (this.type == TaskTypes.HARD) {
            return 2;
        }
        if (this.type == TaskTypes.RED) {
            return 3;
        }
        return 0;
    }

    public boolean killPermitted() {
        if (this.type != TaskTypes.RED) {
            return false;
        }
        return !this.rawTask.contains("${kill_not_permitted}");
    }
}

