/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.versions;

import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.utils.other.TextUtils;

public class VersionControl {
    public static boolean isDevVersion() {
        return "1.4.0-pre2".contains("dev") || "1.4.0-pre2".contains("pre");
    }

    public static int getModVersionInt(String string) {
        String originalVersion = string;
        if (string.contains("-pre")) {
            string = string.split("-pre")[0];
        }
        string = string.replaceAll("[^\\d.]", "");
        string = string.replaceAll("^\\.+|\\.+$", "");
        while (string.contains("..")) {
            string = string.replace("..", ".");
        }
        String[] parts = string.split("\\.");
        int major = 0;
        int minor = 0;
        int patch = 0;
        int build = 0;
        try {
            major = parts.length > 0 ? Integer.parseInt(parts[0]) : 0;
            minor = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            patch = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
            build = parts.length > 3 ? Integer.parseInt(parts[3]) : 0;
        }
        catch (Exception e) {
            Main.LOGGER.error(TextUtils.formatString("Failed to parse mod version to int: {} (formatted to {})", originalVersion, string));
        }
        if (originalVersion.contains("-pre")) {
            build = -100;
            try {
                build += Integer.parseInt(originalVersion.split("-pre")[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return major * 100000 + minor * 10000 + patch * 1000 + build;
    }

    public static String clientCompatibilityMin() {
        return "dev-1.3.7.27";
    }

    public static String serverCompatibilityMin() {
        return "dev-1.3.7.27";
    }
}

