/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.mixin;

import java.util.OptionalInt;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.fakeplayer.FakePlayer;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class}, priority=1)
public class ServerPlayerEntityMixin {
    @Unique
    private boolean ls$processing = false;

    @Inject(method={"openHandledScreen"}, at={@At(value="HEAD")})
    private void onInventoryOpen(@Nullable class_3908 factory, CallbackInfoReturnable<OptionalInt> cir) {
        if (!Main.isLogicalSide() || Main.modDisabled()) {
            return;
        }
        class_3222 player = this.ls$get();
        if (Main.blacklist == null) {
            return;
        }
        TaskScheduler.scheduleTask(1, () -> {
            player.field_7512.method_7602().forEach(itemStack -> Main.blacklist.processItemStack(player, (class_1799)itemStack));
            PlayerUtils.updatePlayerInventory(player);
        });
    }

    @Inject(method={"sendMessageToClient"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendMessageToClient(class_2561 message, boolean overlay, CallbackInfo ci) {
        if (Main.modFullyDisabled()) {
            return;
        }
        class_3222 player = this.ls$get();
        if (player instanceof FakePlayer) {
            ci.cancel();
        }
    }

    @Inject(method={"acceptsMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void acceptsMessage(boolean overlay, CallbackInfoReturnable<Boolean> cir) {
        if (Main.modFullyDisabled()) {
            return;
        }
        class_3222 player = this.ls$get();
        if (player instanceof FakePlayer) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"acceptsChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void acceptsChatMessage(CallbackInfoReturnable<Boolean> cir) {
        if (Main.modFullyDisabled()) {
            return;
        }
        class_3222 player = this.ls$get();
        if (player instanceof FakePlayer) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    private void onAttackEntity(class_1297 target, CallbackInfo ci) {
        if (Main.modDisabled()) {
            return;
        }
        class_3222 player = this.ls$get();
        Main.currentSeason.onUpdatedInventory(player);
    }

    @Inject(method={"onStatusEffectApplied"}, at={@At(value="TAIL")})
    private void onStatusEffectApplied(class_1293 effect, class_1297 source, CallbackInfo ci) {
        this.ls$onUpdatedEffects(effect, true);
    }

    @Inject(method={"onStatusEffectRemoved"}, at={@At(value="TAIL")})
    private void onStatusEffectRemoved(class_1293 effect, CallbackInfo ci) {
        this.ls$onUpdatedEffects(effect, false);
    }

    @Inject(method={"onStatusEffectUpgraded"}, at={@At(value="TAIL")})
    private void onStatusEffectUpgraded(class_1293 effect, boolean reapplyEffect, class_1297 source, CallbackInfo ci) {
        this.ls$onUpdatedEffects(effect, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void ls$onUpdatedEffects(class_1293 effect, boolean add) {
        if (this.ls$processing || Main.modDisabled()) {
            return;
        }
        class_3222 player = this.ls$get();
        this.ls$processing = true;
        try {
            Season season = Main.currentSeason;
            if (season instanceof DoubleLife) {
                DoubleLife doubleLife = (DoubleLife)season;
                doubleLife.syncStatusEffectsFrom(player, effect, add);
            }
        }
        finally {
            this.ls$processing = false;
        }
    }

    @Unique
    private class_3222 ls$get() {
        return (class_3222)this;
    }
}

