/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.config;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.mat0u5.lifeseries.Main;

public class StringListManager {
    private static final String DEFAULT_EASY_TASKS = "[\n\t\"Make your base deeply uncomfortable to use and look at.\",\n\t\"Collect the beds of 4 players without being caught and place them on a shrine.\",\n\t\"Convince someone to take a leap of faith and make sure they take no damage.\",\n\t\"Call people anything but their username for at least 30 minutes of the session.\",\n\t\"Make 3 bad jokes and get NO laughs.\",\n\t\"Make cherry wood your entire identity.\",\n\t\"Build an identical base to another player.\",\n\t\"Write a poem about a player and read it to them.\",\n\t\"Make a pun at every opportunity in a 5 minute conversation, minimum of 3 successful puns.\",\n\t\"Get 3 players to gift you their heart.\",\n\t\"Don't be further than 10 blocks from ${random_player} for 10 minutes. One attempt only.\",\n\t\"Build your base directly and obnoxiously attached to someone else's.\",\n\t\"Break 5 crafting tables while they are being used.\",\n\t\"Build your base directly above another players above ground.\",\n\t\"Tell a story and get someone to leave before you finish it.\",\n\t\"Don't call mobs by their real names for 30 minutes.\",\n\t\"Jumpscare another Player.\",\n\t\"Fill 4 peoples chests/inventory with light gray stained glass without being caught.\",\n\t\"Be ${random_player}'s hype man for 30 minutes of the session and don't get called out.\",\n\t\"Move 5 people's front door at least twice. You must not be called out.\",\n\t\"Every few minutes, replace a block with another in a player's base. If they notice, start again with something else. Total of 6 prominent blocks must be changed.\",\n\t\"Convince someone to burn down your house and not get called out.\",\n\t\"Get accused of doing 3 fictional secret tasks.\",\n\t\"Be best friends with ${random_player} for 15 minutes of this session and don't get called out.\",\n\t\"Send another player on a wild goose chase.\",\n\t\"Start 3 conversations with 3 different players and leave half way through without saying a word. Don't get called out.\",\n\t\"Start a cult.\",\n\t\"Get someone to say \\\"get out of here!\\\"\",\n\t\"Make a bet with another player and win.\",\n\t\"Use a Pig as your main mode of transport for at least 50% of the session.\",\n\t\"Use the words \\\"bet\\\" \\\"poggers\\\" \\\"dab\\\" \\\"yeet\\\" \\\"drip\\\"\\\"slay\\\" \\\"vibing\\\" \\\"valid\\\" \\\"rizz\\\" \\\"sheesh\\\" In the correct context over various conversations. If someone questions or repeats the words back to you, that whole conversation does not count.\",\n\t\"Deja vu: Listen into another player's conversation then try to have the same conversation with either of them later and get them to claim deja vu.\",\n\t\"Convince someone you have the same task as them.\",\n\t\"Remove all the light sources from around 5 peoples bases. If someone questions you, you need to put them back for that player.\",\n\t\"For every heart of Damage ${random_player} takes, you must take the same. You can let them in on this secret, but no one else.. If either of you die in this episode, you fail.\",\n\t\"Find any player over 25 hearts and \\\"accidentally\\\" take 5 off of them. The method is your choice. You fail if they ask if it is your task.\",\n\t\"Yes man: You can not deny any request or question from another player. You must say yes.\",\n\t\"Protect ${random_player} from losing more than 3 hearts this session.\",\n\t\"Request an item 5 times in one conversation but never pick it up. You must not be called out for it.\",\n\t\"Tell someone you love them and have them say it back unprompted. 1 Attempt per player. Total of 3 required to complete the task.\",\n\t\"Re-Bind your W key to A, S to W, D to S and A to D for 30 minutes of the session. If someone points out your weird movements, restart the timer. You must interact with other players during this time.\",\n\t\"You have an imaginary friend now. Talk to them as if they follow you round the whole session and are part of conversations. You must interact with other players during this time.\",\n\t\"Film a nature documentary on the server about 2 people who aren't you for at least 5 minutes. If anyone notices you or interrupts the film, you must stop and find someone else.\",\n\t\"Compliment people whenever you see them take damage.\",\n\t\"Ask someone what they think a good task would be, their response is your task for this session. If they don't give you an idea, you can ask someone else.\",\n\t\"Convince 3 people of a fake moment from the previous series.\",\n\t\"Nothing you say to another player can be true for the whole session.\",\n\t\"Do the opposite of what people tell you to do.\",\n\t\"You can't kill anything this session.\",\n\t\"Connect your base to everyone else's base.\",\n\t\"Bait a ${yellow} into believing your task is \\\"Singing everything you say\\\"\",\n\t\"\\\"Snitch\\\" on a ${green} name by telling a ${yellow} that they are doing a task that they really aren't. You only succeed if the yellow guesses their task incorrectly.\",\n\t\"Get a ${yellow} to accuse you of a task. Whatever they say is now your real task. They would have to guess the wording of this book to succeed in exposing the task.\",\n\t\"You are now terrified of 1 on 1 conversations. If you are in a conversation with just 1 person, you must flee in active terror.\",\n\t\"You are ${random_player}'s butler for the whole session. Do whatever they say. You have to let them in on this secret, but no one else.\",\n\t\"Always speak in the third person.\",\n\t\"Get at least 2 other players to participate in a minigame. One of them must take damage.\",\n\t\"Be actively involved in 3 conversations with ${random_player}. Mimic all their movements without being called out on it. You fail if someone points it out even once.\",\n\t\"Leave your book in other peoples bases and get someone to read it, exposing this task. Them reading this will be a success, not fail.\",\n\t\"You are the red-name's secret lackey. They must give you instructions on damage causing betrayal or trap creation and you must execute it without arousing suspicion from non-reds. You can show the reds this task, but no one else.\",\n\t\"You are a weeping angel for the entire session. If someone is looking directly at you, you must not walk, run or sneak. You can still turn and speak, but not move.\",\n\t\"Starting with wheat seeds, trade your way up to a golden apple. Minimum of 4 trades.\",\n\t\"Turn any collaborative effort into a competition. If you are called out, you can no longer compete with that player. You must win a minimum of 3 of the competitions they engage you in.\",\n\t\"Do the exact opposite of what ${green} names instruct you to do.\",\n\t\"Everytime someone takes damage, tell them much too late how it could have been avoided. If you see them about to take damage, you must warn them much too late also.\",\n\t\"Nothing you say can be true for 30 minutes. If you tell the truth, you must start again.\",\n\t\"You are ${random_player}'s terrible butler. You must do anything they say, but always get some aspect of it wrong. You can tell them you are their butler (but don't tell them about you being terrible), but not anything else.\",\n\t\"You are an imposter, you must approach any or multiple reds and secretly tell them this task. They can give you any task to damage a ${green/yellow} player. If you successfully damage 3 different ${green/yellow} names (for any amount) from their instructions, you pass. \u00a77More on next page  ->\\\\pA yellow can call you out as a traitor at any stage.\",\n\t\"You are now the therapist of the server. For the rest of the session, you must guide and give other players advice in a professional manner. The advice does not need to be good advice. You must help players to acknowledge any negative feelings. \\n\u00a77More on next page  ->\\\\pYou can not directly solve their problems, you are there only for emotional support. You fail if called out by a yellow. You can pass early if you give therapeutic advice to every other player at least once. You can only help someone if they appear down or frustrated.\",\n\t\"Everytime someone asks you to do something, you have to repeat back what they said in a high-pitched sassy voice. You pass if you are not called out by a ${yellow} after half the session.\",\n\t\"Make everyone believe you failed your task, but when you are asked what it was, you must make up something. You can not use the same fake-task twice. You fail if you are called out and pass if you successfully tell each player a fake task.\",\n\t\"Become the villain of the server. Grief. Steal. Seek server wide domination. You pass if you are actively disliked by the majority of the other players.\",\n\t\"The next mob you see (aggressive or neutral) is now your pet. You must properly take care of it by feeding it and taking it for walks. You fail if it dies or a yellow calls out your task.\",\n\t\"Pretend to be the \\\"Boogeyman\\\". Fake swing at people, place lava behind them with no intention of doing damage, etc. If at least 3 people accuse you of being the Boogeyman, you pass.\",\n\t\"You must ask other players what you can do for them in exchange for diamonds, they set the amount and the task. You succeed when you have made a total of 10 diamonds from AT LEAST 3 other players. \\n\\n\\n\u00a77More on next page  ->\\\\pYou must accept their first offer of diamonds, and can not convince them to give you more.\",\n\t\"Whenever you talk to another player you must be at least block higher than them, even if you place the block yourself. You fail if you speak to someone while on the same level or lower. You pass if you successfully do this all session.\",\n\t\"At the start of the session, announce in the chat that you are a Genie and can grant 3 wishes. Only one wish per player. You succeed if you grant 3 wishes, however you must get some part of the wish wrong (how much wrong is up to you).\",\n\t\"You are the silent server hero. You must protect other yellow and green players from traps and damage. - You succeed if you are able to save a player from significant damage (more than 2 hearts) at least 3 times.\",\n\t\"You must sabotage at least 3 red player's bases without being seen. You can hide their stuff, destroy farms or burn things. If you are caught, you fail.\",\n\t\"During this session, you must enter conversations in a creative way. You pass when you have entered 8 different conversations or encounters in a different manner. You can enter conversations as normal, but it will not count towards your goal.\",\n\t\"During this session, you must leave conversations in a creative way. You pass when you have left 8 different conversations or encounters in a different manner. You can leave conversations as normal, but it will not count towards your goal.\",\n\t\"You are a bad spy. You must listen in on red players' plans, but convey bad intel to your fellow yellow and green players. You must give at least 3 significant false intel such as incorrect targets or intentions. At least one of the bad intel must be acted upon by another player.\",\n\t\"You are a secret santa. You have to randomise who is naughty and nice on the server. You must give a gift to all nice players and pull a trick, damage or steal from naughty players. You can not do the same gift/trick twice in the session.\"\n]";
    private static final String DEFAULT_HARD_TASKS = "[\n\t\"Get the server to sleep through the night.\",\n\t\"Figure out someone's task and complete it. You can show them this task once you think you have done it and get them to confirm success.\",\n\t\"Come up with a nickname for another player and convince 2 other people to use it.\",\n\t\"Figure out someone's task and prevent them from completing it.\",\n\t\"Do a 100 block high water bucket clutch in front of the whole server.\",\n\t\"Kill the ender dragon (respawn if necessary).\",\n\t\"Summon a warden and bring it to the surface.\",\n\t\"Summon a wither.\"\n]";
    private static final String DEFAULT_RED_TASKS = "[\n\t\"${kill_not_permitted}Strike a deal with a non-red to cause at least 3 hearts of damage to another non-red. You succeed when they have dealt the damage.\",\n\t\"Create a damaging trap in someone's base. You succeed when it's unintentionally triggered. If it's discovered, you must make a new one. You can make multiple until one is triggered successfully.\",\n\t\"Go invisible and hit at least 5 different people with a sword within 1 minute without being hit back.\",\n\t\"Find a non red name with at least 20 hearts. Take approximately 10 of them in any way you see fit. If there are none, damage any player for at least 5 hearts.\",\n\t\"Cause any amount of damage to a non-red using an anvil.\",\n\t\"Use redstone to damage a non-red player. You can not hit them with the item, it must be a machine or trap of some kind.\",\n\t\"Punch another player into lava. It can be lava you have placed.\",\n\t\"Build a TNT cannon and successfully hit a base from at least 50 blocks\",\n\t\"Mine a big hole underground then spleef a player into it.\",\n\t\"Fire arrows from an unenchanted bow continuously at a player until they deflect with a shield. If they die, you also succeed. \",\n\t\"Cause a player to take suffocation damage of any kind.\",\n\t\"${kill_not_permitted}Get another player to look at an enderman.\",\n\t\"Do any amount of damage with to another player with dripstone (Must be placed by you).\",\n\t\"Add berry bushes anywhere and everywhere. Cause someone to get pricked by one. You can punch people into the bushes if you need to.\",\n\t\"Cause a player to take fall damage of over 1 heart.\",\n\t\"Build a base at close to build height to \\\"hide your valuables\\\". Wait for another player to investigate and push them off.\",\n\t\"Dig many 1x1 holes at least 15 blocks deep in high traffic areas until someone falls in one. Hide them with tall grass.\",\n\t\"Build an explosive under a high traffic area. Detonate it from afar when a conversation is happening. If you deal any damage, you succeed.\",\n\t\"You must damage a non-red by firing a bow straight up into the air. The angle can not be below roughly 70 degrees.\",\n\t\"Tame at least 5 wolves and use them to deal damage to a non-red.\",\n\t\"Enderpearl into a conversation, deal as much damage and you can to as many players, if you are hit or they all run away, enderpearl away.\",\n\t\"Kill a ${green/yellow} name by any means. They can fight back once you have initiated combat.\",\n\t\"Go invisible and punch a ${green/yellow} name off a cliff. They must take at least 3 hearts of damage.\",\n\t\"Kill a ${green/yellow} name with a trap of any kind.\",\n\t\"Summon a mob using an egg to deal any damage to any ${green/yellow}.\",\n\t\"Hit a ${green/yellow} name with a sword until they block you with a shield. If you kill them, you also succeed.\"\n]";
    private static final Gson GSON = new Gson();
    private final File file;

    public StringListManager(String folder, String file) {
        this.file = new File(folder, file);
        File folder1 = new File(folder);
        if (!folder1.exists() && !folder1.mkdirs()) {
            Main.LOGGER.error("Failed to create folder {}", (Object)folder);
            return;
        }
        if (!this.file.exists()) {
            try {
                if (!this.file.createNewFile()) {
                    Main.LOGGER.error("Failed to create file {}", (Object)this.file);
                    return;
                }
                if (file.startsWith("easy-")) {
                    this.setFileContent(DEFAULT_EASY_TASKS);
                } else if (file.startsWith("hard-")) {
                    this.setFileContent(DEFAULT_HARD_TASKS);
                } else if (file.startsWith("red-")) {
                    this.setFileContent(DEFAULT_RED_TASKS);
                }
            }
            catch (IOException ex) {
                Main.LOGGER.error(ex.getMessage());
            }
        }
    }

    private void setFileContent(String content) {
        try {
            FileWriter myWriter = new FileWriter(this.file, false);
            myWriter.write(content);
            myWriter.close();
        }
        catch (IOException e) {
            Main.LOGGER.error(e.getMessage());
        }
    }

    public List<String> loadStrings() {
        List list;
        if (!this.file.exists()) {
            return new ArrayList<String>();
        }
        FileReader reader = new FileReader(this.file);
        try {
            Type listType = new TypeToken<List<String>>(this){}.getType();
            list = (List)GSON.fromJson((Reader)reader, listType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Main.LOGGER.error(e.getMessage());
                return new ArrayList<String>();
            }
        }
        reader.close();
        return list;
    }
}

