/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.network.packets.ImagePayload;
import net.mat0u5.lifeseries.resources.ResourceHandler;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_3222;

public class SnailSkinsServer {
    public static Map<String, Integer> indexedSkins = new HashMap<String, Integer>();
    public static int currentIndex = 0;

    public static void sendImageToClient(class_3222 player, String name, int index, int maxIndex, Path imagePath) {
        try {
            BufferedImage image = ImageIO.read(Files.newInputStream(imagePath, new OpenOption[0]));
            if (image.getWidth() != 32 || image.getHeight() != 32) {
                Main.LOGGER.error("Image must be 32x32 pixels");
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", baos);
            byte[] imageBytes = baos.toByteArray();
            ImagePayload payload = new ImagePayload(name, index, maxIndex, imageBytes);
            NetworkHandlerServer.sendImagePacket(player, payload);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendStoredImages(List<class_3222> players) {
        int imageIndex;
        String replacedName;
        String name;
        if (Main.currentSeason.getSeason() != Seasons.WILD_LIFE) {
            return;
        }
        File folder = new File("./config/lifeseries/wildlife/snailskins/");
        if (!folder.exists() && !folder.mkdirs()) {
            Main.LOGGER.error("Failed to create folder {}", (Object)folder);
            return;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        int maxIndex = 0;
        for (File file : files) {
            if (!file.isFile() || (name = file.getName().toLowerCase()).equalsIgnoreCase("example.png") || !name.endsWith(".png")) continue;
            replacedName = name.toLowerCase().replaceAll(".png", "");
            if (!indexedSkins.containsKey(replacedName)) {
                indexedSkins.put(replacedName, currentIndex);
                ++currentIndex;
            }
            imageIndex = indexedSkins.get(replacedName);
            maxIndex = Math.max(maxIndex, imageIndex);
        }
        for (File file : files) {
            if (!file.isFile() || (name = file.getName().toLowerCase()).equalsIgnoreCase("example.png") || !name.endsWith(".png")) continue;
            replacedName = name.toLowerCase().replaceAll(".png", "");
            imageIndex = indexedSkins.get(replacedName);
            for (class_3222 player : players) {
                SnailSkinsServer.sendImageToClient(player, "snail_skin", imageIndex, maxIndex, file.toPath());
            }
        }
    }

    public static List<String> getAllSkins() {
        ArrayList<String> result = new ArrayList<String>();
        File folder = new File("./config/lifeseries/wildlife/snailskins/");
        File[] files = folder.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            String name;
            if (!file.isFile() || (name = file.getName().toLowerCase()).equalsIgnoreCase("example.png") || !name.endsWith(".png")) continue;
            String replacedName = name.replaceAll(".png", "");
            result.add(replacedName);
        }
        return result;
    }

    public static void sendStoredImages() {
        SnailSkinsServer.sendStoredImages(PlayerUtils.getAllPlayers());
    }

    public static void createConfig() {
        File folder = new File("./config/lifeseries/wildlife/snailskins/");
        if (!folder.exists() && !folder.mkdirs()) {
            Main.LOGGER.error("Failed to create folder {}", (Object)folder);
            return;
        }
        ResourceHandler handler = new ResourceHandler();
        Path modelResult = new File("./config/lifeseries/wildlife/snailskins/snail.bbmodel").toPath();
        handler.copyBundledSingleFile("/model/lifeseries/snail.bbmodel", modelResult);
        Path textureResult = new File("./config/lifeseries/wildlife/snailskins/example.png").toPath();
        handler.copyBundledSingleFile("/model/lifeseries/texture/example.png", textureResult);
    }
}

