/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.session;

import net.mat0u5.lifeseries.seasons.session.SessionTranscript;

public abstract class SessionAction {
    public boolean hasTriggered = false;
    public int triggerAtTicks;
    public String sessionMessage;
    public String sessionId;

    public SessionAction(int triggerAtTicks) {
        this.triggerAtTicks = triggerAtTicks;
    }

    public SessionAction(int triggerAtTicks, String message, String sessionId) {
        this.triggerAtTicks = triggerAtTicks;
        this.sessionMessage = message;
        this.sessionId = sessionId;
    }

    public boolean tick(int currentTick, int sessionLength) {
        if (this.triggerAtTicks < 0) {
            int remaining = sessionLength - currentTick;
            if (this.hasTriggered && remaining > -this.triggerAtTicks) {
                this.hasTriggered = false;
            }
            if (this.hasTriggered) {
                return true;
            }
            if (remaining <= -this.triggerAtTicks) {
                this.hasTriggered = true;
                SessionTranscript.triggerSessionAction(this.sessionId);
                this.trigger();
                return true;
            }
            return false;
        }
        if (this.hasTriggered && this.triggerAtTicks > currentTick) {
            this.hasTriggered = false;
        }
        if (this.hasTriggered) {
            return true;
        }
        if (this.triggerAtTicks <= currentTick) {
            this.hasTriggered = true;
            SessionTranscript.triggerSessionAction(this.sessionId);
            this.trigger();
            return true;
        }
        return false;
    }

    public int getTriggerTime() {
        return this.triggerAtTicks;
    }

    public abstract void trigger();
}

