/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries;

import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.config.MainConfig;
import net.mat0u5.lifeseries.events.Events;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.registries.ModRegistries;
import net.mat0u5.lifeseries.resources.datapack.DatapackManager;
import net.mat0u5.lifeseries.seasons.blacklist.Blacklist;
import net.mat0u5.lifeseries.seasons.other.LivesManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.SnailSkins;
import net.mat0u5.lifeseries.seasons.session.Session;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.enums.HandshakeStatus;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.enums.SessionTimerStates;
import net.mat0u5.lifeseries.utils.interfaces.IClientHelper;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.versions.UpdateChecker;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements ModInitializer {
    public static final String MOD_VERSION = "dev-1.4.2.4";
    public static final String MOD_ID = "lifeseries";
    public static final String UPDATES_URL = "https://api.github.com/repos/Mat0u5/LifeSeries/releases";
    public static final boolean DEBUG = false;
    public static final boolean ISOLATED_ENVIRONMENT = false;
    public static final Seasons DEFAULT_SEASON = Seasons.UNASSIGNED;
    public static boolean MOD_DISABLED = false;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"lifeseries");
    private static ConfigManager config;
    public static IClientHelper clientHelper;
    @Nullable
    public static MinecraftServer server;
    public static Season currentSeason;
    public static Session currentSession;
    public static LivesManager livesManager;
    public static Blacklist blacklist;
    public static ConfigManager seasonConfig;
    public static final List<String> ALLOWED_SEASON_NAMES;

    public void onInitialize() {
        LOGGER.info("Initializing Life Series...");
        FabricLoader.getInstance().getModContainer(MOD_ID).ifPresent(container -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)MOD_ID), (ModContainer)container, (class_2561)class_2561.method_30163((String)"Main Life Series Resourcepack"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)"minimal_armor"), (ModContainer)container, (class_2561)class_2561.method_30163((String)"Minimal Armor Resourcepack"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)"lifeseries_datapack"), (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
        });
        ConfigManager.moveOldMainFileIfExists();
        SnailSkins.createConfig();
        config = new MainConfig();
        MOD_DISABLED = config.getOrCreateProperty("modDisabled", "false").equalsIgnoreCase("true");
        String season = config.getOrCreateProperty("currentSeries", DEFAULT_SEASON.getId());
        Main.parseSeason(season);
        Seasons.getSeasons().forEach(seasons -> seasons.getSeasonInstance().createConfig());
        ModRegistries.registerModStuff();
        UpdateChecker.checkForMajorUpdates();
        NetworkHandlerServer.registerPackets();
        NetworkHandlerServer.registerServerReceiver();
    }

    public static boolean modDisabled() {
        if (clientHelper != null) {
            if (clientHelper.isReplay()) {
                return true;
            }
            if (clientHelper.serverHandshake() == HandshakeStatus.NOT_RECEIVED) {
                return true;
            }
        }
        return MOD_DISABLED;
    }

    public static boolean modFullyDisabled() {
        if (clientHelper == null) {
            return false;
        }
        return clientHelper.serverHandshake() == HandshakeStatus.NOT_RECEIVED;
    }

    public static void setDisabled(boolean disabled) {
        MOD_DISABLED = disabled;
        config.setProperty("modDisabled", String.valueOf(MOD_DISABLED));
        if (!Main.modDisabled()) {
            Main.fullReload();
        }
    }

    public static void fullReload() {
        String season = config.getOrCreateProperty("currentSeries", DEFAULT_SEASON.getId());
        Main.changeSeasonTo(season);
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static void setClientHelper(IClientHelper helper) {
        clientHelper = helper;
    }

    public static boolean isLogicalSide() {
        if (!Main.isClient()) {
            return true;
        }
        return clientHelper != null && clientHelper.isRunningIntegratedServer();
    }

    public static boolean isClientPlayer(UUID uuid) {
        if (!Main.isClient()) {
            return false;
        }
        return clientHelper != null && clientHelper.isMainClientPlayer(uuid);
    }

    public static void parseSeason(String seasonStr) {
        currentSeason = Seasons.getSeasonFromStringName(seasonStr).getSeasonInstance();
        currentSession = new Session();
        Main.currentSession.sessionLength = config.getOrCreateInt("session_length", 144000);
        livesManager = Main.currentSeason.livesManager;
        seasonConfig = currentSeason.createConfig();
        blacklist = currentSeason.createBlacklist();
    }

    public static void reloadStart() {
        if (Events.skipNextTickReload) {
            return;
        }
        Main.softReloadStart();
        DatapackManager.onReloadStart();
    }

    public static void softReloadStart() {
        Season season;
        if (currentSeason.getSeason() == Seasons.SECRET_LIFE) {
            TaskManager.initialize();
        }
        if (currentSeason.getSeason() == Seasons.DOUBLE_LIFE && (season = currentSeason) instanceof DoubleLife) {
            DoubleLife doubleLife = (DoubleLife)season;
            doubleLife.loadSoulmates();
        }
        seasonConfig.loadProperties();
        blacklist.reloadBlacklist();
        currentSeason.reload();
        NetworkHandlerServer.sendUpdatePackets();
        PlayerUtils.resendCommandTrees();
        SnailSkins.sendTextures();
    }

    public static void reloadEnd() {
        DatapackManager.onReloadEnd();
    }

    public static boolean changeSeasonTo(String changeTo) {
        TaskScheduler.clearTasks();
        config.setProperty("currentSeries", changeTo);
        livesManager.resetAllPlayerLivesInner();
        currentSession.sessionEnd();
        Main.parseSeason(changeTo);
        currentSeason.initialize();
        Main.reloadStart();
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            currentSeason.onPlayerJoin(player);
            currentSeason.onPlayerFinishJoining(player);
            NetworkHandlerServer.tryKickFailedHandshake(player);
            NetworkHandlerServer.sendStringPacket(player, PacketNames.SEASON_INFO, currentSeason.getSeason().getId());
            NetworkHandlerServer.sendLongPacket(player, PacketNames.SESSION_TIMER, SessionTimerStates.NOT_STARTED.getValue());
        }
        SessionTranscript.resetStats();
        return true;
    }

    public static ConfigManager getMainConfig() {
        return config;
    }

    static {
        ALLOWED_SEASON_NAMES = Seasons.getSeasonIds();
    }
}

