/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.mixin;

import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.WildLife;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2846;
import net.minecraft.class_2886;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_7471;
import net.minecraft.class_7635;
import net.minecraft.class_9449;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class}, priority=1)
public class ServerPlayNetworkHandlerMixin {
    @Unique
    private static final List<String> mutedCommands = List.of("msg", "tell", "whisper", "w", "me");

    @Inject(method={"handleDecoratedMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleDecoratedMessage(class_7471 message, CallbackInfo ci) {
        if (!Main.isLogicalSide() || Main.modDisabled()) {
            return;
        }
        class_3244 handler = (class_3244)this;
        class_3222 player = handler.field_14140;
        if (this.ls$mute(handler.field_14140, ci)) {
            return;
        }
        class_2561 originalText = message.method_46291();
        String originalContent = originalText.getString();
        if (!originalContent.contains(":")) {
            return;
        }
        String formattedContent = TextUtils.replaceEmotes(originalContent);
        if (!originalContent.equals(formattedContent)) {
            class_5250 formattedContentText = class_2561.method_43470((String)formattedContent).method_10862(originalText.method_10866());
            class_5250 finalMessage = TextUtils.format("<{}> {}", player, formattedContentText);
            PlayerUtils.broadcastMessage((class_2561)finalMessage);
            ci.cancel();
        }
    }

    @Inject(method={"onPlayerInteractItem"}, at={@At(value="HEAD")})
    private void onPlayerInteractItem(class_2886 packet, CallbackInfo ci) {
        if (!Main.isLogicalSide() || Main.modDisabled()) {
            return;
        }
        class_3244 handler = (class_3244)this;
        class_3222 player = handler.field_14140;
        if (Main.currentSeason instanceof WildLife) {
            WildcardManager.onUseItem(player);
        }
    }

    @Inject(method={"executeCommand"}, at={@At(value="HEAD")}, cancellable=true)
    private void executeCommand(String command, CallbackInfo ci) {
        if (Main.modDisabled()) {
            return;
        }
        class_3244 handler = (class_3244)this;
        for (String mutedCmd : mutedCommands) {
            boolean stoppedCommand;
            if (!command.startsWith(mutedCmd + " ") || !(stoppedCommand = this.ls$mute(handler.field_14140, ci))) continue;
            return;
        }
    }

    @Inject(method={"handleCommandExecution"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/command/CommandManager;execute(Lcom/mojang/brigadier/ParseResults;Ljava/lang/String;)V")}, cancellable=true)
    private void handleCommandExecution(class_9449 packet, class_7635 lastSeenMessages, CallbackInfo ci) {
        if (Main.modDisabled()) {
            return;
        }
        class_3244 handler = (class_3244)this;
        for (String command : mutedCommands) {
            boolean stoppedCommand;
            if (!packet.comp_2532().startsWith(command + " ") || !(stoppedCommand = this.ls$mute(handler.field_14140, ci))) continue;
            return;
        }
    }

    @Unique
    private boolean ls$mute(class_3222 player, CallbackInfo ci) {
        TriviaBot bot;
        if (player == null || PermissionManager.isAdmin(player) || Main.modDisabled()) {
            return false;
        }
        if (TriviaWildcard.bots.containsKey(player.method_5667()) && (bot = TriviaWildcard.bots.get(player.method_5667())).interactedWith() && !bot.submittedAnswer()) {
            player.method_64398(class_2561.method_30163((String)"<Trivia Bot> No phoning a friend allowed!"));
            ci.cancel();
            return true;
        }
        if (Main.currentSeason.WATCHERS_MUTED && WatcherManager.isWatcher((class_1657)player)) {
            player.method_64398(class_2561.method_30163((String)"Watchers aren't allowed to talk in chat! Admins can change this behavior in the config."));
            ci.cancel();
            return true;
        }
        if (Main.currentSeason.MUTE_DEAD_PLAYERS && Main.livesManager.isDead(player) && !WatcherManager.isWatcher((class_1657)player)) {
            player.method_64398(class_2561.method_30163((String)"Dead players aren't allowed to talk in chat! Admins can change this behavior in the config."));
            ci.cancel();
            return true;
        }
        return false;
    }

    @Inject(method={"onPlayerAction"}, at={@At(value="RETURN")})
    public void onPlayerAction(class_2846 packet, CallbackInfo ci) {
        class_3244 handler = (class_3244)this;
        if (!Main.isLogicalSide() || Main.modDisabled()) {
            return;
        }
        if (packet.method_12363() == class_2846.class_2847.field_12969) {
            Main.currentSeason.onUpdatedInventory(handler.field_14140);
        }
    }

    @Redirect(method={"cleanUp"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;broadcast(Lnet/minecraft/text/Text;Z)V"))
    public void noLogoffMessage(class_3324 instance, class_2561 message, boolean overlay) {
        class_3244 handler = (class_3244)this;
        if (!Main.isLogicalSide() || Main.modDisabled()) {
            instance.method_43514(message, overlay);
        }
        PlayerUtils.broadcastToVisiblePlayers(handler.field_14140, message);
    }
}

