/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.boogeyman;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.boogeyman.Boogeyman;
import net.mat0u5.lifeseries.seasons.boogeyman.advanceddeaths.AdvancedDeathsManager;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.session.SessionAction;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_9015;

public class BoogeymanManager {
    public boolean BOOGEYMAN_ENABLED = false;
    public double BOOGEYMAN_CHANCE_MULTIPLIER = 0.5;
    public int BOOGEYMAN_AMOUNT_MIN = 1;
    public int BOOGEYMAN_AMOUNT_MAX = 99;
    public boolean BOOGEYMAN_ADVANCED_DEATHS = false;
    public double BOOGEYMAN_CHOOSE_MINUTE = 10.0;
    public boolean BOOGEYMAN_ANNOUNCE_OUTCOME = false;
    public List<String> BOOGEYMAN_IGNORE = new ArrayList<String>();
    public List<String> BOOGEYMAN_FORCE = new ArrayList<String>();
    public String BOOGEYMAN_MESSAGE = "\u00a77You are the Boogeyman. You must by any means necessary kill a \u00a72dark green\u00a77, \u00a7agreen\u00a77 or \u00a7eyellow\u00a77 name by direct action to be cured of the curse. If you fail, you will become a \u00a7cred name\u00a77. All loyalties and friendships are removed while you are the Boogeyman.";
    public boolean BOOGEYMAN_INFINITE = false;
    public int BOOGEYMAN_INFINITE_LAST_PICK = 1800;
    public int BOOGEYMAN_INFINITE_AUTO_FAIL = 360000;
    public boolean BOOGEYMAN_TEAM_NOTICE = false;
    public int BOOGEYMAN_KILLS_NEEDED = 1;
    public List<Boogeyman> boogeymen = new ArrayList<Boogeyman>();
    public List<UUID> rolledPlayers = new ArrayList<UUID>();
    public boolean boogeymanChosen = false;
    public boolean boogeymanListChanged = false;
    List<UUID> afterFailedMessaged = new ArrayList<UUID>();
    List<UUID> warningAutoFail = new ArrayList<UUID>();

    public void addSessionActions() {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        Main.currentSession.addSessionActionIfTime(new SessionAction(OtherUtils.minutesToTicks(this.BOOGEYMAN_CHOOSE_MINUTE - 5.0)){

            @Override
            public void trigger() {
                if (!BoogeymanManager.this.BOOGEYMAN_ENABLED) {
                    return;
                }
                if (BoogeymanManager.this.boogeymanChosen) {
                    return;
                }
                PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"The Boogeyman is being chosen in 5 minutes.").method_27692(class_124.field_1061));
                PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3417.field_14865);
            }
        });
        Main.currentSession.addSessionActionIfTime(new SessionAction(OtherUtils.minutesToTicks(this.BOOGEYMAN_CHOOSE_MINUTE - 1.0)){

            @Override
            public void trigger() {
                if (!BoogeymanManager.this.BOOGEYMAN_ENABLED) {
                    return;
                }
                if (BoogeymanManager.this.boogeymanChosen) {
                    return;
                }
                PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"The Boogeyman is being chosen in 1 minute.").method_27692(class_124.field_1061));
                PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3417.field_14865);
            }
        });
        Main.currentSession.addSessionAction(new SessionAction(OtherUtils.minutesToTicks(this.BOOGEYMAN_CHOOSE_MINUTE), TextUtils.formatString("\u00a77Choose Boogeymen \u00a7f[{}]", OtherUtils.formatTime(OtherUtils.minutesToTicks(this.BOOGEYMAN_CHOOSE_MINUTE))), "Choose Boogeymen"){

            @Override
            public void trigger() {
                if (!BoogeymanManager.this.BOOGEYMAN_ENABLED) {
                    return;
                }
                if (BoogeymanManager.this.boogeymanChosen) {
                    return;
                }
                BoogeymanManager.this.prepareToChooseBoogeymen();
            }
        });
    }

    public boolean isBoogeyman(class_3222 player) {
        if (player == null) {
            return false;
        }
        for (Boogeyman boogeyman : this.boogeymen) {
            if (!boogeyman.uuid.equals(player.method_5667())) continue;
            return true;
        }
        return false;
    }

    public boolean isBoogeymanThatCanBeCured(class_3222 player, class_3222 victim) {
        Boogeyman boogeyman = this.getBoogeyman(player);
        if (boogeyman == null) {
            return false;
        }
        if (boogeyman.cured) {
            return false;
        }
        if (boogeyman.failed) {
            return false;
        }
        return !Main.livesManager.isOnLastLife(victim, true);
    }

    public Boogeyman getBoogeyman(class_3222 player) {
        if (player == null) {
            return null;
        }
        for (Boogeyman boogeyman : this.boogeymen) {
            if (!boogeyman.uuid.equals(player.method_5667())) continue;
            return boogeyman;
        }
        return null;
    }

    public Boogeyman addBoogeyman(class_3222 player) {
        if (!this.BOOGEYMAN_ENABLED) {
            return null;
        }
        if (!this.rolledPlayers.contains(player.method_5667())) {
            this.rolledPlayers.add(player.method_5667());
        }
        Boogeyman newBoogeyman = new Boogeyman(player);
        this.boogeymen.add(newBoogeyman);
        this.boogeymanChosen = true;
        this.boogeymanListChanged = true;
        return newBoogeyman;
    }

    public void addBoogeymanManually(class_3222 player) {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        Boogeyman newBoogeyman = this.addBoogeyman(player);
        player.method_64398(class_2561.method_30163((String)"\u00a7c [NOTICE] You are now a Boogeyman!"));
        this.messageBoogeyman(newBoogeyman, player);
    }

    public void removeBoogeymanManually(class_3222 player) {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        Boogeyman boogeyman = this.getBoogeyman(player);
        if (boogeyman == null) {
            return;
        }
        this.boogeymen.remove(boogeyman);
        if (this.boogeymen.isEmpty()) {
            this.boogeymanChosen = false;
        }
        player.method_64398(class_2561.method_30163((String)"\u00a7c [NOTICE] You are no longer a Boogeyman!"));
    }

    public void resetBoogeymen() {
        if (Main.server == null) {
            return;
        }
        for (Boogeyman boogeyman : this.boogeymen) {
            class_3222 player = PlayerUtils.getPlayer(boogeyman.uuid);
            if (player == null) continue;
            player.method_64398(class_2561.method_30163((String)"\u00a7c [NOTICE] You are no longer a Boogeyman!"));
        }
        this.boogeymen = new ArrayList<Boogeyman>();
        this.boogeymanChosen = false;
        this.rolledPlayers = new ArrayList<UUID>();
    }

    public void cure(class_3222 player) {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        Boogeyman boogeyman = this.getBoogeyman(player);
        if (this.boogeymen == null) {
            return;
        }
        boogeyman.failed = false;
        if (boogeyman.cured) {
            return;
        }
        boogeyman.cured = true;
        PlayerUtils.sendTitle(player, class_2561.method_30163((String)"\u00a7aYou are cured!"), 20, 30, 20);
        PlayerUtils.playSoundToPlayer(player, class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"lastlife_boogeyman_cure")));
        if (this.BOOGEYMAN_ANNOUNCE_OUTCOME) {
            PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 is cured of the Boogeyman curse!", player));
        }
    }

    public void onBoogeymanKill(class_3222 player) {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        Boogeyman boogeyman = this.getBoogeyman(player);
        if (this.boogeymen == null) {
            return;
        }
        if (boogeyman.cured || boogeyman.failed) {
            return;
        }
        boogeyman.onKill();
        if (boogeyman.shouldCure()) {
            this.cure(player);
        } else {
            player.method_64398((class_2561)TextUtils.formatLoosely("\u00a77You still need {} {} to be cured of the curse.", boogeyman.killsNeeded, TextUtils.pluralize("kill", boogeyman.killsNeeded)));
        }
    }

    public void chooseNewBoogeyman() {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        if (Main.currentSession.statusFinished() || Main.currentSession.statusNotStarted()) {
            return;
        }
        int remainingTicks = Main.currentSession.getRemainingTime();
        if (remainingTicks <= OtherUtils.secondsToTicks(this.BOOGEYMAN_INFINITE_LAST_PICK)) {
            return;
        }
        PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"A new boogeyman is about to be chosen.").method_27692(class_124.field_1061));
        PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3417.field_14865);
        TaskScheduler.scheduleTask(100, () -> {
            List<class_3222> allowedPlayers = this.getAllowedBoogeyPlayers();
            if (allowedPlayers.isEmpty()) {
                return;
            }
            Collections.shuffle(allowedPlayers);
            TaskScheduler.scheduleTask(180, () -> this.chooseBoogeymen(allowedPlayers, BoogeymanRollType.INFINITE));
        });
    }

    public void prepareToChooseBoogeymen() {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"The Boogeyman is about to be chosen.").method_27692(class_124.field_1061));
        PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3417.field_14865);
        TaskScheduler.scheduleTask(100, () -> {
            this.resetBoogeymen();
            this.chooseBoogeymen(Main.livesManager.getAlivePlayers(), BoogeymanRollType.NORMAL);
        });
    }

    public void showRolling(List<class_3222> allowedPlayers) {
        PlayerUtils.playSoundToPlayers(allowedPlayers, (class_3414)class_3417.field_15015.comp_349());
        PlayerUtils.sendTitleToPlayers(allowedPlayers, (class_2561)class_2561.method_43470((String)"3").method_27692(class_124.field_1060), 0, 35, 0);
        TaskScheduler.scheduleTask(30, () -> {
            PlayerUtils.playSoundToPlayers(allowedPlayers, (class_3414)class_3417.field_15015.comp_349());
            PlayerUtils.sendTitleToPlayers(allowedPlayers, (class_2561)class_2561.method_43470((String)"2").method_27692(class_124.field_1054), 0, 35, 0);
        });
        TaskScheduler.scheduleTask(60, () -> {
            PlayerUtils.playSoundToPlayers(allowedPlayers, (class_3414)class_3417.field_15015.comp_349());
            PlayerUtils.sendTitleToPlayers(allowedPlayers, (class_2561)class_2561.method_43470((String)"1").method_27692(class_124.field_1061), 0, 35, 0);
        });
        TaskScheduler.scheduleTask(90, () -> {
            PlayerUtils.playSoundToPlayers(allowedPlayers, class_3414.method_47908((class_2960)class_2960.method_60656((String)"lastlife_boogeyman_wait")));
            PlayerUtils.sendTitleToPlayers(allowedPlayers, (class_2561)class_2561.method_43470((String)"You are...").method_27692(class_124.field_1054), 10, 50, 20);
        });
    }

    public void chooseBoogeymen(List<class_3222> allowedPlayers, BoogeymanRollType rollType) {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        allowedPlayers.removeIf(this::isBoogeyman);
        this.showRolling(allowedPlayers);
        TaskScheduler.scheduleTask(180, () -> this.boogeymenChooseRandom(allowedPlayers, rollType));
    }

    public int getBoogeymanAmount(BoogeymanRollType rollType) {
        int chooseBoogeymen;
        if (rollType == BoogeymanRollType.INFINITE) {
            return 1;
        }
        if (rollType == BoogeymanRollType.LATE_JOIN) {
            if (1.0 / (double)PlayerUtils.getAllFunctioningPlayers().size() >= Math.random()) {
                return 1;
            }
            return 0;
        }
        List<class_3222> nonRedPlayers = Main.livesManager.getNonRedPlayers();
        for (chooseBoogeymen = this.BOOGEYMAN_AMOUNT_MIN; this.BOOGEYMAN_CHANCE_MULTIPLIER >= Math.random() && chooseBoogeymen < nonRedPlayers.size(); ++chooseBoogeymen) {
        }
        if (chooseBoogeymen > this.BOOGEYMAN_AMOUNT_MAX) {
            chooseBoogeymen = this.BOOGEYMAN_AMOUNT_MAX;
        }
        return chooseBoogeymen;
    }

    public void boogeymenChooseRandom(List<class_3222> allowedPlayers, BoogeymanRollType rollType) {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        if (this.BOOGEYMAN_AMOUNT_MAX <= 0) {
            return;
        }
        if (this.BOOGEYMAN_AMOUNT_MAX < this.BOOGEYMAN_AMOUNT_MIN) {
            return;
        }
        allowedPlayers.removeIf(this::isBoogeyman);
        if (allowedPlayers.isEmpty()) {
            return;
        }
        ArrayList<class_3222> normalPlayers = new ArrayList<class_3222>();
        ArrayList<class_3222> boogeyPlayers = new ArrayList<class_3222>();
        if (rollType != BoogeymanRollType.INFINITE) {
            boogeyPlayers.addAll(this.getRandomBoogeyPlayers(allowedPlayers, rollType));
        } else {
            Collections.shuffle(allowedPlayers);
            boogeyPlayers.add(allowedPlayers.getFirst());
        }
        for (class_3222 player : allowedPlayers) {
            if (rollType != BoogeymanRollType.INFINITE) {
                if (this.rolledPlayers.contains(player.method_5667())) continue;
                this.rolledPlayers.add(player.method_5667());
            }
            if (boogeyPlayers.contains(player)) continue;
            normalPlayers.add(player);
        }
        this.handleBoogeymanLists(normalPlayers, boogeyPlayers);
    }

    public List<class_3222> getRandomBoogeyPlayers(List<class_3222> allowedPlayers, BoogeymanRollType rollType) {
        ArrayList<class_3222> boogeyPlayers = new ArrayList<class_3222>();
        List<class_3222> nonRedPlayers = Main.livesManager.getNonRedPlayers();
        Collections.shuffle(nonRedPlayers);
        int chooseBoogeymen = this.getBoogeymanAmount(rollType);
        for (class_3222 player : nonRedPlayers) {
            if (this.isBoogeyman(player) || !allowedPlayers.contains(player) || this.rolledPlayers.contains(player.method_5667()) || this.BOOGEYMAN_IGNORE.contains(player.method_5820().toLowerCase()) || !this.BOOGEYMAN_FORCE.contains(player.method_5820().toLowerCase())) continue;
            boogeyPlayers.add(player);
            --chooseBoogeymen;
        }
        for (class_3222 player : nonRedPlayers) {
            if (chooseBoogeymen <= 0) break;
            if (this.isBoogeyman(player) || !allowedPlayers.contains(player) || this.rolledPlayers.contains(player.method_5667()) || this.BOOGEYMAN_IGNORE.contains(player.method_5820().toLowerCase()) || this.BOOGEYMAN_FORCE.contains(player.method_5820().toLowerCase()) || boogeyPlayers.contains(player)) continue;
            boogeyPlayers.add(player);
            --chooseBoogeymen;
        }
        return boogeyPlayers;
    }

    public List<class_3222> getAllowedBoogeyPlayers() {
        ArrayList<class_3222> result = new ArrayList<class_3222>(Main.livesManager.getNonRedPlayers());
        result.removeIf(this::isBoogeyman);
        return result;
    }

    public void handleBoogeymanLists(List<class_3222> normalPlayers, List<class_3222> boogeyPlayers) {
        PlayerUtils.playSoundToPlayers(normalPlayers, class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"lastlife_boogeyman_no")));
        PlayerUtils.playSoundToPlayers(boogeyPlayers, class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"lastlife_boogeyman_yes")));
        PlayerUtils.sendTitleToPlayers(normalPlayers, (class_2561)class_2561.method_43470((String)"NOT the Boogeyman.").method_27692(class_124.field_1060), 10, 50, 20);
        PlayerUtils.sendTitleToPlayers(boogeyPlayers, (class_2561)class_2561.method_43470((String)"The Boogeyman.").method_27692(class_124.field_1061), 10, 50, 20);
        for (class_3222 boogey : boogeyPlayers) {
            Boogeyman boogeyman = this.addBoogeyman(boogey);
            this.messageBoogeyman(boogeyman, boogey);
        }
        SessionTranscript.boogeymenChosen(boogeyPlayers);
    }

    public void messageBoogeyman(Boogeyman boogeyman, class_3222 boogey) {
        boogey.method_64398(class_2561.method_30163((String)this.BOOGEYMAN_MESSAGE));
        if (boogeyman != null && boogeyman.killsNeeded != 1) {
            boogey.method_64398((class_2561)TextUtils.formatLoosely("\u00a77You need {} {} to be cured of the curse.", boogeyman.killsNeeded, TextUtils.pluralize("kill", boogeyman.killsNeeded)));
        }
    }

    public void sessionEnd() {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        if (Main.server == null) {
            return;
        }
        for (Boogeyman boogeyman : new ArrayList<Boogeyman>(this.boogeymen)) {
            if (boogeyman.died || boogeyman.cured || boogeyman.failed) continue;
            class_3222 player = PlayerUtils.getPlayer(boogeyman.uuid);
            if (player == null) {
                if (this.BOOGEYMAN_ANNOUNCE_OUTCOME) {
                    PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 failed to kill a player while being the \u00a7cBoogeyman\u00a77. They have been dropped to their \u00a7cLast Life\u00a77.", boogeyman.name));
                }
                ScoreboardUtils.setScore(class_9015.method_55422((String)boogeyman.name), "Lives", 1);
                continue;
            }
            this.playerFailBoogeyman(player, true);
        }
    }

    public void playerFailBoogeymanManually(class_3222 player, boolean sendMessage) {
        this.playerFailBoogeyman(player, sendMessage);
    }

    public boolean playerFailBoogeyman(class_3222 player, boolean sendMessage) {
        boolean canChangeLives;
        if (!this.BOOGEYMAN_ENABLED) {
            return false;
        }
        Boogeyman boogeyman = this.getBoogeyman(player);
        if (this.boogeymen == null) {
            return false;
        }
        boogeyman.cured = false;
        if (boogeyman.failed) {
            return false;
        }
        boogeyman.failed = true;
        boolean bl = canChangeLives = Main.livesManager.isAlive(player) && !Main.livesManager.isOnLastLife(player, true);
        if (this.BOOGEYMAN_ADVANCED_DEATHS) {
            PlayerUtils.sendTitle(player, class_2561.method_30163((String)"\u00a7cThe curse consumes you.."), 20, 30, 20);
            if (this.BOOGEYMAN_ANNOUNCE_OUTCOME && sendMessage) {
                PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 failed to kill a player while being the \u00a7cBoogeyman\u00a77. They have been consumed by the curse.", player));
            }
            if (canChangeLives) {
                AdvancedDeathsManager.setPlayerLives(player, 1);
            }
        } else {
            PlayerUtils.sendTitle(player, class_2561.method_30163((String)"\u00a7cYou have failed."), 20, 30, 20);
            PlayerUtils.playSoundToPlayer(player, class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"lastlife_boogeyman_fail")));
            if (this.BOOGEYMAN_ANNOUNCE_OUTCOME && sendMessage) {
                PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 failed to kill a player while being the \u00a7cBoogeyman\u00a77. They have been dropped to their \u00a7cLast Life\u00a77.", player));
            }
            if (canChangeLives) {
                Main.livesManager.setPlayerLives(player, 1);
            }
        }
        return true;
    }

    public void playerLostAllLives(class_3222 player) {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        Boogeyman boogeyman = this.getBoogeyman(player);
        if (boogeyman == null) {
            return;
        }
        boogeyman.died = true;
    }

    public void onPlayerFinishJoining(class_3222 player) {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        if (!this.boogeymanChosen) {
            return;
        }
        if (this.rolledPlayers.contains(player.method_5667())) {
            return;
        }
        if (Main.livesManager.isDead(player)) {
            return;
        }
        if (this.boogeymen.size() >= this.BOOGEYMAN_AMOUNT_MAX) {
            return;
        }
        if (Main.currentSession.statusNotStarted() || Main.currentSession.statusFinished()) {
            return;
        }
        TaskScheduler.scheduleTask(40, () -> {
            player.method_64398(class_2561.method_30163((String)"\u00a7cSince you were not present when the Boogeyman was being chosen, your chance to become the Boogeyman is now. Good luck!"));
            this.chooseBoogeymen(new ArrayList<class_3222>(List.of(player)), BoogeymanRollType.LATE_JOIN);
        });
    }

    public void onReload() {
        this.BOOGEYMAN_ENABLED = (Boolean)Main.seasonConfig.BOOGEYMAN.get(Main.seasonConfig);
        if (!this.BOOGEYMAN_ENABLED) {
            this.onDisabledBoogeyman();
        }
        this.BOOGEYMAN_CHANCE_MULTIPLIER = (Double)Main.seasonConfig.BOOGEYMAN_CHANCE_MULTIPLIER.get(Main.seasonConfig);
        this.BOOGEYMAN_AMOUNT_MIN = (Integer)Main.seasonConfig.BOOGEYMAN_MIN_AMOUNT.get(Main.seasonConfig);
        this.BOOGEYMAN_AMOUNT_MAX = (Integer)Main.seasonConfig.BOOGEYMAN_MAX_AMOUNT.get(Main.seasonConfig);
        this.BOOGEYMAN_ADVANCED_DEATHS = (Boolean)Main.seasonConfig.BOOGEYMAN_ADVANCED_DEATHS.get(Main.seasonConfig);
        this.BOOGEYMAN_MESSAGE = (String)Main.seasonConfig.BOOGEYMAN_MESSAGE.get(Main.seasonConfig);
        this.BOOGEYMAN_IGNORE.clear();
        this.BOOGEYMAN_FORCE.clear();
        for (String name : ((String)Main.seasonConfig.BOOGEYMAN_IGNORE.get(Main.seasonConfig)).replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "").trim().split(",")) {
            if (name.isEmpty()) continue;
            this.BOOGEYMAN_IGNORE.add(name.toLowerCase());
        }
        for (String name : ((String)Main.seasonConfig.BOOGEYMAN_FORCE.get(Main.seasonConfig)).replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "").trim().split(",")) {
            if (name.isEmpty()) continue;
            this.BOOGEYMAN_FORCE.add(name.toLowerCase());
        }
        this.BOOGEYMAN_CHOOSE_MINUTE = (Double)Main.seasonConfig.BOOGEYMAN_CHOOSE_MINUTE.get(Main.seasonConfig);
        this.BOOGEYMAN_ANNOUNCE_OUTCOME = (Boolean)Main.seasonConfig.BOOGEYMAN_ANNOUNCE_OUTCOME.get(Main.seasonConfig);
        this.BOOGEYMAN_INFINITE = (Boolean)Main.seasonConfig.BOOGEYMAN_INFINITE.get(Main.seasonConfig);
        this.BOOGEYMAN_INFINITE_LAST_PICK = (Integer)Main.seasonConfig.BOOGEYMAN_INFINITE_LAST_PICK.get(Main.seasonConfig);
        this.BOOGEYMAN_INFINITE_AUTO_FAIL = (Integer)Main.seasonConfig.BOOGEYMAN_INFINITE_AUTO_FAIL.get(Main.seasonConfig);
        this.BOOGEYMAN_TEAM_NOTICE = (Boolean)Main.seasonConfig.BOOGEYMAN_TEAM_NOTICE.get(Main.seasonConfig);
        this.BOOGEYMAN_KILLS_NEEDED = (Integer)Main.seasonConfig.BOOGEYMAN_KILLS_NEEDED.get(Main.seasonConfig);
    }

    public void onDisabledBoogeyman() {
        this.resetBoogeymen();
    }

    public void tick() {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        for (Boogeyman boogeyman : this.boogeymen) {
            boogeyman.tick();
            this.infiniteBoogeymenTick(boogeyman);
            this.autoFailTick(boogeyman);
            this.failedMessagesTick(boogeyman);
        }
        if (this.boogeymanListChanged) {
            this.boogeymanListChanged = false;
            if (this.BOOGEYMAN_TEAM_NOTICE) {
                this.sendBoogeymanTeamNotice();
            }
        }
    }

    public void sendBoogeymanTeamNotice() {
        for (Boogeyman boogeyman : this.boogeymen) {
            class_3222 player = boogeyman.getPlayer();
            if (player == null) continue;
            ArrayList<class_2561> boogeymenList = new ArrayList<class_2561>();
            for (Boogeyman otherBoogeyman : this.boogeymen) {
                class_3222 otherPlayer = otherBoogeyman.getPlayer();
                if (otherPlayer == player) continue;
                if (otherPlayer != null) {
                    boogeymenList.add(otherPlayer.method_5476());
                    continue;
                }
                boogeymenList.add(class_2561.method_30163((String)otherBoogeyman.name));
            }
            if (boogeymenList.isEmpty()) continue;
            player.method_64398((class_2561)TextUtils.format("Current Boogeymen: {}", boogeymenList));
        }
    }

    public void infiniteBoogeymenTick(Boogeyman boogeyman) {
        if (!this.BOOGEYMAN_INFINITE) {
            return;
        }
        if (!Main.currentSession.statusStarted()) {
            return;
        }
        if (!(boogeyman.failed || boogeyman.cured || boogeyman.died)) {
            return;
        }
        this.boogeymen.remove(boogeyman);
        TaskScheduler.scheduleTask(100, this::chooseNewBoogeyman);
    }

    public void autoFailTick(Boogeyman boogeyman) {
        class_3222 player;
        if (!this.BOOGEYMAN_INFINITE) {
            return;
        }
        if (!Main.currentSession.statusStarted()) {
            return;
        }
        if (boogeyman.failed) {
            return;
        }
        if (boogeyman.cured) {
            return;
        }
        if (boogeyman.died) {
            return;
        }
        int boogeymanTime = boogeyman.ticks / 20;
        int warningTime = this.BOOGEYMAN_INFINITE_AUTO_FAIL - 300;
        if (boogeymanTime >= warningTime && warningTime >= 0) {
            if (!this.warningAutoFail.contains(boogeyman.uuid) && (player = boogeyman.getPlayer()) != null) {
                this.warningAutoFail.add(boogeyman.uuid);
                player.method_64398(class_2561.method_30163((String)"\u00a7cYou only have 5 minutes left to kill someone as the Boogeyman before you fail!"));
            }
        } else {
            this.warningAutoFail.remove(boogeyman.uuid);
        }
        if (boogeymanTime >= this.BOOGEYMAN_INFINITE_AUTO_FAIL && (player = boogeyman.getPlayer()) != null && !this.playerFailBoogeyman(player, true)) {
            boogeyman.failed = true;
        }
    }

    public void failedMessagesTick(Boogeyman boogeyman) {
        if (!this.afterFailedMessages()) {
            return;
        }
        if (!boogeyman.failed) {
            this.afterFailedMessaged.remove(boogeyman.uuid);
            return;
        }
        if (this.afterFailedMessaged.contains(boogeyman.uuid)) {
            return;
        }
        class_3222 player = boogeyman.getPlayer();
        if (player == null) {
            return;
        }
        if (!player.method_5805()) {
            return;
        }
        if (AdvancedDeathsManager.hasQueuedDeath(player)) {
            return;
        }
        this.afterFailLogic(player);
    }

    public void afterFailLogic(class_3222 player) {
        if (!this.afterFailedMessages()) {
            return;
        }
        this.afterFailedMessaged.add(player.method_5667());
        int delay = 20;
        if (!this.BOOGEYMAN_ADVANCED_DEATHS) {
            delay = 140;
        }
        if (Main.currentSeason.getSeason() == Seasons.LIMITED_LIFE) {
            delay = 140;
        }
        TaskScheduler.scheduleTask(delay, () -> PlayerUtils.sendTitle(player, class_2561.method_30163((String)"\u00a7cYour lives are taken..."), 20, 80, 20));
        TaskScheduler.scheduleTask(delay += 140, () -> PlayerUtils.sendTitle(player, class_2561.method_30163((String)"\u00a7c...Now take theirs."), 20, 80, 20));
    }

    public boolean afterFailedMessages() {
        return this.BOOGEYMAN_ADVANCED_DEATHS;
    }

    public static enum BoogeymanRollType {
        NORMAL,
        LATE_JOIN,
        INFINITE;

    }
}

