/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.secretlife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLife;
import net.mat0u5.lifeseries.seasons.season.secretlife.Task;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskManager;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskTypes;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;

public class SecretLifeCommands
extends Command {
    public static final List<UUID> playersGiven = new ArrayList<UUID>();

    @Override
    public boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.SECRET_LIFE;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when playing Secret Life.");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)SecretLifeCommands.literal("health").executes(context -> this.showHealth((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)SecretLifeCommands.literal("sync").requires(PermissionManager::isAdmin)).executes(context -> this.syncHealth((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)SecretLifeCommands.literal("add").requires(PermissionManager::isAdmin)).then(((RequiredArgumentBuilder)SecretLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.healthManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), 1.0, false))).then(SecretLifeCommands.argument("amount", DoubleArgumentType.doubleArg((double)0.0)).executes(context -> this.healthManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), false)))))).then(((LiteralArgumentBuilder)SecretLifeCommands.literal("remove").requires(PermissionManager::isAdmin)).then(((RequiredArgumentBuilder)SecretLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.healthManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), -1.0, false))).then(SecretLifeCommands.argument("amount", DoubleArgumentType.doubleArg((double)0.0)).executes(context -> this.healthManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), -DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), false)))))).then(((LiteralArgumentBuilder)SecretLifeCommands.literal("set").requires(PermissionManager::isAdmin)).then(SecretLifeCommands.argument("player", class_2186.method_9308()).then(SecretLifeCommands.argument("amount", DoubleArgumentType.doubleArg((double)0.0)).executes(context -> this.healthManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), true)))))).then(((LiteralArgumentBuilder)SecretLifeCommands.literal("get").requires(PermissionManager::isAdmin)).then(SecretLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.getHealthFor((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)SecretLifeCommands.literal("reset").requires(PermissionManager::isAdmin)).then(SecretLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.resetHealth((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)SecretLifeCommands.literal("task").requires(PermissionManager::isAdmin)).then(SecretLifeCommands.literal("succeed").then(SecretLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.succeedTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(SecretLifeCommands.literal("fail").then(SecretLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.failTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(SecretLifeCommands.literal("reroll").then(SecretLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.rerollTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(SecretLifeCommands.literal("assignRandom").then(SecretLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.assignTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(SecretLifeCommands.literal("clearTask").then(SecretLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.clearTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(SecretLifeCommands.literal("set").then(SecretLifeCommands.argument("player", class_2186.method_9308()).then(SecretLifeCommands.argument("type", StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(List.of("easy", "hard", "red"), (SuggestionsBuilder)builder)).then(SecretLifeCommands.argument("task", StringArgumentType.greedyString()).executes(context -> this.setTask((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"task")))))))).then(SecretLifeCommands.literal("get").then(SecretLifeCommands.argument("player", class_2186.method_9305()).executes(context -> this.getTask((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"))))));
        dispatcher.register((LiteralArgumentBuilder)SecretLifeCommands.literal("gift").then(SecretLifeCommands.argument("player", class_2186.method_9305()).executes(context -> this.gift((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)SecretLifeCommands.literal("secretlife").requires(PermissionManager::isAdmin)).then(SecretLifeCommands.literal("changeLocations").executes(context -> this.changeLocations((class_2168)context.getSource()))));
    }

    public int getTask(class_2168 source, class_3222 player) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (player == null) {
            return -1;
        }
        boolean hasPreassignedTask = TaskManager.preAssignedTasks.containsKey(player.method_5667());
        boolean hasTaskBook = TaskManager.hasTaskBookCheck(player, false);
        if (!hasTaskBook && !hasPreassignedTask) {
            source.method_45068((class_2561)TextUtils.formatPlain("{} does not have a task book in their inventory nor a pre-assigned task", player));
            return -1;
        }
        String rawTask = "";
        Task task = null;
        if (hasTaskBook) {
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{} has a task book in their inventory", player));
            if (TaskManager.assignedTasks.containsKey(player.method_5667())) {
                task = TaskManager.assignedTasks.get(player.method_5667());
            }
        } else {
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{} has a pre-assigned task", player));
            task = TaskManager.preAssignedTasks.get(player.method_5667());
        }
        if (task == null) {
            source.method_9213(class_2561.method_30163((String)"Failed to read task contents"));
            return -1;
        }
        rawTask = !task.formattedTask.isEmpty() ? task.formattedTask : task.rawTask;
        if (!rawTask.isEmpty()) {
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("\u00a77Click {}\u00a77 to show the task they have.", TextUtils.selfMessageText(rawTask)));
        }
        return 1;
    }

    public int setTask(class_2168 source, Collection<class_3222> targets, String type, String task) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        TaskTypes taskType = TaskTypes.EASY;
        if (type.equalsIgnoreCase("hard")) {
            taskType = TaskTypes.HARD;
        }
        if (type.equalsIgnoreCase("red")) {
            taskType = TaskTypes.RED;
        }
        task = task.replaceAll("\\\\n", "\n");
        for (class_3222 player : targets) {
            boolean inSession;
            TaskManager.preAssignedTasks.put(player.method_5667(), new Task(task, taskType));
            boolean bl = inSession = TaskManager.tasksChosen && !Main.currentSession.statusFinished();
            if (TaskManager.removePlayersTaskBook(player) || inSession) {
                TaskManager.assignRandomTaskToPlayer(player, taskType);
                AnimationUtils.playSecretLifeTotemAnimation(player, taskType == TaskTypes.RED);
                if (targets.size() != 1) continue;
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Changed {}'s task", player));
                continue;
            }
            if (targets.size() != 1) continue;
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Pre-assigned {}'s task for randomization", player));
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77They will be given the task book once you / the game rolls the tasks"));
        }
        if (targets.size() != 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Changed or pre-assigned task of {} targets", targets.size()));
        }
        return 1;
    }

    public int changeLocations(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Changing Secret Life locations..."));
        TaskManager.deleteLocations();
        TaskManager.checkSecretLifePositions();
        return 1;
    }

    public int clearTask(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        ArrayList<class_3222> affected = new ArrayList<class_3222>();
        for (class_3222 player : targets) {
            if (!TaskManager.removePlayersTaskBook(player)) continue;
            affected.add(player);
        }
        if (affected.isEmpty()) {
            source.method_9213(class_2561.method_30163((String)"No task books were found"));
            return -1;
        }
        if (affected.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Removed task book from {}", affected.getFirst()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Removed task book from {} targets", affected.size()));
        }
        return 1;
    }

    public int assignTask(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Assigning random task to {}", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Assigning random tasks to {} targets", targets.size()));
        }
        TaskManager.chooseTasks(targets.stream().toList(), null);
        return 1;
    }

    public int succeedTask(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Succeeding task for {}\u00a77...", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Succeeding task for {}\u00a77 targets...", targets.size()));
        }
        for (class_3222 player : targets) {
            TaskManager.succeedTask(player, true);
        }
        return 1;
    }

    public int failTask(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Failing task for {}\u00a77...", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Failing task for {}\u00a77 targets...", targets.size()));
        }
        for (class_3222 player : targets) {
            TaskManager.failTask(player, true);
        }
        return 1;
    }

    public int rerollTask(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Rerolling task for {}\u00a77...", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Rerolling task for {}\u00a77 targets...", targets.size()));
        }
        for (class_3222 player : targets) {
            TaskManager.rerollTask(player, true);
        }
        return 1;
    }

    public int gift(class_2168 source, class_3222 target) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        SecretLife secretLife = (SecretLife)Main.currentSeason;
        if (target == self) {
            source.method_9213(class_2561.method_30163((String)"Nice Try."));
            return -1;
        }
        if (playersGiven.contains(self.method_5667())) {
            source.method_9213(class_2561.method_30163((String)"You have already gifted a heart this session"));
            return -1;
        }
        if (Main.livesManager.isDead(target)) {
            source.method_9213(class_2561.method_30163((String)"That player is not alive"));
            return -1;
        }
        if (!Main.currentSession.statusStarted()) {
            source.method_9213(class_2561.method_30163((String)"The session has not started"));
            return -1;
        }
        playersGiven.add(self.method_5667());
        secretLife.addPlayerHealth(target, 2.0);
        class_5250 senderMessage = TextUtils.format("You have gifted a heart to {}", target);
        class_5250 recipientMessage = TextUtils.format("{} gave you a heart", self);
        SessionTranscript.giftHeart(self, target);
        self.method_64398((class_2561)senderMessage);
        PlayerUtils.sendTitle(target, (class_2561)recipientMessage, 20, 20, 20);
        target.method_64398((class_2561)recipientMessage);
        AnimationUtils.createSpiral(target, 40);
        PlayerUtils.playSoundToPlayers(List.of(self, target), class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"secretlife_life")));
        return 1;
    }

    public int showHealth(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        SecretLife secretLife = (SecretLife)Main.currentSeason;
        if (Main.livesManager.isDead(self)) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"You're dead..."));
            return -1;
        }
        double playerHealth = secretLife.getRoundedHealth(self);
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("You have {} health", playerHealth));
        return 1;
    }

    public int getHealthFor(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null) {
            return -1;
        }
        if (targets.size() > 1) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"Health of targets:"));
        }
        for (class_3222 player : targets) {
            SecretLife secretLife = (SecretLife)Main.currentSeason;
            if (Main.livesManager.isDead(player)) {
                OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{} is dead", player));
                continue;
            }
            double playerHealth = secretLife.getRoundedHealth(player);
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{} has {} health", player, playerHealth));
        }
        return 1;
    }

    public int syncHealth(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SecretLife secretLife = (SecretLife)Main.currentSeason;
        secretLife.syncAllPlayerHealth();
        return 1;
    }

    public int healthManager(class_2168 source, Collection<class_3222> targets, double amount, boolean setNotGive) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        SecretLife secretLife = (SecretLife)Main.currentSeason;
        if (setNotGive) {
            for (class_3222 player : targets) {
                secretLife.setPlayerHealth(player, amount);
            }
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set {}'s health to {}", targets.iterator().next(), amount));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set the health of {} targets to {}", targets.size(), amount));
            }
        } else {
            String toOrFrom;
            for (class_3222 player : targets) {
                secretLife.addPlayerHealth(player, amount);
            }
            String addOrRemove = amount >= 0.0 ? "Added" : "Removed";
            String string = toOrFrom = amount >= 0.0 ? "to" : "from";
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} health {} {}", addOrRemove, Math.abs(amount), toOrFrom, targets.iterator().next()));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} health {} {} targets", addOrRemove, Math.abs(amount), toOrFrom, targets.size()));
            }
        }
        return 1;
    }

    public int resetHealth(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        for (class_3222 player : targets) {
            SecretLife secretLife = (SecretLife)Main.currentSeason;
            secretLife.resetPlayerHealth(player);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset {}'s health to the default", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset the health to default for {} targets", targets.size()));
        }
        return 1;
    }
}

