/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.snail.server;

import java.util.Objects;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.entity.snail.goal.MiningNavigation;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.mat0u5.lifeseries.utils.world.LevelUtils;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1331;
import net.minecraft.class_1335;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class SnailPathfinding {
    private final Snail snail;
    private class_1409 groundNavigation;
    private class_1407 flyingNavigation;
    private MiningNavigation miningNavigation;
    private NavigationMode currentMode = NavigationMode.WALKING;
    private NavigationMode lastMode = NavigationMode.WALKING;
    private int pathfindingCacheTicks = 0;
    private static final int PATHFINDING_CACHE_DURATION = 20;
    private boolean cachedCanPathOnGround = true;
    private boolean cachedCanPathFlying = true;
    public boolean navigationInit = false;
    private double lastSpeedMultiplier = 0.99;

    public SnailPathfinding(Snail snail) {
        this.snail = snail;
        this.initializeNavigations();
    }

    private void initializeNavigations() {
        this.groundNavigation = new class_1409((class_1308)this.snail, this.snail.method_37908());
        this.flyingNavigation = new class_1407((class_1308)this.snail, this.snail.method_37908());
        this.miningNavigation = new MiningNavigation((class_1308)this.snail, this.snail.method_37908());
        this.groundNavigation.method_6354(false);
        this.groundNavigation.method_6363(false);
        this.groundNavigation.method_46645(false);
        this.flyingNavigation.method_6354(false);
        this.miningNavigation.method_6354(false);
    }

    public void tick() {
        if (this.snail.isPaused()) {
            this.snail.method_5942().method_6340();
            return;
        }
        if (this.snail.field_6012 % 100 == 0 || !this.navigationInit) {
            this.navigationInit = true;
            this.updateMoveControl();
            this.updateNavigation();
        } else if (this.snail.field_6012 % 21 == 0) {
            this.updateMovementSpeed();
        } else if (this.snail.field_6012 % 5 == 0) {
            this.updateNavigationTarget();
        }
        if (this.pathfindingCacheTicks <= 0) {
            this.updatePathfindingCache();
            this.pathfindingCacheTicks = 20;
        } else {
            --this.pathfindingCacheTicks;
        }
        if (this.snail.field_6012 % 10 == 0) {
            this.checkPathStaleness();
        }
    }

    private void checkPathStaleness() {
        if (!this.snail.serverData.shouldPathfind()) {
            return;
        }
        class_11 currentPath = this.snail.method_5942().method_6345();
        if (currentPath != null && (currentPath.method_46() || currentPath.method_38() <= 1)) {
            this.updateNavigationTarget();
        }
    }

    private void updatePathfindingCache() {
        class_11 flyingPath;
        if (!this.snail.serverData.shouldPathfind() || this.snail.method_37908().method_8608()) {
            return;
        }
        class_1309 target = this.snail.serverData.getBoundEntity();
        if (target == null) {
            this.cachedCanPathOnGround = false;
            this.cachedCanPathFlying = false;
            return;
        }
        class_243 targetPos = target.method_19538();
        class_2338 groundPos = this.getGroundBlock();
        if (groundPos != null) {
            class_243 originalPos = this.snail.method_19538();
            double groundY = (double)groundPos.method_10264() + 1.0;
            boolean wasOnGround = this.snail.method_24828();
            if (!wasOnGround) {
                this.snail.method_24830(true);
                this.snail.method_5814(this.snail.method_23317(), groundY, this.snail.method_23321());
            }
            class_11 groundPath = this.groundNavigation.method_6349((class_1297)target, 0);
            if (!wasOnGround) {
                this.snail.method_5814(originalPos.field_1352, originalPos.field_1351, originalPos.field_1350);
                this.snail.method_24830(wasOnGround);
            }
            this.cachedCanPathOnGround = groundPath != null && groundPath.method_45() != null && groundPath.method_45().method_22879().method_46558().method_1022(targetPos) < 2.0;
        } else {
            this.cachedCanPathOnGround = false;
        }
        this.cachedCanPathFlying = !this.cachedCanPathOnGround ? (flyingPath = this.flyingNavigation.method_6349((class_1297)target, 0)) != null && flyingPath.method_45() != null && flyingPath.method_45().method_22879().method_46558().method_1022(targetPos) < 2.0 : true;
    }

    public boolean isValidGroundPosition(class_2338 groundPos) {
        if (groundPos == null) {
            return false;
        }
        class_2680 block = this.snail.method_37908().method_8320(groundPos);
        if (block.method_27852(class_2246.field_10164)) {
            return false;
        }
        if (block.method_27852(class_2246.field_10382)) {
            return false;
        }
        return !block.method_27852(class_2246.field_27879);
    }

    public boolean canPathToPlayer(boolean requireFlying) {
        if (!this.snail.serverData.shouldPathfind()) {
            return false;
        }
        if (requireFlying) {
            return this.cachedCanPathFlying;
        }
        return this.cachedCanPathOnGround;
    }

    public boolean canPathToPlayerFromGround(boolean flying) {
        class_2338 groundPos = this.getGroundBlock();
        if (!this.isValidGroundPosition(groundPos)) {
            return false;
        }
        return this.canPathToPlayer(flying);
    }

    @Nullable
    public class_2338 getGroundBlock() {
        class_243 startPos = this.snail.method_19538();
        int minY = this.snail.method_37908().method_31607();
        class_243 endPos = new class_243(startPos.method_10216(), (double)minY, startPos.method_10215());
        class_3965 result = this.snail.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.snail));
        if (result.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        return result.method_17777();
    }

    public double getDistanceToGroundBlock() {
        class_2338 belowBlock = this.getGroundBlock();
        if (belowBlock == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.snail.method_23318() - (double)belowBlock.method_10264() - 1.0;
    }

    public void fakeTeleportNearPlayer(double minDistanceFromPlayer) {
        class_1937 class_19372 = this.snail.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            class_1309 boundEntity = this.snail.serverData.getBoundEntity();
            class_3222 boundPlayer = this.snail.serverData.getBoundPlayer();
            if (boundEntity == null || boundPlayer == null) {
                return;
            }
            class_1937 class_19373 = boundEntity.method_37908();
            if (class_19373 instanceof class_3218) {
                class_3218 entityWorld = (class_3218)class_19373;
                if (!this.snail.serverData.shouldPathfind()) {
                    return;
                }
                class_2338 tpTo = this.getBlockPosNearTarget((class_1297)boundEntity, minDistanceFromPlayer);
                if (tpTo == null) {
                    return;
                }
                level.method_43128(null, this.snail.method_23317(), this.snail.method_23318(), this.snail.method_23321(), class_3417.field_46945, this.snail.method_5634(), this.snail.soundVolume(), this.snail.method_6017());
                entityWorld.method_43128(null, (double)tpTo.method_10263(), (double)tpTo.method_10264(), (double)tpTo.method_10260(), class_3417.field_46945, this.snail.method_5634(), this.snail.soundVolume(), this.snail.method_6017());
                AnimationUtils.spawnTeleportParticles(level, this.snail.method_19538());
                AnimationUtils.spawnTeleportParticles(entityWorld, tpTo.method_46558());
                this.snail.serverData.despawn();
                Snails.spawnSnailFor(boundPlayer, tpTo);
            }
        }
    }

    public static class_2338 getBlockPosNearPlayer(class_1297 target, double distanceFromTarget) {
        if (target == null) {
            return null;
        }
        class_2338 targetPos = target.method_24515();
        return LevelUtils.getCloseBlockPos(target.method_37908(), targetPos, distanceFromTarget, 1, false);
    }

    public class_2338 getBlockPosNearTarget(class_1297 target, double distanceFromTarget) {
        if (target == null) {
            return null;
        }
        class_243 targetPos = this.snail.serverData.getPlayerPos();
        if (targetPos == null) {
            return null;
        }
        class_2338 targetBlockPos = class_2338.method_49637((double)targetPos.field_1352, (double)targetPos.field_1351, (double)targetPos.field_1350);
        return LevelUtils.getCloseBlockPos(target.method_37908(), targetBlockPos, distanceFromTarget, 1, false);
    }

    public void updateNavigation() {
        NavigationMode desiredMode = this.snail.isSnailMining() ? NavigationMode.MINING : (this.snail.isSnailFlying() ? NavigationMode.FLYING : NavigationMode.WALKING);
        if (desiredMode != this.currentMode) {
            this.switchNavigationMode(desiredMode);
            this.currentMode = desiredMode;
        }
    }

    private void switchNavigationMode(NavigationMode mode) {
        this.snail.method_5942().method_6340();
        if (mode == NavigationMode.MINING) {
            this.setNavigationMining();
        } else if (mode == NavigationMode.FLYING) {
            this.setNavigationFlying();
        } else if (mode == NavigationMode.WALKING) {
            this.setNavigationWalking();
        }
        this.lastMode = mode;
    }

    public void updateMoveControl() {
        if (this.snail.isSnailFlying() || this.snail.isSnailMining()) {
            this.setMoveControlFlight();
        } else {
            this.setMoveControlWalking();
        }
    }

    public void setNavigationFlying() {
        this.snail.method_5941(class_7.field_22, -1.0f);
        this.snail.method_5941(class_7.field_19, -1.0f);
        this.snail.method_5941(class_7.field_47413, -1.0f);
        this.snail.method_5941(class_7.field_26446, -1.0f);
        this.snail.method_5941(class_7.field_15, -1.0f);
        this.snail.method_5941(class_7.field_25418, 0.0f);
        this.snail.method_5941(class_7.field_10, -1.0f);
        this.snail.method_5941(class_7.field_17, 0.0f);
        this.snail.method_5941(class_7.field_5, 0.0f);
        this.snail.method_5941(class_7.field_12, 0.0f);
        this.snail.method_5941(class_7.field_7, 0.0f);
        this.snail.setNavigation((class_1408)this.flyingNavigation);
        this.updateNavigationTarget();
    }

    public void setNavigationWalking() {
        this.snail.method_5941(class_7.field_22, -1.0f);
        this.snail.method_5941(class_7.field_19, -1.0f);
        this.snail.method_5941(class_7.field_47413, -1.0f);
        this.snail.method_5941(class_7.field_26446, -1.0f);
        this.snail.method_5941(class_7.field_15, -1.0f);
        this.snail.method_5941(class_7.field_18, 8.0f);
        this.snail.method_5941(class_7.field_25418, 0.0f);
        this.snail.method_5941(class_7.field_10, 0.0f);
        this.snail.method_5941(class_7.field_17, 0.0f);
        this.snail.method_5941(class_7.field_5, 0.0f);
        this.snail.method_5941(class_7.field_12, 0.0f);
        this.snail.method_5941(class_7.field_7, 0.0f);
        this.snail.setNavigation((class_1408)this.groundNavigation);
        this.updateNavigationTarget();
    }

    public void setNavigationMining() {
        this.snail.method_5941(class_7.field_22, 4.0f);
        this.snail.method_5941(class_7.field_19, 0.0f);
        this.snail.method_5941(class_7.field_47413, 0.0f);
        this.snail.method_5941(class_7.field_26446, 0.0f);
        this.snail.method_5941(class_7.field_15, 0.0f);
        this.snail.method_5941(class_7.field_25418, 0.0f);
        this.snail.method_5941(class_7.field_10, 0.0f);
        this.snail.method_5941(class_7.field_17, 0.0f);
        this.snail.method_5941(class_7.field_5, 0.0f);
        this.snail.method_5941(class_7.field_12, 0.0f);
        this.snail.method_5941(class_7.field_7, 0.0f);
        this.snail.setNavigation((class_1408)this.miningNavigation);
        this.updateNavigationTarget();
    }

    public void updateNavigationTarget() {
        if (this.snail.serverData.shouldPathfind() && this.snail.serverData.getPlayerPos() != null) {
            this.snail.method_5980(this.snail.serverData.getBoundEntity());
        } else {
            this.snail.method_5980(null);
        }
        class_1408 nav = this.snail.method_5942();
        if (nav instanceof class_1407) {
            nav.method_6344(1.0);
        } else {
            nav.method_6344((double)0.35f);
        }
    }

    public void updateMovementSpeed() {
        class_11 path = this.snail.method_5942().method_6345();
        if (path != null) {
            double length = path.method_38();
            double speedMultiplier = 1.0;
            if (length > 10.0) {
                speedMultiplier += length / 100.0;
            }
            if (speedMultiplier != this.lastSpeedMultiplier) {
                this.lastSpeedMultiplier = speedMultiplier;
                double movementSpeed = (double)0.35f * speedMultiplier * Snail.GLOBAL_SPEED_MULTIPLIER;
                double flyingSpeed = (double)0.3f * speedMultiplier * Snail.GLOBAL_SPEED_MULTIPLIER;
                if (this.snail.serverData.isNerfed()) {
                    movementSpeed *= 0.6;
                    flyingSpeed *= 0.6;
                }
                if (movementSpeed < 0.01) {
                    movementSpeed = 0.01;
                }
                if (flyingSpeed < 0.01) {
                    flyingSpeed = 0.01;
                }
                Objects.requireNonNull(this.snail.method_5996(class_5134.field_23719)).method_6192(movementSpeed);
                Objects.requireNonNull(this.snail.method_5996(class_5134.field_23720)).method_6192(flyingSpeed);
            }
        }
    }

    public void setMoveControlFlight() {
        this.snail.method_5875(true);
        this.snail.setMoveControl((class_1335)new class_1331((class_1308)this.snail, 20, true));
    }

    public void setMoveControlWalking() {
        this.snail.method_5875(false);
        this.snail.setMoveControl(new class_1335((class_1308)this.snail));
    }

    public void cleanup() {
        if (this.groundNavigation != null) {
            this.groundNavigation.method_6340();
        }
        if (this.flyingNavigation != null) {
            this.flyingNavigation.method_6340();
        }
        if (this.miningNavigation != null) {
            this.miningNavigation.method_6340();
        }
    }

    private static enum NavigationMode {
        WALKING,
        FLYING,
        MINING;

    }
}

