/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.snail.server;

import java.util.Locale;
import java.util.UUID;
import net.mat0u5.lifeseries.entity.PlayerBoundEntity;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.events.Events;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.seasons.subin.SubInManager;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8111;

public class SnailServerData
implements PlayerBoundEntity {
    public static final class_5321<class_8110> SNAIL_DAMAGE = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)IdentifierHelper.mod("snail"));
    public final Snail snail;
    private UUID boundPlayerUUID;
    public int dontAttackFor = 0;
    public int despawnPlayerChecks = 0;
    public class_2561 snailName;
    private int lastAir = 0;

    public SnailServerData(Snail snail) {
        this.snail = snail;
    }

    @Override
    public void onSetPlayer(class_3222 player) {
        this.resetAirPacket();
        this.updateSnailName();
        this.updateSkin((class_1657)player);
        this.snail.setBoundPlayerDead(player.ls$isDead());
    }

    @Override
    public void setBoundPlayerUUID(UUID uuid) {
        this.boundPlayerUUID = uuid;
    }

    @Override
    public UUID getBoundPlayerUUID() {
        return this.boundPlayerUUID;
    }

    @Override
    public boolean shouldPathfind() {
        if (this.snail.method_37908().method_8608()) {
            return false;
        }
        class_3222 player = this.getBoundPlayer();
        if (player == null) {
            return false;
        }
        if (player.method_7337()) {
            return false;
        }
        if (!player.method_5805()) {
            return false;
        }
        if (this.getPlayerPos() == null) {
            return false;
        }
        if (Events.joiningPlayers.contains(player.method_5667())) {
            return false;
        }
        return !player.method_7325() || SuperpowersWildcard.hasActivatedPower(player, Superpowers.ASTRAL_PROJECTION);
    }

    public int getJumpRangeSquared() {
        if (this.isNerfed()) {
            return 9;
        }
        return 14;
    }

    public void updateSnailName() {
        if (!this.hasBoundPlayer()) {
            return;
        }
        this.snailName = class_2561.method_30163((String)Snails.getSnailName((class_1657)this.getBoundPlayer()));
    }

    public void tick() {
        if (this.snail.method_37908().method_8608()) {
            return;
        }
        this.snail.pathfinding.tick();
        if (this.despawnChecks()) {
            return;
        }
        class_3222 boundPlayer = this.getBoundPlayer();
        class_1309 boundEntity = this.getBoundEntity();
        if (this.dontAttackFor > 0) {
            --this.dontAttackFor;
        }
        if (this.snail.field_6012 % 20 == 0) {
            this.updateSnailName();
            if (boundPlayer != null) {
                this.snail.setBoundPlayerDead(boundPlayer.ls$isDead());
            }
        }
        if (boundEntity != null && this.shouldPathfind() && this.snail.method_5829().method_1014(0.05).method_994(boundEntity.method_5829())) {
            this.killBoundEntity((class_1297)boundEntity);
        }
        if (boundPlayer != null && boundEntity != null && Snail.SHOULD_DROWN_PLAYER && !this.snail.isFromTrivia()) {
            int currentAir = this.snail.method_5669();
            if (boundEntity.method_6059(class_1294.field_5923)) {
                currentAir = this.snail.method_5748();
            }
            if (this.lastAir != currentAir) {
                this.lastAir = currentAir;
                this.sendAirPacket(boundPlayer, currentAir);
            }
            if (currentAir == 0) {
                this.damageFromDrowning((class_1297)boundEntity);
            }
        }
        this.handleHighVelocity();
        this.chunkLoading();
        this.snail.sounds.playSounds();
        if (!Snail.ALLOW_POTION_EFFECTS) {
            this.snail.method_6012();
        }
    }

    public boolean despawnChecks() {
        class_3222 player = this.getBoundPlayer();
        this.despawnPlayerChecks = player == null || player.method_7325() && player.ls$isDead() ? ++this.despawnPlayerChecks : 0;
        if (this.despawnPlayerChecks > 200) {
            this.despawn();
            return true;
        }
        if (this.snail.field_6012 % 10 == 0) {
            if (!this.snail.isFromTrivia()) {
                if (!Snails.snails.containsValue((Object)this.snail) || !WildcardManager.isActiveWildcard(Wildcards.SNAILS)) {
                    this.despawn();
                    return true;
                }
            } else if (!WildcardManager.isActiveWildcard(Wildcards.TRIVIA) || this.snail.field_6012 >= 36000) {
                this.despawn();
                return true;
            }
        }
        return false;
    }

    public boolean isNerfed() {
        if (this.snail.isFromTrivia()) {
            return true;
        }
        if (WildcardManager.FINALE) {
            return true;
        }
        return Wildcard.isFinale();
    }

    public void setFromTrivia() {
        this.snail.setFromTrivia(true);
        this.dontAttackFor = 100;
        this.snail.sounds.playAttackSound();
    }

    public void chunkLoading() {
        class_1937 class_19372 = this.snail.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            level.method_14178().method_17297(class_3230.field_19280, new class_1923(this.snail.method_24515()), 2, (Object)this.snail.method_24515());
        }
    }

    public void despawn() {
        this.resetAirPacket();
        if (this.boundPlayerUUID != null) {
            TriviaWildcard.bots.remove(this.boundPlayerUUID);
        }
        this.snail.pathfinding.cleanup();
        class_1937 class_19372 = this.snail.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            this.snail.method_5768();
        }
        this.snail.method_31472();
    }

    public void resetAirPacket() {
        class_3222 player = this.getBoundPlayer();
        if (player != null) {
            this.sendAirPacket(player, 300);
        }
    }

    public void sendAirPacket(class_3222 player, int amount) {
        NetworkHandlerServer.sendNumberPacket(player, PacketNames.SNAIL_AIR, amount);
    }

    public void handleHighVelocity() {
        class_243 velocity = this.snail.method_18798();
        if (velocity.field_1351 > 0.15) {
            this.snail.method_18800(velocity.field_1352, 0.15, velocity.field_1350);
        } else if (velocity.field_1351 < -0.15) {
            this.snail.method_18800(velocity.field_1352, -0.15, velocity.field_1350);
        }
    }

    public void killBoundEntity(class_1297 entity) {
        class_1937 level = entity.method_37908();
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                player.method_6015((class_1309)this.snail);
            }
            class_1282 damageSource = new class_1282((class_6880)serverLevel.method_30349().method_30530(class_7924.field_42534).method_40290(SNAIL_DAMAGE));
            entity.method_5643(damageSource, 1000.0f);
        }
    }

    public void damageFromDrowning(class_1297 entity) {
        if (!entity.method_5805()) {
            return;
        }
        class_1937 level = entity.method_37908();
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                player.method_6015((class_1309)this.snail);
            }
            class_1282 damageSource = new class_1282((class_6880)serverLevel.method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42342));
            entity.method_5643(damageSource, 2.0f);
            if (!entity.method_5805() && entity instanceof class_3222) {
                this.despawn();
            }
        }
    }

    public class_2561 getDefaultName() {
        if (this.snail.isFromTrivia()) {
            return class_2561.method_30163((String)"VHSnail");
        }
        if (this.snailName == null) {
            return this.snail.method_5864().method_5897();
        }
        if (this.snailName.getString().isEmpty()) {
            return this.snail.method_5864().method_5897();
        }
        return this.snailName;
    }

    public void updateSkin(class_1657 player) {
        if (player == null) {
            return;
        }
        String skinName = player.method_5820().toLowerCase(Locale.ROOT);
        if (SubInManager.isSubbingIn(player.method_5667())) {
            skinName = OtherUtils.profileName(SubInManager.getSubstitutedPlayer(player.method_5667())).toLowerCase(Locale.ROOT);
        }
        this.snail.setSkinName(skinName);
    }
}

