/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.TextFieldConfigEntry;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.interfaces.IEntryGroupHeader;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public abstract class NumberConfigEntry<T extends Number>
extends TextFieldConfigEntry
implements IEntryGroupHeader {
    protected static final int RANGE_LABEL_OFFSET_X = -12;
    protected static final int RANGE_LABEL_OFFSET_Y = 6;
    private static final int TEXT_FIELD_WIDTH = 60;
    protected final T defaultValue;
    protected final T minValue;
    protected final T maxValue;
    protected T value;
    protected T startingValue;

    public NumberConfigEntry(String fieldName, String displayName, String description, T value, T defaultValue) {
        this(fieldName, displayName, description, value, defaultValue, null, null);
    }

    public NumberConfigEntry(String fieldName, String displayName, String description, T value, T defaultValue, T minValue, T maxValue) {
        super(fieldName, displayName, description, 60);
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = value;
        this.startingValue = value;
        this.initializeTextField();
    }

    @Override
    protected void initializeTextField() {
        this.setText(this.value.toString());
        if (this.textField.method_25368() - 6 < this.textRenderer.method_1727(this.value.toString())) {
            this.textField.method_1870(false);
        }
    }

    @Override
    protected void onTextChanged(String text) {
        super.onTextChanged(text);
        try {
            T newValue = this.parseValue(text);
            if (this.isValueInRange(newValue)) {
                this.value = newValue;
                this.clearError();
            } else {
                this.setError(TextUtils.formatString("Value must be between {} and {}", this.minValue, this.maxValue));
            }
        }
        catch (NumberFormatException e) {
            this.setError("Invalid number format");
        }
        this.markChanged();
    }

    @Override
    protected void renderAdditionalContent(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        if (this.minValue != null && this.maxValue != null) {
            String rangeText = TextUtils.formatString("({}-{})", this.minValue, this.maxValue);
            int rangeWidth = this.textRenderer.method_1727(rangeText);
            int entryWidth = this.getEntryContentWidth(width);
            context.method_25303(this.textRenderer, rangeText, x + entryWidth - rangeWidth - this.textField.method_25368() + -12, this.getTextFieldPosY(y, height) + 6, TextColors.LIGHT_GRAY);
        }
    }

    @Override
    public void setValue(Object value) {
        if (this.isValidType(value)) {
            this.value = this.castValue(value);
            this.setText(value.toString());
        }
    }

    protected abstract T parseValue(String var1) throws NumberFormatException;

    protected abstract boolean isValueInRange(T var1);

    protected abstract boolean isValidType(Object var1);

    protected abstract T castValue(Object var1);

    public T getValue() {
        return this.value;
    }

    @Override
    public String getValueAsString() {
        return this.value.toString();
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDefaultValueAsString() {
        return this.defaultValue.toString();
    }

    public T getStartingValue() {
        return this.startingValue;
    }

    @Override
    public String getStartingValueAsString() {
        return String.valueOf(this.startingValue);
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void expand() {
    }

    @Override
    public boolean shouldExpand() {
        return true;
    }
}

