/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries.extra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.main.StringConfigEntry;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;

@Environment(value=EnvType.CLIENT)
public class EnchantListConfigEntry
extends StringConfigEntry {
    public EnchantListConfigEntry(String fieldName, String displayName, String description, String value, String defaultValue) {
        super(fieldName, displayName, description, value, defaultValue);
    }

    @Override
    protected void onTextChanged(String text) {
        super.onTextChanged(text);
        this.reloadEntriesRaw(text);
    }

    protected void reloadEntriesRaw(String text) {
        String raw = text;
        raw = raw.replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "");
        ArrayList<String> items = new ArrayList<String>(Arrays.asList(raw.split(",")));
        this.reloadEntries(items);
    }

    /*
     * WARNING - void declaration
     */
    protected void reloadEntries(List<String> items) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        ArrayList<class_5321> newList = new ArrayList<class_5321>();
        boolean errors = false;
        class_2378 enchantmentRegistry = class_310.method_1551().field_1687.method_30349().method_30530(class_5321.method_29180((class_2960)class_2960.method_60655((String)"minecraft", (String)"enchantment")));
        for (String string : items) {
            void var6_6;
            if (string.isEmpty()) continue;
            if (!string.contains(":")) {
                String string2 = "minecraft:" + string;
            }
            try {
                class_2960 id = class_2960.method_60654((String)var6_6);
                class_1887 enchantment = (class_1887)enchantmentRegistry.method_10223(id);
                if (enchantment != null) {
                    newList.add((class_5321)enchantmentRegistry.method_29113((Object)enchantment).orElseThrow());
                    continue;
                }
                this.setError(TextUtils.formatString("Invalid enchantment: '{}'", var6_6));
                errors = true;
            }
            catch (Exception e) {
                this.setError(TextUtils.formatString("Error parsing enchantment ID: '{}'", var6_6));
                errors = true;
            }
        }
        if (!errors) {
            this.clearError();
        }
    }

    @Override
    public boolean hasCustomErrors() {
        return true;
    }

    @Override
    public ConfigTypes getValueType() {
        return ConfigTypes.ENCHANT_LIST;
    }
}

