/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard;

import java.util.List;
import java.util.Random;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class Callback
extends Wildcard {
    private static final Random rnd = new Random();
    private static int activatedAt = -1;
    private static final double TURN_OFF = 0.75;
    private static final double INITIAL_ACTIVATION_INTERVAL = 6000.0;
    private static final double INITIAL_DEACTIVATION_INTERVAL = 600.0;
    private int nextActivationTick = -1;
    private int nextDeactivationTick = -1;
    public static boolean allWildcardsPhaseReached = false;
    private boolean preAllWildcardsPhaseReached = false;
    private Wildcards lastActivatedWildcard;

    @Override
    public Wildcards getType() {
        return Wildcards.CALLBACK;
    }

    @Override
    public void tick() {
        if (Main.currentSession.sessionLength == null) {
            return;
        }
        double sessionProgress = (Main.currentSession.passedTime - (double)activatedAt) / (double)(Main.currentSession.sessionLength - activatedAt);
        if (this.nextActivationTick == -1) {
            this.nextActivationTick = (int)Main.currentSession.passedTime + 6000;
        }
        if (sessionProgress >= 0.75 && this.active) {
            this.deactivate();
            allWildcardsPhaseReached = true;
            return;
        }
        if (allWildcardsPhaseReached) {
            return;
        }
        double approachingEndPhase = 0.75 - 6000.0 / (double)Main.currentSession.sessionLength.intValue();
        if (sessionProgress >= approachingEndPhase) {
            this.activateAllWildcards();
            allWildcardsPhaseReached = true;
            return;
        }
        if (this.preAllWildcardsPhaseReached) {
            return;
        }
        double furtherApproachingEndPhase = 0.75 - 6600.0 / (double)Main.currentSession.sessionLength.intValue();
        if (sessionProgress >= furtherApproachingEndPhase) {
            if (WildcardManager.isActiveWildcard(Wildcards.TIME_DILATION)) {
                WildcardManager.fadedWildcard();
                Wildcard wildcardInstance = WildcardManager.activeWildcards.get((Object)Wildcards.TIME_DILATION);
                wildcardInstance.deactivate();
                WildcardManager.activeWildcards.remove((Object)Wildcards.TIME_DILATION);
                NetworkHandlerServer.sendUpdatePackets();
            }
            this.preAllWildcardsPhaseReached = true;
            return;
        }
        int currentTick = (int)Main.currentSession.passedTime;
        int targetActiveCount = this.getTargetActiveWildcardCount(sessionProgress);
        int currentActiveCount = Wildcards.getActiveWildcards().size() - 1;
        if (currentActiveCount < targetActiveCount && currentTick >= this.nextActivationTick || currentTick >= this.nextActivationTick && this.nextActivationTick > 0) {
            this.activateRandomWildcard();
            double progressFactor = 1.0 - sessionProgress;
            int activationIntervalTicks = (int)(6000.0 * Math.max(0.5, progressFactor));
            this.nextActivationTick = currentTick + activationIntervalTicks;
            double deactivationProgressFactor = 1.0 + sessionProgress / 0.75 * 4.0;
            int deactivationIntervalTicks = (int)(600.0 * Math.clamp(deactivationProgressFactor, 1.0, 5.0));
            this.nextDeactivationTick = currentTick + deactivationIntervalTicks;
        }
        if (currentActiveCount > targetActiveCount && this.nextDeactivationTick > 0 && currentTick >= this.nextDeactivationTick) {
            this.deactivateRandomWildcard();
            this.nextDeactivationTick = -1;
        }
    }

    private int getTargetActiveWildcardCount(double sessionProgress) {
        double approachingEndPhase = 0.75 - 6000.0 / (double)Main.currentSession.sessionLength.intValue();
        double newProgress = sessionProgress / approachingEndPhase;
        if (newProgress < 0.25) {
            return 1;
        }
        if (newProgress < 0.5) {
            return 2;
        }
        if (newProgress < 0.75) {
            return 3;
        }
        return 4;
    }

    @Override
    public void activate() {
        activatedAt = (int)Main.currentSession.passedTime;
        this.nextActivationTick = -1;
        this.nextDeactivationTick = -1;
        allWildcardsPhaseReached = false;
        this.preAllWildcardsPhaseReached = false;
        this.softActivateWildcard(Wildcards.SIZE_SHIFTING);
        super.activate();
    }

    @Override
    public void deactivate() {
        this.deactivateAllWildcards();
        TaskScheduler.scheduleTask(50, () -> {
            if (Main.currentSession.statusStarted()) {
                SessionTranscript.endingIsYours();
                this.showEndingTitles();
            }
        });
        super.deactivate();
    }

    public void showEndingTitles() {
        List<class_3222> players = PlayerUtils.getAllPlayers();
        PlayerUtils.sendTitleToPlayers(players, class_2561.method_30163((String)"\u00a77The ending is \u00a7cyours\u00a77..."), 0, 90, 0);
        TaskScheduler.scheduleTask(80, () -> {
            PlayerUtils.playSoundToPlayers(players, (class_3414)class_3417.field_18310.comp_349(), 0.4f, 1.0f);
            PlayerUtils.sendTitleToPlayers(players, class_2561.method_30163((String)"\u00a7cMake"), 0, 40, 0);
        });
        TaskScheduler.scheduleTask(110, () -> {
            PlayerUtils.playSoundToPlayers(players, (class_3414)class_3417.field_18310.comp_349(), 0.4f, 1.0f);
            PlayerUtils.sendTitleToPlayers(players, class_2561.method_30163((String)"\u00a7cMake \u00a7eit"), 0, 40, 0);
        });
        TaskScheduler.scheduleTask(140, () -> {
            PlayerUtils.playSoundToPlayers(players, class_3417.field_14905, 0.2f, 1.0f);
            PlayerUtils.sendTitleToPlayers(players, class_2561.method_30163((String)"\u00a7cMake \u00a7eit \u00a7a\u00a7lWILD"), 0, 90, 20);
        });
    }

    public void activateAllWildcards() {
        List<Wildcards> inactiveWildcards = Wildcards.getInactiveWildcards();
        for (Wildcards wildcard : inactiveWildcards) {
            Wildcard wildcardInstance;
            if (wildcard == Wildcards.CALLBACK || wildcard == Wildcards.HUNGER || (wildcardInstance = wildcard.getInstance()) == null) continue;
            WildcardManager.activeWildcards.put(wildcard, wildcardInstance);
        }
        WildcardManager.showDots();
        TaskScheduler.scheduleTask(90, () -> {
            for (Wildcard wildcard : WildcardManager.activeWildcards.values()) {
                if (wildcard.active) continue;
                wildcard.activate();
            }
            WildcardManager.showRainbowCryptTitle("All wildcards are active!");
        });
        TaskScheduler.scheduleTask(92, NetworkHandlerServer::sendUpdatePackets);
    }

    public void deactivateAllWildcards() {
        for (Wildcard wildcard : WildcardManager.activeWildcards.values()) {
            if (wildcard.getType() == Wildcards.CALLBACK) continue;
            wildcard.deactivate();
            PlayerUtils.broadcastMessage(class_2561.method_30163((String)"\u00a77A Wildcard has faded..."));
        }
        WildcardManager.activeWildcards.clear();
        PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3417.field_19344);
        NetworkHandlerServer.sendUpdatePackets();
    }

    public void activateRandomWildcard() {
        Wildcards wildcard = this.getRandomInactiveWildcard();
        if (wildcard == null) {
            return;
        }
        Wildcard wildcardInstance = wildcard.getInstance();
        if (wildcardInstance == null) {
            return;
        }
        WildcardManager.activeWildcards.put(wildcard, wildcardInstance);
        WildcardManager.activateWildcards();
        this.lastActivatedWildcard = wildcard;
    }

    public void deactivateRandomWildcard() {
        Wildcards wildcard = this.getRandomActiveWildcard();
        if (wildcard == null) {
            return;
        }
        Wildcard wildcardInstance = WildcardManager.activeWildcards.get((Object)wildcard);
        if (wildcardInstance == null) {
            return;
        }
        wildcardInstance.deactivate();
        WildcardManager.activeWildcards.remove((Object)wildcard);
        WildcardManager.fadedWildcard();
        NetworkHandlerServer.sendUpdatePackets();
    }

    public Wildcards getRandomInactiveWildcard() {
        List<Wildcards> inactiveWildcards = Wildcards.getInactiveWildcards();
        inactiveWildcards.remove((Object)Wildcards.CALLBACK);
        inactiveWildcards.remove((Object)Wildcards.HUNGER);
        if (inactiveWildcards.isEmpty()) {
            return null;
        }
        return inactiveWildcards.get(rnd.nextInt(inactiveWildcards.size()));
    }

    public Wildcards getRandomActiveWildcard() {
        List<Wildcards> activeWildcards = Wildcards.getActiveWildcards();
        activeWildcards.remove((Object)Wildcards.CALLBACK);
        activeWildcards.remove((Object)Wildcards.HUNGER);
        if (activeWildcards.isEmpty()) {
            return null;
        }
        if (this.lastActivatedWildcard != null) {
            activeWildcards.remove((Object)this.lastActivatedWildcard);
            if (activeWildcards.isEmpty()) {
                return this.lastActivatedWildcard;
            }
        }
        return activeWildcards.get(rnd.nextInt(activeWildcards.size()));
    }

    public void softActivateWildcard(Wildcards wildcard) {
        if (WildcardManager.isActiveWildcard(wildcard)) {
            return;
        }
        Wildcard wildcardInstance = wildcard.getInstance();
        if (wildcardInstance == null) {
            return;
        }
        WildcardManager.activeWildcards.put(wildcard, wildcardInstance);
        wildcardInstance.activate();
        TaskScheduler.scheduleTask(2, NetworkHandlerServer::sendUpdatePackets);
    }
}

