/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.triviabot.server;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.compatibilities.DependencyManager;
import net.mat0u5.lifeseries.compatibilities.voicechat.VoicechatMain;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.entity.triviabot.server.TriviaBotPathfinding;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.registries.MobRegistry;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.SizeShifting;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestion;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.other.WeightedRandomizer;
import net.mat0u5.lifeseries.utils.player.AttributeUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.ItemSpawner;
import net.mat0u5.lifeseries.utils.world.ItemStackUtils;
import net.mat0u5.lifeseries.utils.world.LevelUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4466;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.class_9381;

public class TriviaHandler {
    private TriviaBot bot;
    public static ItemSpawner itemSpawner;
    public int difficulty = 0;
    public int interactedAtAge = 0;
    public int timeToComplete = 0;
    public TriviaQuestion question;
    private static final List<class_6880<class_1291>> blessEffects;
    public static final List<UUID> cursedGigantificationPlayers;
    public static final List<UUID> cursedSliding;
    public static final List<UUID> cursedHeartPlayers;
    public static final List<UUID> cursedMoonJumpPlayers;
    public static final List<UUID> cursedRoboticVoicePlayers;

    public TriviaHandler(TriviaBot bot) {
        this.bot = bot;
    }

    public class_1269 interactMob(class_1657 player, class_1268 hand) {
        if (this.bot.method_37908().method_8608()) {
            return class_1269.field_5812;
        }
        class_3222 boundPlayer = this.bot.serverData.getBoundPlayer();
        if (boundPlayer == null) {
            return class_1269.field_5811;
        }
        if (boundPlayer.method_5667() != player.method_5667()) {
            return class_1269.field_5811;
        }
        if (this.bot.submittedAnswer()) {
            return class_1269.field_5811;
        }
        if (this.bot.interactedWith() && this.getRemainingTicks() <= 0) {
            return class_1269.field_5811;
        }
        if (!this.bot.interactedWith() || this.question == null) {
            this.interactedAtAge = this.bot.field_6012;
            this.difficulty = 1 + this.bot.method_59922().method_43048(3);
            this.timeToComplete = this.difficulty * 60 + 120;
            if (this.difficulty == 1) {
                this.timeToComplete = TriviaBot.EASY_TIME;
            }
            if (this.difficulty == 2) {
                this.timeToComplete = TriviaBot.NORMAL_TIME;
            }
            if (this.difficulty == 3) {
                this.timeToComplete = TriviaBot.HARD_TIME;
            }
            this.question = TriviaWildcard.getTriviaQuestion(this.difficulty);
        }
        this.sendTimeUpdatePacket();
        NetworkHandlerServer.sendTriviaPacket(boundPlayer, this.question.getQuestion(), this.difficulty, System.currentTimeMillis(), this.timeToComplete, this.question.getAnswers());
        this.bot.setInteractedWith(true);
        return class_1269.field_5812;
    }

    public void transformIntoSnail() {
        Snail triviaSnail;
        if (this.bot.serverData.getBoundPlayer() != null && (triviaSnail = LevelUtils.spawnEntity(MobRegistry.SNAIL, (class_3218)this.bot.method_37908(), this.bot.method_24515())) != null) {
            triviaSnail.serverData.setBoundPlayer(this.bot.serverData.getBoundPlayer());
            triviaSnail.serverData.setFromTrivia();
            triviaSnail.method_5783((class_3414)class_3417.field_15152.comp_349(), 0.5f, 2.0f);
            class_3218 level = (class_3218)triviaSnail.method_37908();
            class_243 pos = this.bot.method_19538();
            level.method_14199((class_2394)class_2398.field_11236, pos.method_10216(), pos.method_10214(), pos.method_10215(), 10, 0.5, 0.5, 0.5, 0.5);
            TriviaWildcard.snails.put(this.bot.serverData.getBoundPlayer().method_5667(), triviaSnail);
        }
        this.bot.serverData.despawn();
    }

    public void sendTimeUpdatePacket() {
        class_3222 player = this.bot.serverData.getBoundPlayer();
        if (player != null) {
            int ticksSinceStart = this.bot.field_6012 - this.interactedAtAge;
            NetworkHandlerServer.sendNumberPacket(player, PacketNames.TRIVIA_TIMER, ticksSinceStart);
        }
    }

    public int getRemainingTicks() {
        int ticksSinceStart = this.bot.field_6012 - this.interactedAtAge;
        return this.timeToComplete * 20 - ticksSinceStart;
    }

    public void handleAnswer(int answer) {
        if (this.bot.method_37908().method_8608()) {
            return;
        }
        if (this.bot.submittedAnswer()) {
            return;
        }
        this.bot.setSubmittedAnswer(true);
        this.bot.setAnalyzingTime(42);
        PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this.bot, class_3414.method_47908((class_2960)class_2960.method_60656((String)"wildlife_trivia_analyzing")), class_3419.field_15254, 1.0f, 1.0f);
        if (answer == this.question.getCorrectAnswerIndex()) {
            this.answeredCorrect();
            TaskScheduler.scheduleTask(72, () -> PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this.bot, class_3414.method_47908((class_2960)class_2960.method_60656((String)"wildlife_trivia_correct")), class_3419.field_15254, 1.0f, 1.0f));
        } else {
            this.answeredIncorrect();
            TaskScheduler.scheduleTask(72, () -> PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this.bot, class_3414.method_47908((class_2960)class_2960.method_60656((String)"wildlife_trivia_incorrect")), class_3419.field_15254, 1.0f, 1.0f));
        }
    }

    public void answeredCorrect() {
        this.bot.setAnsweredRight(true);
        TaskScheduler.scheduleTask(145, this::spawnItemForPlayer);
        TaskScheduler.scheduleTask(170, this::spawnItemForPlayer);
        TaskScheduler.scheduleTask(198, this::spawnItemForPlayer);
        TaskScheduler.scheduleTask(213, this::blessPlayer);
    }

    public void answeredIncorrect() {
        this.bot.setAnsweredRight(false);
        TaskScheduler.scheduleTask(210, this::cursePlayer);
    }

    public void cursePlayer() {
        Integer n;
        Integer punishmentWeight;
        class_3222 player = this.bot.serverData.getBoundPlayer();
        if (player == null) {
            return;
        }
        player.method_17356(class_3417.field_15203, class_3419.field_15250, 0.2f, 1.0f);
        class_3218 level = (class_3218)this.bot.method_37908();
        class_243 pos = this.bot.method_19538();
        level.method_14199((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)-5893871), pos.method_10216(), pos.method_10214() + 1.0, pos.method_10215(), 40, 0.1, 0.25, 0.1, 0.035);
        int numOfCurses = 9;
        if (DependencyManager.voicechatLoaded() && VoicechatMain.isConnectedToSVC(player.method_5667())) {
            numOfCurses = 10;
        }
        if ((punishmentWeight = player.ls$getLives()) == null) {
            punishmentWeight = 1;
        }
        if (this.difficulty == 1) {
            n = punishmentWeight;
            punishmentWeight = punishmentWeight + 1;
        }
        if (this.difficulty == 3) {
            n = punishmentWeight;
            punishmentWeight = punishmentWeight - 1;
        }
        punishmentWeight = Math.clamp((long)punishmentWeight.intValue(), 1, 4);
        WeightedRandomizer randomizer = new WeightedRandomizer();
        int curse = randomizer.getWeightedRandom(0, numOfCurses, punishmentWeight, 4, 1.5);
        if (numOfCurses == 9 && curse >= 6) {
            ++curse;
        }
        switch (curse) {
            default: {
                this.curseInfestation(player);
                break;
            }
            case 1: {
                this.curseSlipperyGround(player);
                break;
            }
            case 2: {
                this.curseHunger(player);
                break;
            }
            case 3: {
                this.curseBeeswarm(player);
                break;
            }
            case 4: {
                this.curseGigantification(player);
                break;
            }
            case 5: {
                this.curseMoonjump(player);
                break;
            }
            case 6: {
                this.curseRoboticVoice(player);
                break;
            }
            case 7: {
                this.curseBindingArmor(player);
                break;
            }
            case 8: {
                this.curseRavager(player);
                break;
            }
            case 9: {
                this.curseHearts(player);
            }
        }
    }

    public void blessPlayer() {
        class_3222 player = this.bot.serverData.getBoundPlayer();
        if (player == null) {
            return;
        }
        player.method_43496((class_2561)class_2561.method_43473());
        for (int i = 0; i < 3; ++i) {
            class_6880<class_1291> effect = null;
            for (int attempts = 0; effect == null && attempts < 50; ++attempts) {
                class_6880<class_1291> pickedEffect = blessEffects.get(player.method_59922().method_43048(blessEffects.size()));
                if (Main.blacklist != null && Main.blacklist.getBannedEffects().contains(pickedEffect)) continue;
                effect = pickedEffect;
            }
            if (effect == null) continue;
            int amplifier = effect == class_1294.field_5918 || effect == class_1294.field_5923 || effect == class_1294.field_5925 || effect == class_1294.field_5924 || effect == class_1294.field_5910 || effect == class_1294.field_5914 || effect == class_1294.field_5907 ? 0 : player.method_59922().method_43048(4);
            if (Wildcard.isFinale()) {
                player.method_6092(new class_1293(effect, 12000, amplifier));
            } else {
                player.method_6092(new class_1293(effect, 24000, amplifier));
            }
            String romanNumeral = TextUtils.toRomanNumeral(amplifier + 1);
            class_5250 effectName = class_2561.method_43471((String)((class_1291)effect.comp_349()).method_5567());
            player.method_43496((class_2561)TextUtils.formatLoosely(" \u00a7a\u00a7l+ \u00a77{}\u00a76 {}", effectName, romanNumeral));
        }
        player.method_43496((class_2561)class_2561.method_43473());
    }

    public void spawnItemForPlayer() {
        List<class_1799> lootTableItems;
        if (this.bot.method_37908().method_8608()) {
            return;
        }
        if (itemSpawner == null) {
            return;
        }
        if (this.bot.serverData.getBoundPlayer() == null) {
            return;
        }
        class_243 playerPos = this.bot.serverData.getBoundPlayer().method_19538();
        class_243 pos = this.bot.method_19538().method_1031(0.0, 1.0, 0.0);
        class_243 relativeTargetPos = new class_243(playerPos.method_10216() - pos.method_10216(), 0.0, playerPos.method_10215() - pos.method_10215());
        class_243 vector = class_243.field_1353;
        if (relativeTargetPos.method_1027() > 1.0E-4) {
            vector = relativeTargetPos.method_1029().method_1021(0.3).method_1031(0.0, 0.1, 0.0);
        }
        if (!(lootTableItems = ItemSpawner.getRandomItemsFromLootTable(Main.server, (class_3218)this.bot.method_37908(), this.bot.serverData.getBoundPlayer(), class_2960.method_60655((String)"lifeseriesdynamic", (String)"trivia_reward_loottable"))).isEmpty()) {
            for (class_1799 item : lootTableItems) {
                ItemStackUtils.spawnItemForPlayerWithVelocity((class_3218)this.bot.method_37908(), pos, item, (class_1657)this.bot.serverData.getBoundPlayer(), vector);
            }
        } else {
            class_1799 randomItem = itemSpawner.getRandomItem();
            ItemStackUtils.spawnItemForPlayerWithVelocity((class_3218)this.bot.method_37908(), pos, randomItem, (class_1657)this.bot.serverData.getBoundPlayer(), vector);
        }
    }

    public static void initializeItemSpawner() {
        itemSpawner = new ItemSpawner();
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8463, 2), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8634, 2), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8547), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8848, 16), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8477, 4), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8503), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8071, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_49098, 16), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_37538, 2), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_28101, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8626, 8), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8786, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8281, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8108), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_22028), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_22029), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_22030), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8107, 64), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8773, 2), 10);
        class_1799 mace = new class_1799((class_1935)class_1802.field_49814);
        ItemStackUtils.setCustomComponentBoolean(mace, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(mace, "NoModifications", true);
        mace.method_7974(mace.method_7936() - 1);
        itemSpawner.addItem(mace, 5);
        class_1799 endCrystal = new class_1799((class_1935)class_1802.field_8301);
        ItemStackUtils.setCustomComponentBoolean(endCrystal, "IgnoreBlacklist", true);
        itemSpawner.addItem(endCrystal, 10);
        class_1799 patat = new class_1799((class_1935)class_1802.field_8635);
        patat.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)"\u00a76\u00a7l\u00a7nThe Sacred Patat"));
        ItemStackUtils.addLoreToItemStack(patat, List.of(class_2561.method_30163((String)"\u00a75\u00a7oEating bot might help you. Or maybe not...")));
        itemSpawner.addItem(patat, 1);
    }

    public void curseHunger(class_3222 player) {
        class_1293 statusEffectInstance = new class_1293(class_1294.field_5903, 18000, 2);
        player.method_6092(statusEffectInstance);
    }

    public void curseRavager(class_3222 player) {
        class_2338 spawnPos = TriviaBotPathfinding.getBlockPosNearPlayer((class_1297)player, this.bot.method_24515(), 5.0);
        LevelUtils.spawnEntity(class_1299.field_6134, player.ls$getServerLevel(), spawnPos);
    }

    public void curseInfestation(class_3222 player) {
        class_1293 statusEffectInstance = new class_1293(class_1294.field_50121, 18000, 0);
        player.method_6092(statusEffectInstance);
    }

    public void curseGigantification(class_3222 player) {
        cursedGigantificationPlayers.add(player.method_5667());
        SizeShifting.setPlayerSizeUnchecked(player, 4.0);
    }

    public void curseSlipperyGround(class_3222 player) {
        cursedSliding.add(player.method_5667());
    }

    public void curseBindingArmor(class_3222 player) {
        for (class_1799 item : PlayerUtils.getArmorItems(player)) {
            ItemStackUtils.spawnItemForPlayer(player.ls$getServerLevel(), player.method_19538(), item.method_7972(), (class_1657)player);
        }
        class_1799 head = class_1802.field_8267.method_7854();
        class_1799 chest = class_1802.field_8577.method_7854();
        class_1799 legs = class_1802.field_8570.method_7854();
        class_1799 boots = class_1802.field_8370.method_7854();
        head.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        chest.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        legs.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        boots.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        ItemStackUtils.setCustomComponentBoolean(head, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(chest, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(legs, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(boots, "IgnoreBlacklist", true);
        player.method_5673(class_1304.field_6169, head);
        player.method_5673(class_1304.field_6174, chest);
        player.method_5673(class_1304.field_6172, legs);
        player.method_5673(class_1304.field_6166, boots);
        player.method_31548().method_5431();
    }

    public void curseHearts(class_3222 player) {
        cursedHeartPlayers.add(player.method_5667());
        double newHealth = Math.max(player.method_6063() - 7.0f, 1.0f);
        AttributeUtils.setMaxPlayerHealth(player, newHealth);
    }

    public void curseMoonjump(class_3222 player) {
        cursedMoonJumpPlayers.add(player.method_5667());
        AttributeUtils.setJumpStrength(player, 0.76);
    }

    public void curseBeeswarm(class_3222 player) {
        class_2338 spawnPos = TriviaBotPathfinding.getBlockPosNearPlayer((class_1297)player, this.bot.method_24515(), 1.0);
        class_4466 bee1 = (class_4466)LevelUtils.spawnEntity(class_1299.field_20346, (class_3218)this.bot.method_37908(), spawnPos);
        class_4466 bee2 = (class_4466)LevelUtils.spawnEntity(class_1299.field_20346, (class_3218)this.bot.method_37908(), spawnPos);
        class_4466 bee3 = (class_4466)LevelUtils.spawnEntity(class_1299.field_20346, (class_3218)this.bot.method_37908(), spawnPos);
        class_4466 bee4 = (class_4466)LevelUtils.spawnEntity(class_1299.field_20346, (class_3218)this.bot.method_37908(), spawnPos);
        class_4466 bee5 = (class_4466)LevelUtils.spawnEntity(class_1299.field_20346, (class_3218)this.bot.method_37908(), spawnPos);
        if (bee1 != null) {
            bee1.method_29513(player.method_5667());
        }
        if (bee2 != null) {
            bee2.method_29513(player.method_5667());
        }
        if (bee3 != null) {
            bee3.method_29513(player.method_5667());
        }
        if (bee4 != null) {
            bee4.method_29513(player.method_5667());
        }
        if (bee5 != null) {
            bee5.method_29513(player.method_5667());
        }
        if (bee1 != null) {
            bee1.method_29514(1000000);
        }
        if (bee2 != null) {
            bee2.method_29514(1000000);
        }
        if (bee3 != null) {
            bee3.method_29514(1000000);
        }
        if (bee4 != null) {
            bee4.method_29514(1000000);
        }
        if (bee5 != null) {
            bee5.method_29514(1000000);
        }
    }

    public void curseRoboticVoice(class_3222 player) {
        cursedRoboticVoicePlayers.add(player.method_5667());
    }

    static {
        blessEffects = List.of(class_1294.field_5904, class_1294.field_5917, class_1294.field_5910, class_1294.field_5913, class_1294.field_5907, class_1294.field_5924, class_1294.field_5918, class_1294.field_5923, class_1294.field_5925, class_1294.field_5914, class_1294.field_5898);
        cursedGigantificationPlayers = new ArrayList<UUID>();
        cursedSliding = new ArrayList<UUID>();
        cursedHeartPlayers = new ArrayList<UUID>();
        cursedMoonJumpPlayers = new ArrayList<UUID>();
        cursedRoboticVoicePlayers = new ArrayList<UUID>();
    }
}

