/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.doublelife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DoubleLifeCommands
extends Command {
    @Override
    public boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.DOUBLE_LIFE;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when playing Double Life.");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)DoubleLifeCommands.literal("soulmate").requires(PermissionManager::isAdmin)).then(DoubleLifeCommands.literal("get").then(DoubleLifeCommands.argument("player", class_2186.method_9305()).executes(context -> this.getSoulmate((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(DoubleLifeCommands.literal("set").then(DoubleLifeCommands.argument("player", class_2186.method_9305()).then(DoubleLifeCommands.argument("soulmate", class_2186.method_9305()).executes(context -> this.setSoulmate((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_2186.method_9315((CommandContext)context, (String)"soulmate"))))))).then(DoubleLifeCommands.literal("list").executes(context -> this.listSoulmates((class_2168)context.getSource())))).then(DoubleLifeCommands.literal("reset").then(DoubleLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.resetSoulmate((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(DoubleLifeCommands.literal("resetAll").executes(context -> this.resetAllSoulmates((class_2168)context.getSource())))).then(DoubleLifeCommands.literal("rollRandom").executes(context -> this.rollSoulmates((class_2168)context.getSource()))));
    }

    public int setSoulmate(class_2168 source, class_3222 player, class_3222 soulmate) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (player == null) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        if (season.hasSoulmate(player)) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} already has a soulmate", player));
            return -1;
        }
        if (season.hasSoulmate(soulmate)) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} already has a soulmate", player));
            return -1;
        }
        season.setSoulmate(player, soulmate);
        season.saveSoulmates();
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{}'s soulmate is now {}", player, soulmate));
        return 1;
    }

    public int getSoulmate(class_2168 source, class_3222 player) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (player == null) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        if (!season.hasSoulmate(player)) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} does not have a soulmate", player));
            return -1;
        }
        if (!season.isSoulmateOnline(player)) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} 's soulmate is not online right now", player));
            return -1;
        }
        class_3222 soulmate = season.getSoulmate(player);
        if (soulmate == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{}'s soulmate is {}", player, soulmate));
        return 1;
    }

    public int resetSoulmate(class_2168 source, Collection<class_3222> players) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (players == null) {
            return -1;
        }
        if (players.isEmpty()) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        ArrayList<class_3222> affected = new ArrayList<class_3222>();
        for (class_3222 player : players) {
            if (!season.hasSoulmate(player)) continue;
            season.resetSoulmate(player);
            season.saveSoulmates();
            affected.add(player);
        }
        if (affected.isEmpty()) {
            source.method_9213(class_2561.method_30163((String)"No target was found"));
            return -1;
        }
        if (affected.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{}'s soulmate was reset", affected.getFirst()));
            return 1;
        }
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Soulmate was reset for {} targets", affected.size()));
        return 1;
    }

    public int resetAllSoulmates(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        season.resetAllSoulmates();
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"All soulmate entries were reset"));
        return 1;
    }

    public int listSoulmates(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        boolean noSoulmates = true;
        for (Map.Entry<UUID, UUID> entry : season.soulmatesOrdered.entrySet()) {
            noSoulmates = false;
            UUID text1 = entry.getKey();
            UUID text2 = entry.getValue();
            class_3222 player = PlayerUtils.getPlayer(entry.getKey());
            class_3222 soulmate = PlayerUtils.getPlayer(entry.getValue());
            if (player != null) {
                text1 = player;
            }
            if (soulmate != null) {
                text2 = soulmate;
            }
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{}'s soulmate is {}", text1, text2));
        }
        if (noSoulmates) {
            source.method_9213(class_2561.method_30163((String)"There are no soulmates currently assigned"));
        }
        return 1;
    }

    public int rollSoulmates(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Rolling soulmates..."));
        season.rollSoulmates();
        return 1;
    }
}

