/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.snail.goal;

import net.mat0u5.lifeseries.entity.snail.Snail;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;

public final class SnailTeleportGoal
extends class_1352 {
    @NotNull
    private final Snail mob;
    private int ticksSinceLastPositionChange;
    private final int maxTicksSinceLastPositionChange;
    private int teleportCooldown = 0;
    @NotNull
    private class_2338 lastPosition;
    private int lowSpeedTicks = 0;
    private static final double MIN_SPEED_THRESHOLD = 0.01;

    public SnailTeleportGoal(@NotNull Snail mob) {
        this.mob = mob;
        this.maxTicksSinceLastPositionChange = 400;
        this.lastPosition = mob.method_24515();
    }

    public boolean method_6264() {
        if (this.mob.method_37908().method_8608()) {
            return false;
        }
        if (this.mob.isPaused()) {
            return false;
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
            return false;
        }
        if (!this.mob.serverData.shouldPathfind()) {
            return false;
        }
        class_1309 boundEntity = this.mob.serverData.getBoundEntity();
        if (boundEntity == null) {
            return false;
        }
        boolean dimensionsAreSame = this.mob.method_37908().method_27983().equals(boundEntity.method_37908().method_27983());
        if (!dimensionsAreSame) {
            return true;
        }
        float distFromPlayer = this.mob.method_5739((class_1297)boundEntity);
        if (distFromPlayer > 150.0f) {
            return true;
        }
        class_2338 currentPos = this.mob.method_24515();
        if (!currentPos.equals((Object)this.lastPosition)) {
            this.ticksSinceLastPositionChange = 0;
            this.lastPosition = currentPos;
            this.lowSpeedTicks = 0;
        } else {
            ++this.ticksSinceLastPositionChange;
        }
        double currentSpeed = this.mob.method_18798().method_37267();
        this.lowSpeedTicks = currentSpeed < 0.01 * Snail.GLOBAL_SPEED_MULTIPLIER && this.mob.method_5942().method_6345() != null ? ++this.lowSpeedTicks : 0;
        boolean stuckByPosition = this.ticksSinceLastPositionChange > this.maxTicksSinceLastPositionChange;
        boolean stuckBySpeed = this.lowSpeedTicks > this.maxTicksSinceLastPositionChange / 2;
        return stuckByPosition || stuckBySpeed;
    }

    public void method_6269() {
        this.teleportCooldown = 20;
        this.mob.pathfinding.fakeTeleportNearPlayer(75.0);
        this.ticksSinceLastPositionChange = 0;
        this.lowSpeedTicks = 0;
        this.lastPosition = this.mob.method_24515();
    }

    public boolean method_6266() {
        return false;
    }
}

