/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.limitedlife;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.boogeyman.Boogeyman;
import net.mat0u5.lifeseries.seasons.boogeyman.BoogeymanManager;
import net.mat0u5.lifeseries.seasons.boogeyman.advanceddeaths.AdvancedDeathsManager;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLife;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeLivesManager;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_9015;

public class LimitedLifeBoogeymanManager
extends BoogeymanManager {
    @Override
    public void sessionEnd() {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        if (Main.server == null) {
            return;
        }
        for (Boogeyman boogeyman : new ArrayList(this.boogeymen)) {
            if (boogeyman.died || boogeyman.cured || boogeyman.failed) continue;
            class_3222 player = PlayerUtils.getPlayer(boogeyman.uuid);
            if (player == null) {
                Integer currentLives = ScoreboardUtils.getScore(class_9015.method_55422((String)boogeyman.name), "Lives");
                if (currentLives == null || currentLives <= LimitedLifeLivesManager.RED_TIME) continue;
                if (this.BOOGEYMAN_ANNOUNCE_OUTCOME) {
                    PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 failed to kill a player while being the \u00a7cBoogeyman\u00a77. Their time has been dropped to the next color.", boogeyman.name));
                }
                ScoreboardUtils.setScore(class_9015.method_55422((String)boogeyman.name), "Lives", (int)LimitedLife.getNextLivesColorLives(currentLives));
                continue;
            }
            this.playerFailBoogeyman(player, true);
        }
    }

    @Override
    public boolean playerFailBoogeyman(class_3222 player, boolean sendMessage) {
        if (!this.BOOGEYMAN_ENABLED) {
            return false;
        }
        Boogeyman boogeyman = this.getBoogeyman(player);
        if (this.boogeymen == null) {
            return false;
        }
        if (player.ls$isDead()) {
            return false;
        }
        boogeyman.cured = false;
        if (boogeyman.failed) {
            return false;
        }
        boogeyman.failed = true;
        boolean canChangeLives = player.ls$isAlive() && !player.ls$isOnLastLife(true);
        Integer currentLives = player.ls$getLives();
        if (currentLives == null) {
            return false;
        }
        Integer setToLives = LimitedLife.getNextLivesColorLives(currentLives);
        if (setToLives == null) {
            return false;
        }
        if (this.BOOGEYMAN_ADVANCED_DEATHS) {
            PlayerUtils.sendTitle(player, class_2561.method_30163((String)"\u00a7cThe curse consumes you.."), 20, 30, 20);
            if (this.BOOGEYMAN_ANNOUNCE_OUTCOME && sendMessage) {
                PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 failed to kill a player while being the \u00a7cBoogeyman\u00a77. They have been consumed by the curse.", player));
            }
            if (canChangeLives) {
                AdvancedDeathsManager.setPlayerLives(player, setToLives);
            }
        } else {
            if (canChangeLives) {
                player.ls$setLives(setToLives.intValue());
            }
            class_2561 setTo = Main.livesManager.getFormattedLives(player);
            PlayerUtils.sendTitle(player, class_2561.method_30163((String)"\u00a7cYou have failed."), 20, 30, 20);
            PlayerUtils.playSoundToPlayer(player, class_3414.method_47908((class_2960)IdentifierHelper.vanilla("lastlife_boogeyman_fail")));
            if (this.BOOGEYMAN_ANNOUNCE_OUTCOME && sendMessage) {
                PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 failed to kill a player while being the \u00a7cBoogeyman\u00a77. Their time has been dropped to {}", player, setTo));
            }
        }
        return true;
    }

    @Override
    public List<class_3222> getRandomBoogeyPlayers(List<class_3222> allowedPlayers, BoogeymanManager.BoogeymanRollType rollType) {
        List<class_3222> boogeyPlayers = super.getRandomBoogeyPlayers(allowedPlayers, rollType);
        int chooseBoogeymen = this.getBoogeymanAmount(rollType) - boogeyPlayers.size();
        if (chooseBoogeymen > 0) {
            List<class_3222> redPlayers = Main.livesManager.getRedPlayers();
            Collections.shuffle(redPlayers);
            for (class_3222 player : redPlayers) {
                if (chooseBoogeymen <= 0) break;
                if (this.isBoogeyman(player) || !allowedPlayers.contains(player) || this.rolledPlayers.contains(player.method_5667()) || this.BOOGEYMAN_IGNORE.contains(player.method_5820().toLowerCase(Locale.ROOT)) || this.BOOGEYMAN_FORCE.contains(player.method_5820().toLowerCase(Locale.ROOT)) || boogeyPlayers.contains(player)) continue;
                boogeyPlayers.add(player);
                --chooseBoogeymen;
            }
        }
        return boogeyPlayers;
    }

    @Override
    public List<class_3222> getAllowedBoogeyPlayers() {
        ArrayList<class_3222> result = new ArrayList<class_3222>();
        for (class_3222 player : Main.livesManager.getAlivePlayers()) {
            if (this.isBoogeyman(player)) continue;
            result.add(player);
        }
        return result;
    }
}

